/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PrevNextDifferenceIterableBase<T>
implements PrevNextDifferenceIterable {
    @NotNull
    protected abstract List<? extends T> getChanges();

    @NotNull
    protected abstract EditorEx getEditor();

    protected abstract int getStartLine(@NotNull T var1);

    protected abstract int getEndLine(@NotNull T var1);

    protected void scrollToChange(@NotNull T change) {
        if (change == null) {
            PrevNextDifferenceIterableBase.$$$reportNull$$$0(0);
        }
        DiffUtil.scrollEditor(this.getEditor(), this.getStartLine(change), true);
    }

    @Override
    public boolean canGoNext() {
        EditorEx editor;
        List<T> changes = this.getChanges();
        if (changes.isEmpty()) {
            return false;
        }
        int line = editor.getCaretModel().getLogicalPosition().line;
        editor = this.getEditor();
        if (line == DiffUtil.getLineCount(editor.getDocument()) - 1) {
            return false;
        }
        T lastChange = changes.get(changes.size() - 1);
        return this.getStartLine(lastChange) > line;
    }

    @Override
    public void goNext() {
        List<T> changes = this.getChanges();
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        T next = null;
        for (int i = 0; i < changes.size(); ++i) {
            T change = changes.get(i);
            if (this.getStartLine(change) <= line) continue;
            next = change;
            break;
        }
        assert (next != null);
        this.scrollToChange(next);
    }

    @Override
    public boolean canGoPrev() {
        List<T> changes = this.getChanges();
        if (changes.isEmpty()) {
            return false;
        }
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        if (line == 0) {
            return false;
        }
        T firstChange = changes.get(0);
        if (this.getEndLine(firstChange) > line) {
            return false;
        }
        return this.getStartLine(firstChange) < line;
    }

    @Override
    public void goPrev() {
        List<T> changes = this.getChanges();
        int line = this.getEditor().getCaretModel().getLogicalPosition().line;
        T prev2 = null;
        for (int i = 0; i < changes.size(); ++i) {
            T next;
            T change = changes.get(i);
            T t = next = i < changes.size() - 1 ? (T)changes.get(i + 1) : null;
            if (next != null && this.getEndLine(next) <= line && this.getStartLine(next) < line) continue;
            prev2 = change;
            break;
        }
        assert (prev2 != null);
        this.scrollToChange(prev2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/util/PrevNextDifferenceIterableBase", "scrollToChange"));
    }
}

