/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.FineMergeLineFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideTextDiffProvider
extends TextDiffProviderBase {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD};

    public SimpleThreesideTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        if (settings == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (rediff == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(2);
        }
        super(settings, rediff, disposable, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    @NotNull
    public List<FineMergeLineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (text3 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(6);
        }
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        ComparisonPolicy comparisonPolicy = ignorePolicy.getComparisonPolicy();
        List sequences = ContainerUtil.list((Object[])new CharSequence[]{text1, text2, text3});
        List lineOffsets = ContainerUtil.map((Collection)sequences, LineOffsetsUtil::create);
        indicator.checkCanceled();
        List lineFragments = ComparisonManager.getInstance().compareLines(text1, text2, text3, comparisonPolicy, indicator);
        indicator.checkCanceled();
        ArrayList<FineMergeLineFragment> result2 = new ArrayList<FineMergeLineFragment>(lineFragments.size());
        for (MergeLineFragment fragment : lineFragments) {
            MergeInnerDifferences innerDifferences;
            MergeConflictType conflictType = DiffUtil.getLineMergeType(fragment, sequences, lineOffsets, comparisonPolicy);
            if (highlightPolicy.isFineFragments()) {
                List<CharSequence> chunks = SimpleThreesideTextDiffProvider.getChunks(fragment, sequences, lineOffsets, conflictType);
                innerDifferences = DiffUtil.compareThreesideInner(chunks, comparisonPolicy, indicator);
            } else {
                innerDifferences = null;
            }
            result2.add(new FineMergeLineFragmentImpl(fragment, conflictType, innerDifferences));
        }
        ArrayList<FineMergeLineFragment> arrayList = result2;
        if (arrayList == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static List<CharSequence> getChunks(@NotNull MergeLineFragment fragment, @NotNull List<CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull MergeConflictType conflictType) {
        if (fragment == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(8);
        }
        if (sequences == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(9);
        }
        if (lineOffsets == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(10);
        }
        if (conflictType == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(11);
        }
        List list2 = ThreeSide.map(side -> {
            int endLine;
            if (conflictType == null) {
                SimpleThreesideTextDiffProvider.$$$reportNull$$$0(13);
            }
            if (fragment == null) {
                SimpleThreesideTextDiffProvider.$$$reportNull$$$0(14);
            }
            if (sequences == null) {
                SimpleThreesideTextDiffProvider.$$$reportNull$$$0(15);
            }
            if (lineOffsets == null) {
                SimpleThreesideTextDiffProvider.$$$reportNull$$$0(16);
            }
            if (!conflictType.isChange((ThreeSide)side)) {
                return null;
            }
            int startLine = fragment.getStartLine(side);
            if (startLine == (endLine = fragment.getEndLine(side))) {
                return null;
            }
            return DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), startLine, endLine);
        });
        if (list2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChunks";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChunks$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

