/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeViewStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;

public class TestContext {
    public static final DataKey<TestContext> DATA_KEY = DataKey.create((String)"JUNIT_CONTEXT");
    private final TestFrameworkRunningModel myModel;
    private final AbstractTestProxy mySelection;

    public TestContext(TestFrameworkRunningModel model, AbstractTestProxy selection) {
        this.myModel = model;
        this.mySelection = selection;
    }

    public TestFrameworkRunningModel getModel() {
        return this.myModel;
    }

    public AbstractTestProxy getSelection() {
        return this.mySelection;
    }

    public boolean hasSelection() {
        return this.getSelection() != null && this.getModel() != null;
    }

    public boolean treeContainsSelection() {
        AbstractTreeStructure structure = this.getModel().getTreeBuilder().getTreeStructure();
        return structure instanceof TestTreeViewStructure && ((TestTreeViewStructure)structure).getFilter().shouldAccept(this.getSelection());
    }

    public static TestContext from(AnActionEvent event) {
        return (TestContext)DATA_KEY.getData(event.getDataContext());
    }
}

