/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class CopyPathsAction
extends AnAction
implements DumbAware {
    public CopyPathsAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files2 != null && files2.length > 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyPathsAction.getPaths(files2)));
        }
    }

    private static String getPaths(VirtualFile[] files2) {
        StringBuilder buf = new StringBuilder(files2.length * 64);
        for (VirtualFile file2 : files2) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(file2.getPresentableUrl());
        }
        return buf.toString();
    }

    public void update(AnActionEvent event) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(event.getDataContext());
        int num = files2 != null ? files2.length : 0;
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(num > 0);
        presentation.setVisible(num > 0 || !ActionPlaces.isPopupPlace((String)event.getPlace()));
        presentation.setText(IdeBundle.message((String)(num == 1 ? "action.copy.path" : "action.copy.paths"), (Object[])new Object[0]));
    }
}

