/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.scopeView.NamedScopeFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.pom.NavigatableWithText;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.search.scope.ProblemsScope;
import com.intellij.psi.search.scope.ProjectFilesScope;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileListener;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileTreeModel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeViewTreeModel
extends BaseTreeModel<AbstractTreeNode>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(ScopeViewTreeModel.class);
    private volatile Comparator<NodeDescriptor> comparator;
    private final ProjectFileTreeModel model;
    private final ProjectNode root;

    public ScopeViewTreeModel(@NotNull Project project, @NotNull ViewSettings settings) {
        if (project == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(1);
        }
        this.model = new ProjectFileTreeModel(project);
        this.model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                if (type == TreeModelAdapter.EventType.StructureChanged) {
                    TreePath path = event.getTreePath();
                    if (path == null || null == path.getParentPath()) {
                        ScopeViewTreeModel.this.invalidate(null);
                    } else {
                        Object component = path.getLastPathComponent();
                        if (component instanceof ProjectFileNode) {
                            ProjectFileNode node = (ProjectFileNode)component;
                            ScopeViewTreeModel.this.notifyStructureChanged(node.getVirtualFile());
                        }
                    }
                }
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.model);
        this.root = new ProjectNode(project, settings);
        project.getMessageBus().connect((Disposable)this).subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.problemsDisappeared(file2);
            }

            public void problemsDisappeared(@NotNull VirtualFile file2) {
                NamedScopeFilter filter;
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((filter = ScopeViewTreeModel.this.getFilter()) != null && filter.getScope() instanceof ProblemsScope) {
                    ScopeViewTreeModel.this.model.setFilter(filter);
                } else {
                    ScopeViewTreeModel.this.notifyPresentationChanged(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FileStatusManager.getInstance((Project)project).addFileStatusListener(new FileStatusListener(){

            public void fileStatusChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                ScopeViewTreeModel.this.notifyPresentationChanged(file2);
            }

            public void fileStatusesChanged() {
                ScopeViewTreeModel.this.invalidate(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scopeView/ScopeViewTreeModel$3", "fileStatusChanged"));
            }
        }, (Disposable)this);
    }

    public void setStructureProvider(TreeStructureProvider provider) {
        this.model.onValidThread(() -> {
            if (this.root.provider == null && provider == null) {
                return;
            }
            this.root.provider = provider;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setNodeDecorator(ProjectViewNodeDecorator decorator) {
        this.model.onValidThread(() -> {
            if (this.root.decorator == null && decorator == null) {
                return;
            }
            this.root.decorator = decorator;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setComparator(Comparator<NodeDescriptor> comparator2) {
        this.model.onValidThread(() -> {
            if (this.comparator == null && comparator2 == null) {
                return;
            }
            this.comparator = comparator2;
            this.treeStructureChanged(null, null, null);
        });
    }

    public void setFilter(@Nullable NamedScopeFilter filter) {
        this.root.filter = filter;
        LOG.debug("set filter", new Object[]{filter});
        this.model.setFilter((VirtualFileFilter)(filter != null && filter.getScope() instanceof ProjectFilesScope ? null : filter));
    }

    public NamedScopeFilter getFilter() {
        return this.root.filter;
    }

    @Nullable
    public Object getContent(Object object) {
        Node node;
        if (object instanceof GroupNode) {
            node = (GroupNode)((Object)object);
            object = ((GroupNode)node).getSingleRoot();
        }
        if (object instanceof FileNode) {
            node = (FileNode)((Object)object);
            PsiFileSystemItem element = node.findFileSystemItem(((FileNode)node).getVirtualFile());
            if (element == null || ((FileNode)node).compacted == null) {
                return element;
            }
            if (AllIcons.Nodes.Package == node.getIcon() && node.getSettings().isFlattenPackages()) {
                return element;
            }
            ArrayDeque<PsiFileSystemItem> deque = new ArrayDeque<PsiFileSystemItem>();
            ((FileNode)node).compacted.forEach(arg_0 -> ScopeViewTreeModel.lambda$getContent$3((FileNode)node, deque, arg_0));
            if (deque.isEmpty()) {
                return element;
            }
            deque.addFirst(element);
            return deque.toArray();
        }
        if (object instanceof NodeDescriptor) {
            NodeDescriptor descriptor2 = (NodeDescriptor)object;
            object = descriptor2.getElement();
        }
        if (object instanceof AbstractTreeNode) {
            node = (AbstractTreeNode)object;
            object = node.getValue();
        }
        return object;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.model.getInvoker();
        if (invoker == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(2);
        }
        return invoker;
    }

    public void invalidate(@Nullable Runnable onDone) {
        this.model.onValidThread(() -> {
            this.root.childrenValid = false;
            LOG.debug("whole structure changed");
            ViewSettings settings = this.root.getSettings();
            this.model.setSettings(settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles(), ShowModulesAction.hasModules() && settings.isShowModules());
            this.treeStructureChanged(null, null, null);
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    private void update(@NotNull AbstractTreeNode node, boolean structure) {
        if (node == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(3);
        }
        this.model.onValidThread(() -> {
            boolean changed;
            if (node == null) {
                ScopeViewTreeModel.$$$reportNull$$$0(19);
            }
            boolean updated = node.update();
            boolean bl = changed = structure || !(node instanceof Node);
            if (!updated && !changed) {
                return;
            }
            TreePath path = TreePathUtil.pathToCustomNode(node, AbstractTreeNode::getParent);
            if (path == null || this.root != path.getPathComponent(0)) {
                return;
            }
            if (changed) {
                LOG.debug("structure changed: ", new Object[]{node});
                this.treeStructureChanged(path, null, null);
            } else {
                LOG.debug("node updated: ", new Object[]{node});
                this.treeNodesChanged(path, null, null);
            }
        });
    }

    private void notifyStructureChanged(@NotNull VirtualFile file2) {
        boolean flattenPackages;
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(4);
        }
        if (flattenPackages = this.root.getSettings().isFlattenPackages()) {
            VirtualFile ancestor;
            ProjectFileIndex index = ScopeViewTreeModel.getProjectFileIndex(this.root.getProject());
            VirtualFile virtualFile = ancestor = index == null ? null : index.getSourceRootForFile(file2);
            if (ancestor != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
                file2 = ancestor;
            } else {
                flattenPackages = false;
            }
        }
        boolean resolveCompactedFolder = !flattenPackages && file2.isDirectory() && this.root.getSettings().isCompactDirectories();
        this.find(file2, null, (Consumer<Object>)((Consumer)found -> {
            if (found instanceof Node) {
                AbstractTreeNode parent;
                Node node = (Node)((Object)((Object)found));
                if (resolveCompactedFolder && (parent = node.getParent()) instanceof Node) {
                    node = (Node)parent;
                }
                if (node.childrenValid) {
                    node.childrenValid = false;
                    this.update((AbstractTreeNode)node, true);
                }
            } else if (found instanceof AbstractTreeNode) {
                this.update((AbstractTreeNode)found, true);
            }
        }));
    }

    private void notifyPresentationChanged(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(5);
        }
        while (!file2.isValid()) {
            if ((file2 = file2.getParent()) != null) continue;
            return;
        }
        SmartList list2 = new SmartList();
        this.find(file2, (List<Node>)list2, (Consumer<Object>)((Consumer)arg_0 -> this.lambda$notifyPresentationChanged$8((List)list2, arg_0)));
    }

    private void find(@NotNull VirtualFile file2, final @Nullable List<Node> list2, @NotNull Consumer<Object> consumer) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(7);
        }
        this.model.onValidThread(() -> {
            AreaInstance area;
            if (file2 == null) {
                ScopeViewTreeModel.$$$reportNull$$$0(16);
            }
            if (consumer == null) {
                ScopeViewTreeModel.$$$reportNull$$$0(17);
            }
            if ((area = ProjectFileListener.findArea(file2, this.root.getProject())) != null) {
                TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode> visitor2 = new TreeVisitor.ByComponent<VirtualFile, AbstractTreeNode>(file2, AbstractTreeNode.class){

                    protected boolean matches(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        if (pathComponent == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (thisComponent == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        if (pathComponent.canRepresent((Object)thisComponent)) {
                            return true;
                        }
                        if (pathComponent instanceof Node) {
                            return false;
                        }
                        ProjectViewNode node = pathComponent instanceof ProjectViewNode ? (ProjectViewNode)pathComponent : null;
                        return node != null && node.contains(thisComponent);
                    }

                    protected boolean contains(@NotNull AbstractTreeNode pathComponent, @NotNull VirtualFile thisComponent) {
                        Node node;
                        if (pathComponent == null) {
                            4.$$$reportNull$$$0(2);
                        }
                        if (thisComponent == null) {
                            4.$$$reportNull$$$0(3);
                        }
                        Node node2 = node = pathComponent instanceof Node ? (Node)pathComponent : null;
                        if (node == null || !node.contains(thisComponent, area)) {
                            return false;
                        }
                        if (list2 != null) {
                            list2.add(node);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "pathComponent";
                                break;
                            }
                            case 1: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "thisComponent";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$4";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "matches";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contains";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                AbstractTreeWalker<AbstractTreeNode> walker = new AbstractTreeWalker<AbstractTreeNode>((TreeVisitor)visitor2){

                    @Override
                    protected Collection<AbstractTreeNode> getChildren(@NotNull AbstractTreeNode pathComponent) {
                        if (pathComponent == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        Node node = pathComponent instanceof Node ? (Node)pathComponent : null;
                        return node != null && node.childrenValid ? node.children : Collections.emptyList();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathComponent", "com/intellij/ide/scopeView/ScopeViewTreeModel$5", "getChildren"));
                    }
                };
                walker.start((AbstractTreeNode)this.root);
                walker.promise().onProcessed(path -> {
                    if (consumer == null) {
                        ScopeViewTreeModel.$$$reportNull$$$0(18);
                    }
                    consumer.consume(path == null ? null : path.getLastPathComponent());
                });
            }
        });
    }

    public Object getRoot() {
        if (!this.model.isValidThread()) {
            return null;
        }
        this.root.update();
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof AbstractTreeNode && this.model.isValidThread()) {
            AbstractTreeNode node = (AbstractTreeNode)object;
            return node.getChildren().size();
        }
        return 0;
    }

    @Override
    @NotNull
    public List<AbstractTreeNode> getChildren(Object object) {
        AbstractTreeNode parent;
        Collection children2;
        if (object instanceof AbstractTreeNode && this.model.isValidThread() && !(children2 = (parent = (AbstractTreeNode)object).getChildren()).isEmpty()) {
            SmartList result2 = new SmartList();
            children2.forEach(arg_0 -> ScopeViewTreeModel.lambda$getChildren$11(parent, (List)result2, arg_0));
            Comparator<NodeDescriptor> comparator2 = this.comparator;
            if (comparator2 != null) {
                result2.sort(comparator2);
            }
            SmartList smartList = result2;
            if (smartList == null) {
                ScopeViewTreeModel.$$$reportNull$$$0(8);
            }
            return smartList;
        }
        List<AbstractTreeNode> list2 = Collections.emptyList();
        if (list2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    ErrorStripe getStripe(Object object, boolean expanded) {
        if (expanded && object instanceof Node) {
            return null;
        }
        if (object instanceof PresentableNodeDescriptor) {
            Color color;
            PresentableNodeDescriptor node = (PresentableNodeDescriptor)object;
            TextAttributesKey key = node.getPresentation().getTextAttributesKey();
            TextAttributes attributes = key == null ? null : EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(key);
            Color color2 = color = attributes == null ? null : attributes.getErrorStripeColor();
            if (color != null) {
                return ErrorStripe.create(color, 1);
            }
        }
        return null;
    }

    @Nullable
    private static WolfTheProblemSolver getWolfTheProblemSolver(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : WolfTheProblemSolver.getInstance((Project)project);
    }

    @Nullable
    private static FileStatusManager getFileStatusManager(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : FileStatusManager.getInstance((Project)project);
    }

    @Nullable
    private static ModuleManager getModuleManager(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ModuleManager.getInstance((Project)project);
    }

    @Nullable
    private static ProjectFileIndex getProjectFileIndex(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ProjectFileIndex.getInstance((Project)project);
    }

    @Nullable
    private static ModuleRootManager getModuleRootManager(@Nullable Module module2) {
        return module2 == null || module2.isDisposed() ? null : ModuleRootManager.getInstance((Module)module2);
    }

    @Nullable
    private static ProjectSettingsService getProjectSettingsService(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ProjectSettingsService.getInstance(project);
    }

    @Nullable
    private static Module getModule(@NotNull VirtualFile file2, @Nullable Project project) {
        ProjectFileIndex index;
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(10);
        }
        return (index = ScopeViewTreeModel.getProjectFileIndex(project)) == null ? null : index.getModuleForFile(file2);
    }

    @Nullable
    private static String getPackageName(@Nullable PsiElement element) {
        String name;
        PsiDirectoryFactory factory;
        if (element instanceof PsiDirectory && element.isValid() && (factory = PsiDirectoryFactory.getInstance(element.getProject())) != null && factory.isPackage((PsiDirectory)element) && factory.isValidPackageName(name = factory.getQualifiedName((PsiDirectory)element, false))) {
            return name;
        }
        return null;
    }

    private static boolean hasModuleGroups(@Nullable Project project) {
        if (Registry.is((String)"project.qualified.module.names")) {
            return true;
        }
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project);
        return manager != null && manager.hasModuleGroups();
    }

    @NotNull
    private static List<String> getModuleNameAsList(@NotNull Module module2, boolean split) {
        if (module2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(11);
        }
        String name = module2.getName();
        Project project = module2.isDisposed() ? null : module2.getProject();
        ModuleManager manager = ScopeViewTreeModel.getModuleManager(project);
        if (manager != null) {
            if (manager.hasModuleGroups()) {
                Object[] path = manager.getModuleGroupPath(module2);
                if (path != null && path.length != 0) {
                    SmartList list2 = new SmartList(path);
                    list2.add(name);
                    SmartList smartList = list2;
                    if (smartList == null) {
                        ScopeViewTreeModel.$$$reportNull$$$0(12);
                    }
                    return smartList;
                }
            } else if (split) {
                List list3 = StringUtil.split((String)name, (String)".");
                if (list3 == null) {
                    ScopeViewTreeModel.$$$reportNull$$$0(13);
                }
                return list3;
            }
        }
        SmartList smartList = new SmartList((Object)name);
        if (smartList == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @Nullable
    private static List<VirtualFile> getCompactedFolders(@Nullable VirtualFile ancestor, @NotNull VirtualFile file2) {
        if (file2 == null) {
            ScopeViewTreeModel.$$$reportNull$$$0(15);
        }
        if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
            return null;
        }
        ArrayDeque<VirtualFile> deque = new ArrayDeque<VirtualFile>();
        while ((file2 = file2.getParent()) != null && VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)true)) {
            deque.addFirst(file2);
        }
        return deque.isEmpty() ? null : new SmartList(deque);
    }

    private static /* synthetic */ void lambda$getChildren$11(AbstractTreeNode parent, List result2, Object child) {
        if (child instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)child;
            node.setParent(parent);
            node.update();
            result2.add(node);
        }
    }

    private /* synthetic */ void lambda$notifyPresentationChanged$8(List list2, Object found) {
        list2.forEach(node -> this.update((AbstractTreeNode)node, false));
        if (found instanceof AbstractTreeNode) {
            this.update((AbstractTreeNode)found, false);
        }
    }

    private static /* synthetic */ void lambda$getContent$3(FileNode node, ArrayDeque deque, VirtualFile file2) {
        PsiFileSystemItem item = node.findFileSystemItem(file2);
        if (item != null) {
            deque.addFirst(item);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameAsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyStructureChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyPresentationChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameAsList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompactedFolders";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$find$10";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$9";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$update$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Mapper<N extends Node, V> {
        private final HashMap<Object, N> map;
        private final BiFunction<Node, V, N> creator;

        Mapper(@NotNull BiFunction<Node, V, N> creator, @NotNull HashMap<Object, N> map2) {
            if (creator == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            if (map2 == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            this.creator = creator;
            this.map = map2;
        }

        Mapper(@NotNull BiFunction<Node, V, N> creator, @NotNull Class<N> type, @NotNull Collection<? extends AbstractTreeNode> list2) {
            if (creator == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            if (type == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            this(creator, new HashMap());
            list2.forEach(node -> {
                Object id;
                if (type == null) {
                    Mapper.$$$reportNull$$$0(11);
                }
                if ((id = node.getValue()) != null && type.isInstance(node)) {
                    this.map.put(id, type.cast(node));
                }
            });
        }

        @NotNull
        N apply(@NotNull Node parent, @NotNull V value) {
            if (parent == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            if (value == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            N n = this.apply(parent, value, null);
            if (n == null) {
                Mapper.$$$reportNull$$$0(7);
            }
            return n;
        }

        @NotNull
        N apply(@NotNull Node parent, @NotNull V value, @Nullable Icon icon) {
            Node node;
            if (parent == null) {
                Mapper.$$$reportNull$$$0(8);
            }
            if (value == null) {
                Mapper.$$$reportNull$$$0(9);
            }
            Node node2 = node = this.map.isEmpty() ? null : (Node)((Object)this.map.get(value));
            if (node == null) {
                node = (Node)((Object)this.creator.apply(parent, value));
            }
            node.setIcon(icon);
            node.childrenValid = false;
            Node node3 = node;
            if (node3 == null) {
                Mapper.$$$reportNull$$$0(10);
            }
            return (N)((Object)node3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "creator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Mapper";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 7: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Group {
        private final Object id;
        private final HashMap<Object, Group> groups;
        private final List<RootNode> roots;

        private Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.groups = new HashMap();
            this.roots = new SmartList();
            this.id = name;
        }

        private Group(@NotNull Module module2) {
            if (module2 == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.groups = new HashMap();
            this.roots = new SmartList();
            this.id = module2;
        }

        Group(@NotNull Collection<RootNode> nodes, boolean flatten) {
            if (nodes == null) {
                Group.$$$reportNull$$$0(2);
            }
            this.groups = new HashMap();
            this.roots = new SmartList();
            this.id = null;
            if (!nodes.isEmpty()) {
                HashMap<Module, Group> map2 = new HashMap<Module, Group>();
                nodes.forEach(node -> {
                    Object id = node.node.getRootID();
                    if (id instanceof Module) {
                        Module module2 = (Module)id;
                        Group group = (Group)map2.get(module2);
                        if (group == null) {
                            group = new Group(module2);
                            map2.put(module2, group);
                        }
                        group.roots.add((RootNode)((Object)node));
                    } else {
                        this.roots.add((RootNode)((Object)node));
                    }
                });
                if (flatten) {
                    this.groups.putAll(map2);
                } else {
                    map2.forEach((module2, group) -> {
                        List path = ScopeViewTreeModel.getModuleNameAsList(module2, Registry.is((String)"project.qualified.module.names"));
                        group.roots.forEach(node -> this.add((RootNode)((Object)((Object)node)), path, 0));
                    });
                }
            }
        }

        private void add(RootNode node, List<String> path, int index) {
            if (index < path.size()) {
                String name = path.get(index);
                Group group = this.groups.get(name);
                if (group == null) {
                    group = new Group(name);
                    this.groups.put(name, group);
                }
                group.add(node, path, index + 1);
            } else {
                this.roots.add(node);
            }
        }

        @NotNull
        Icon getIcon() {
            if (!this.groups.isEmpty() || this.roots.isEmpty()) {
                Icon icon = AllIcons.Nodes.ModuleGroup;
                if (icon == null) {
                    Group.$$$reportNull$$$0(3);
                }
                return icon;
            }
            Object id = this.roots.get((int)0).node.getRootID();
            if (this.roots.stream().anyMatch(root -> !root.node.getRootID().equals(id))) {
                Icon icon = AllIcons.Nodes.ModuleGroup;
                if (icon == null) {
                    Group.$$$reportNull$$$0(4);
                }
                return icon;
            }
            Icon icon = id instanceof Module ? ModuleType.get((Module)((Module)id)).getIcon() : AllIcons.Nodes.Module;
            if (icon == null) {
                Group.$$$reportNull$$$0(5);
            }
            return icon;
        }

        @Nullable
        RootNode getFirstRoot() {
            if (!this.roots.isEmpty()) {
                return this.roots.get(0);
            }
            for (Group group : this.groups.values()) {
                RootNode root = group.getFirstRoot();
                if (root == null) continue;
                return root;
            }
            return null;
        }

        @Nullable
        RootNode getSingleRoot() {
            if (!this.groups.isEmpty() || this.roots.size() != 1) {
                return null;
            }
            RootNode node = this.roots.get(0);
            ModuleRootManager manager = ScopeViewTreeModel.getModuleRootManager(ScopeViewTreeModel.getModule(node.getVirtualFile(), node.getProject()));
            if (manager == null) {
                return null;
            }
            for (VirtualFile file2 : manager.getSourceRoots()) {
                if (VfsUtilCore.isAncestor((VirtualFile)node.getVirtualFile(), (VirtualFile)file2, (boolean)true)) continue;
                return null;
            }
            return node;
        }

        @Nullable
        private Group getSingleGroup() {
            if (!this.roots.isEmpty() || this.groups.size() != 1) {
                return null;
            }
            return this.groups.values().stream().findFirst().orElse(null);
        }

        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Node parent, @NotNull Collection<AbstractTreeNode> old) {
            if (parent == null) {
                Group.$$$reportNull$$$0(6);
            }
            if (old == null) {
                Group.$$$reportNull$$$0(7);
            }
            Mapper<GroupNode, Object> mapper = new Mapper<GroupNode, Object>(GroupNode::new, GroupNode.class, old);
            ModuleManager manager = ScopeViewTreeModel.getModuleManager(parent.getProject());
            char separator = manager != null && manager.hasModuleGroups() ? (char)'/' : '.';
            boolean compactDirectories = parent.getSettings().isCompactDirectories();
            SmartList children2 = new SmartList();
            for (Group group : this.groups.values()) {
                Group single;
                Object id = group.id;
                Group group2 = single = !compactDirectories ? null : group.getSingleGroup();
                if (single != null) {
                    StringBuilder sb = new StringBuilder(id.toString());
                    do {
                        group = single;
                        sb.append(separator).append(group.id);
                    } while ((single = single.getSingleGroup()) != null);
                    id = sb.toString();
                }
                GroupNode node = mapper.apply(parent, id);
                node.setGroup(group);
                children2.add(node);
            }
            children2.addAll(this.roots);
            SmartList smartList = children2;
            if (smartList == null) {
                Group.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                Group.$$$reportNull$$$0(9);
            }
            if (area == null) {
                Group.$$$reportNull$$$0(10);
            }
            return this.roots.stream().anyMatch(root -> {
                if (file2 == null) {
                    Group.$$$reportNull$$$0(13);
                }
                if (area == null) {
                    Group.$$$reportNull$$$0(14);
                }
                return root.canRepresentOrContain(file2, area);
            }) || this.groups.values().stream().anyMatch(group -> {
                if (file2 == null) {
                    Group.$$$reportNull$$$0(11);
                }
                if (area == null) {
                    Group.$$$reportNull$$$0(12);
                }
                return group.contains(file2, area);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Group";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Group";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$contains$5";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$contains$4";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class GroupNode
    extends Node
    implements NavigatableWithText {
        private final String prefix;
        private final String name;
        private Group group;

        GroupNode(@NotNull Node parent, @NotNull Object value) {
            if (parent == null) {
                GroupNode.$$$reportNull$$$0(0);
            }
            if (value == null) {
                GroupNode.$$$reportNull$$$0(1);
            }
            super(parent, value);
            if (value instanceof Module) {
                List list2 = ScopeViewTreeModel.getModuleNameAsList((Module)value, false);
                int index = list2.size() - 1;
                if (index > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < index; ++i) {
                        sb.append((String)list2.get(i)).append('/');
                    }
                    this.prefix = sb.toString();
                    this.name = (String)list2.get(index);
                } else {
                    this.prefix = null;
                    this.name = index < 0 ? "UNEXPECTED" : (String)list2.get(index);
                }
            } else {
                this.prefix = null;
                this.name = value.toString();
            }
        }

        void setGroup(@NotNull Group group) {
            if (group == null) {
                GroupNode.$$$reportNull$$$0(2);
            }
            this.group = group;
            this.childrenValid = false;
            this.setIcon(group.getIcon());
        }

        @Nullable
        RootNode getSingleRoot() {
            Group group = this.group;
            return group == null ? null : group.getSingleRoot();
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            RootNode node = this.getSingleRoot();
            return node == null ? null : node.getVirtualFile();
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(this.getIcon());
            if (this.prefix != null) {
                presentation.addText(this.prefix, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            presentation.addText(this.name, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.decorate(presentation);
        }

        @Override
        @Nullable
        String getLocation() {
            RootNode node = this.getSingleRoot();
            return node == null ? null : node.getTitle();
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<AbstractTreeNode> old) {
            Group group;
            if (old == null) {
                GroupNode.$$$reportNull$$$0(3);
            }
            if ((group = this.group) == null) {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    GroupNode.$$$reportNull$$$0(4);
                }
                return list2;
            }
            RootNode node = group.getSingleRoot();
            if (node == null) {
                Collection<AbstractTreeNode> collection = group.createChildren(this, old);
                if (collection == null) {
                    GroupNode.$$$reportNull$$$0(5);
                }
                return collection;
            }
            node.setParent((AbstractTreeNode)this);
            Collection<AbstractTreeNode> collection = node.getChildren();
            if (collection == null) {
                GroupNode.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            Group group;
            if (file2 == null) {
                GroupNode.$$$reportNull$$$0(7);
            }
            if (area == null) {
                GroupNode.$$$reportNull$$$0(8);
            }
            return (group = this.group) != null && group.contains(file2, area);
        }

        public boolean canNavigate() {
            Group group = this.group;
            RootNode node = group == null ? null : group.getFirstRoot();
            return node != null && node.canNavigate();
        }

        public void navigate(boolean requestFocus) {
            RootNode node;
            Group group = this.group;
            RootNode rootNode = node = group == null ? null : group.getFirstRoot();
            if (node != null) {
                node.navigate(requestFocus);
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        public int getTypeSortWeight(boolean sortByType) {
            return 2;
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @NotNull
        public String toString() {
            String string = this.prefix != null ? this.prefix + this.name : this.name;
            if (string == null) {
                GroupNode.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$GroupNode";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$GroupNode";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setGroup";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class RootNode
    extends FileNode
    implements NavigatableWithText {
        RootNode(@NotNull Node parent, @NotNull ProjectFileNode node) {
            if (parent == null) {
                RootNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                RootNode.$$$reportNull$$$0(1);
            }
            super(parent, node);
        }

        boolean canRepresentOrContain(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                RootNode.$$$reportNull$$$0(2);
            }
            if (area == null) {
                RootNode.$$$reportNull$$$0(3);
            }
            return this.node.contains(file2, area, false);
        }

        @Override
        public int getWeight() {
            return this.node.getRootID() instanceof Project ? 0 : super.getWeight();
        }

        @Override
        public int getTypeSortWeight(boolean sortByType) {
            return this.node.getRootID() instanceof Project ? 1 : super.getTypeSortWeight(sortByType);
        }

        @NotNull
        public String getTitle() {
            String string = this.getLocation(false);
            if (string == null) {
                RootNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.getLocation(true);
            if (string == null) {
                RootNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private String getLocation(boolean allowEmpty) {
            String location;
            Project project = this.getProject();
            VirtualFile dir = project == null || project.isDisposed() ? null : project.getBaseDir();
            String string = location = dir == null ? null : VfsUtilCore.getRelativePath((VirtualFile)this.getVirtualFile(), (VirtualFile)dir);
            if (location != null && (allowEmpty || !location.isEmpty())) {
                String string2 = location;
                if (string2 == null) {
                    RootNode.$$$reportNull$$$0(6);
                }
                return string2;
            }
            String string3 = FileUtil.getLocationRelativeToUserHome((String)this.getVirtualFile().getPresentableUrl());
            if (string3 == null) {
                RootNode.$$$reportNull$$$0(7);
            }
            return string3;
        }

        public boolean canNavigate() {
            return null != ScopeViewTreeModel.getProjectSettingsService(this.getProject());
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService service2 = ScopeViewTreeModel.getProjectSettingsService(this.getProject());
            if (service2 != null) {
                Module module2 = ScopeViewTreeModel.getModule(this.getVirtualFile(), this.getProject());
                if (module2 != null && service2.canOpenModuleSettings()) {
                    service2.openModuleSettings(module2);
                } else {
                    service2.openProjectSettings();
                }
            }
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$RootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$RootNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresentOrContain";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileNode
    extends Node {
        final List<VirtualFile> compacted;
        final ProjectFileNode node;
        volatile String packageName;
        volatile String nodeName;

        FileNode(@NotNull Node parent, @NotNull ProjectFileNode node) {
            if (parent == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            super(parent, node);
            this.node = node;
            this.compacted = ScopeViewTreeModel.getCompactedFolders(parent.getVirtualFile(), node.getVirtualFile());
        }

        public void setIcon(@Nullable Icon icon) {
            super.setIcon(icon);
            this.packageName = icon != AllIcons.Nodes.Package ? null : ScopeViewTreeModel.getPackageName((PsiElement)this.findFileSystemItem(this.getVirtualFile()));
            this.nodeName = this.getNodeName(this.packageName);
        }

        protected void update(PresentationData presentation) {
            ProjectFileIndex index;
            VirtualFile file2 = this.getVirtualFile();
            String title = this.getTitle();
            SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (this.node.getRootID() instanceof VirtualFile && (index = ScopeViewTreeModel.getProjectFileIndex(this.getProject())) != null && file2.equals(index.getContentRootForFile(file2))) {
                attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            presentation.addText(title != null ? title : this.toString(), attributes);
            Icon icon = this.getIcon();
            if (icon == null && file2.isValid()) {
                icon = file2.isDirectory() ? this.getFolderIcon(this.node, null) : file2.getFileType().getIcon();
            }
            presentation.setIcon(icon);
            this.decorate(presentation);
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<AbstractTreeNode> old) {
            ProjectNode parent;
            if (old == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            if ((parent = this.findParent(ProjectNode.class)) == null) {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(3);
                }
                return list2;
            }
            Collection<AbstractTreeNode> collection = parent.createChildren(this, old);
            if (collection == null) {
                FileNode.$$$reportNull$$$0(4);
            }
            return collection;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean canRepresent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(5);
            }
            if (super.canRepresent(file2)) return true;
            if (this.compacted == null) return false;
            if (!this.compacted.stream().anyMatch(file2::equals)) return false;
            return true;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(6);
            }
            if (area == null) {
                FileNode.$$$reportNull$$$0(7);
            }
            return this.node.contains(file2, area, true);
        }

        public FileStatus getFileStatus() {
            FileStatusManager manager = ScopeViewTreeModel.getFileStatusManager(this.getProject());
            return manager == null ? FileStatus.NOT_CHANGED : manager.getRecursiveStatus(this.getVirtualFile());
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.node.getVirtualFile();
            if (virtualFile == null) {
                FileNode.$$$reportNull$$$0(8);
            }
            return virtualFile;
        }

        @Override
        public int getWeight() {
            ViewSettings settings;
            if (this.getVirtualFile().isDirectory() && ((settings = this.getSettings()) == null || settings.isFoldersAlwaysOnTop())) {
                return 0;
            }
            return 20;
        }

        public int getTypeSortWeight(boolean sortByType) {
            return this.getVirtualFile().isDirectory() ? 3 : 5;
        }

        @NotNull
        public String toString() {
            String string = this.nodeName;
            if (string == null) {
                FileNode.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        private String getNodeName(@Nullable String name) {
            if (name != null) {
                String prefix;
                AbstractTreeNode parent = this.getParent();
                FileNode node = parent instanceof FileNode ? (FileNode)parent : null;
                String string = prefix = node == null ? null : node.packageName;
                if (prefix == null) {
                    String string2 = name;
                    if (string2 == null) {
                        FileNode.$$$reportNull$$$0(10);
                    }
                    return string2;
                }
                int length = prefix.length();
                if (length > 0 && name.startsWith(prefix)) {
                    if (length < name.length() && '.' == name.charAt(length)) {
                        ++length;
                    }
                    if (length < name.length()) {
                        String string3 = name.substring(length);
                        if (string3 == null) {
                            FileNode.$$$reportNull$$$0(11);
                        }
                        return string3;
                    }
                }
                LOG.info("unexpected prefix: " + prefix + " for package: " + name);
            }
            if (this.compacted != null) {
                StringBuilder sb = new StringBuilder();
                char separator = AllIcons.Nodes.Package == this.getIcon() ? (char)'.' : '/';
                this.compacted.forEach(file2 -> sb.append(file2.getName()).append(separator));
                String string = sb.append(this.getVirtualFile().getName()).toString();
                if (string == null) {
                    FileNode.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = this.getVirtualFile().getName();
            if (string == null) {
                FileNode.$$$reportNull$$$0(13);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$FileNode";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$FileNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresent";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ProjectNode
    extends Node {
        private volatile HashMap<Object, RootNode> roots;
        volatile TreeStructureProvider provider;
        volatile ProjectViewNodeDecorator decorator;

        ProjectNode(@NotNull Project project, ViewSettings settings) {
            if (project == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            super(project, project, settings);
            this.roots = new HashMap();
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(AllIcons.Nodes.Project);
            presentation.setPresentableText(this.toString());
            this.decorate(presentation);
        }

        @Override
        @Nullable
        String getLocation() {
            Project project = this.getProject();
            return project == null || project.isDisposed() ? null : FileUtil.getLocationRelativeToUserHome((String)project.getPresentableUrl());
        }

        @Override
        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Collection<AbstractTreeNode> old) {
            if (old == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            HashMap<Object, RootNode> oldRoots = this.roots;
            HashMap newRoots = new HashMap();
            Mapper<RootNode, ProjectFileNode> mapper = new Mapper<RootNode, ProjectFileNode>(RootNode::new, oldRoots);
            ScopeViewTreeModel.this.model.getChildren(ScopeViewTreeModel.this.model.getRoot()).forEach(child -> {
                RootNode cfr_ignored_0 = (RootNode)((Object)((Object)newRoots.put(child, mapper.apply(this, (ProjectFileNode)child))));
            });
            this.roots = newRoots;
            if (newRoots.isEmpty()) {
                List<AbstractTreeNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    ProjectNode.$$$reportNull$$$0(3);
                }
                return list2;
            }
            Collection<AbstractTreeNode> collection = new Group(newRoots.values(), this.getSettings().isFlattenModules() || !ScopeViewTreeModel.hasModuleGroups(this.getProject())).createChildren(this, old);
            if (collection == null) {
                ProjectNode.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        Collection<AbstractTreeNode> createChildren(@NotNull Node parent, @NotNull Collection<AbstractTreeNode> old) {
            if (parent == null) {
                ProjectNode.$$$reportNull$$$0(5);
            }
            if (old == null) {
                ProjectNode.$$$reportNull$$$0(6);
            }
            boolean flattenPackages = this.getSettings().isFlattenPackages();
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            boolean compactDirectories = this.getSettings().isCompactDirectories();
            Mapper<FileNode, ProjectFileNode> mapper = new Mapper<FileNode, ProjectFileNode>(FileNode::new, FileNode.class, old);
            SmartList children2 = new SmartList();
            SmartList files2 = new SmartList();
            TreeStructureProvider provider = this.provider;
            ScopeViewTreeModel.this.model.getChildren(parent.getValue()).forEach(arg_0 -> this.lambda$createChildren$2(flattenPackages, compactDirectories, (List)children2, mapper, parent, hideEmptyMiddlePackages, provider, (List)files2, arg_0));
            if (provider == null) {
                SmartList smartList = children2;
                if (smartList == null) {
                    ProjectNode.$$$reportNull$$$0(7);
                }
                return smartList;
            }
            children2.addAll(provider.modify((AbstractTreeNode)parent, (Collection)files2.stream().map(file2 -> new PsiFileNode(this.getProject(), (PsiFile)file2, this.getSettings())).collect(Collectors.toList()), this.getSettings()));
            SmartList smartList = children2;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        private void visitPackages(@NotNull ProjectFileNode parent, boolean hideEmptyMiddle, @NotNull Consumer<ProjectFileNode> consumer) {
            if (parent == null) {
                ProjectNode.$$$reportNull$$$0(9);
            }
            if (consumer == null) {
                ProjectNode.$$$reportNull$$$0(10);
            }
            AtomicBoolean empty = new AtomicBoolean(hideEmptyMiddle);
            AtomicBoolean middle = new AtomicBoolean();
            ScopeViewTreeModel.this.model.getChildren(parent).forEach(child -> {
                PsiFileSystemItem element;
                if (consumer == null) {
                    ProjectNode.$$$reportNull$$$0(16);
                }
                if ((element = this.findFileSystemItem(child.getVirtualFile())) instanceof PsiDirectory) {
                    Icon icon = this.getFolderIcon((ProjectFileNode)child, (PsiElement)element);
                    if (icon == AllIcons.Nodes.Package) {
                        if (hideEmptyMiddle) {
                            middle.set(true);
                        }
                        this.visitPackages((ProjectFileNode)child, hideEmptyMiddle, consumer);
                    } else if (hideEmptyMiddle) {
                        empty.set(false);
                    }
                } else if (element instanceof PsiFile && hideEmptyMiddle) {
                    empty.set(false);
                }
            });
            if (!empty.get() || !middle.get()) {
                consumer.consume((Object)parent);
            }
        }

        @Nullable
        private ProjectFileNode getSingleDirectory(ProjectFileNode parent) {
            List<ProjectFileNode> children2 = ScopeViewTreeModel.this.model.getChildren(parent);
            ProjectFileNode child = children2.size() != 1 ? null : children2.get(0);
            return child != null && child.getVirtualFile().isDirectory() ? child : null;
        }

        @Override
        boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area) {
            if (file2 == null) {
                ProjectNode.$$$reportNull$$$0(11);
            }
            if (area == null) {
                ProjectNode.$$$reportNull$$$0(12);
            }
            return this.roots.values().stream().anyMatch(root -> {
                if (file2 == null) {
                    ProjectNode.$$$reportNull$$$0(14);
                }
                if (area == null) {
                    ProjectNode.$$$reportNull$$$0(15);
                }
                return root.canRepresentOrContain(file2, area);
            });
        }

        public int getTypeSortWeight(boolean sortByType) {
            return 1;
        }

        @NotNull
        public String toString() {
            Project project = this.getProject();
            String string = project == null || project.isDisposed() ? "DISPOSED PROJECT" : project.getName();
            if (string == null) {
                ProjectNode.$$$reportNull$$$0(13);
            }
            return string;
        }

        private /* synthetic */ void lambda$createChildren$2(boolean flattenPackages, boolean compactDirectories, List children2, Mapper mapper, @NotNull Node parent, boolean hideEmptyMiddlePackages, TreeStructureProvider provider, List files2, ProjectFileNode child) {
            PsiFileSystemItem element;
            if (parent == null) {
                ProjectNode.$$$reportNull$$$0(17);
            }
            if ((element = this.findFileSystemItem(child.getVirtualFile())) instanceof PsiDirectory) {
                Icon icon = this.getFolderIcon(child, (PsiElement)element);
                if (icon != AllIcons.Nodes.Package || !flattenPackages) {
                    ProjectFileNode childNext2;
                    ProjectFileNode projectFileNode = childNext2 = !compactDirectories ? null : this.getSingleDirectory(child);
                    while (childNext2 != null) {
                        Icon iconNext = this.getFolderIcon(childNext2, null);
                        if (icon == iconNext) {
                            child = childNext2;
                            childNext2 = this.getSingleDirectory(child);
                            continue;
                        }
                        if (icon == AllIcons.Nodes.Folder && iconNext != AllIcons.Nodes.Package) {
                            icon = iconNext;
                            child = childNext2;
                            childNext2 = null;
                            continue;
                        }
                        childNext2 = null;
                    }
                    children2.add(mapper.apply(parent, child, icon));
                } else if (AllIcons.Nodes.Package != parent.getIcon()) {
                    this.visitPackages(child, hideEmptyMiddlePackages, (Consumer<ProjectFileNode>)((Consumer)childNext -> {
                        if (parent == null) {
                            ProjectNode.$$$reportNull$$$0(18);
                        }
                        children2.add(mapper.apply(parent, childNext, AllIcons.Nodes.Package));
                    }));
                }
            } else if (element instanceof PsiFile) {
                if (provider == null) {
                    children2.add(mapper.apply(parent, child));
                } else {
                    files2.add((PsiFile)element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$ProjectNode";
                    break;
                }
                case 5: 
                case 9: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 10: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "area";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$ProjectNode";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildren";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildren";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 13: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPackages";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$contains$5";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$visitPackages$4";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createChildren$2";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Node
    extends ProjectViewNode<Object> {
        volatile NamedScopeFilter filter;
        volatile Collection<AbstractTreeNode> children;
        volatile boolean childrenValid;

        Node(@NotNull Project project, @NotNull Object value, @NotNull ViewSettings settings) {
            if (project == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (value == null) {
                Node.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                Node.$$$reportNull$$$0(2);
            }
            super(project, value, settings);
            this.children = Collections.emptyList();
        }

        Node(@NotNull Node parent, @NotNull Object value) {
            if (parent == null) {
                Node.$$$reportNull$$$0(3);
            }
            if (value == null) {
                Node.$$$reportNull$$$0(4);
            }
            super(parent.getProject(), value, parent.getSettings());
            this.children = Collections.emptyList();
            this.setParent((AbstractTreeNode)parent);
        }

        public int getWeight() {
            return 0;
        }

        public final boolean canRepresent(Object element) {
            if (element instanceof PsiFileSystemItem) {
                PsiFileSystemItem item = (PsiFileSystemItem)element;
                element = item.getVirtualFile();
            }
            return element instanceof VirtualFile && this.canRepresent((VirtualFile)element);
        }

        boolean canRepresent(@NotNull VirtualFile file2) {
            if (file2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            return file2.equals(this.getVirtualFile());
        }

        public final boolean contains(@NotNull VirtualFile file2) {
            AreaInstance area;
            if (file2 == null) {
                Node.$$$reportNull$$$0(6);
            }
            return (area = ProjectFileListener.findArea(file2, this.getProject())) != null && this.contains(file2, area);
        }

        protected boolean hasProblemFileBeneath() {
            WolfTheProblemSolver solver = ScopeViewTreeModel.getWolfTheProblemSolver(this.getProject());
            return solver == null || solver.hasProblemFilesBeneath(this::contains);
        }

        abstract boolean contains(@NotNull VirtualFile var1, @NotNull AreaInstance var2);

        public Color getFileStatusColor(@NotNull FileStatus status) {
            if (status == null) {
                Node.$$$reportNull$$$0(7);
            }
            return status.getColor();
        }

        @NotNull
        abstract Collection<AbstractTreeNode> createChildren(@NotNull Collection<AbstractTreeNode> var1);

        @NotNull
        public final Collection<AbstractTreeNode> getChildren() {
            if (this.childrenValid) {
                Collection<AbstractTreeNode> collection = this.children;
                if (collection == null) {
                    Node.$$$reportNull$$$0(8);
                }
                return collection;
            }
            Collection<AbstractTreeNode> oldChildren = this.children;
            Collection<AbstractTreeNode> newChildren = this.createChildren(oldChildren);
            oldChildren.forEach(node -> node.setParent(null));
            newChildren.forEach(node -> node.setParent((AbstractTreeNode)this));
            this.children = newChildren;
            this.childrenValid = true;
            Collection<AbstractTreeNode> collection = newChildren;
            if (collection == null) {
                Node.$$$reportNull$$$0(9);
            }
            return collection;
        }

        @Nullable
        String getLocation() {
            return null;
        }

        final void decorate(@NotNull PresentationData presentation) {
            ProjectNode parent;
            ProjectViewNodeDecorator decorator;
            String location;
            if (presentation == null) {
                Node.$$$reportNull$$$0(10);
            }
            if ((location = this.getLocation()) != null) {
                if (this.getSettings().isShowURL()) {
                    presentation.setLocationString(location);
                } else {
                    presentation.setTooltip(location);
                }
            }
            ProjectViewNodeDecorator projectViewNodeDecorator = decorator = (parent = this.findParent(ProjectNode.class)) == null ? null : parent.decorator;
            if (decorator != null) {
                decorator.decorate(this, presentation);
            }
        }

        @NotNull
        final Icon getFolderIcon(@NotNull ProjectFileNode node, @Nullable PsiElement element) {
            ProjectFileIndex index;
            if (node == null) {
                Node.$$$reportNull$$$0(11);
            }
            if ((index = ScopeViewTreeModel.getProjectFileIndex(this.getProject())) != null) {
                SourceFolder folder;
                VirtualFile file2 = node.getVirtualFile();
                Module module2 = index.getModuleForFile(file2);
                if (module2 != null && (folder = ProjectRootsUtil.findSourceFolder(module2, file2)) != null) {
                    Icon icon = SourceRootPresentation.getSourceRootIcon(folder);
                    if (icon == null) {
                        Node.$$$reportNull$$$0(12);
                    }
                    return icon;
                }
                if (index.isExcluded(file2)) {
                    Icon icon = AllIcons.Modules.ExcludeRoot;
                    if (icon == null) {
                        Node.$$$reportNull$$$0(13);
                    }
                    return icon;
                }
                String name = ScopeViewTreeModel.getPackageName((PsiElement)(element != null ? element : this.findFileSystemItem(file2)));
                if (name != null) {
                    Icon icon = AllIcons.Nodes.Package;
                    if (icon == null) {
                        Node.$$$reportNull$$$0(14);
                    }
                    return icon;
                }
            }
            Icon icon = AllIcons.Nodes.Folder;
            if (icon == null) {
                Node.$$$reportNull$$$0(15);
            }
            return icon;
        }

        @Nullable
        final PsiFileSystemItem findFileSystemItem(@NotNull VirtualFile file2) {
            PsiManager manager;
            if (file2 == null) {
                Node.$$$reportNull$$$0(16);
            }
            Project project = !file2.isValid() ? null : this.getProject();
            PsiManager psiManager = manager = project == null || project.isDisposed() ? null : PsiManager.getInstance((Project)project);
            return manager == null ? null : (file2.isDirectory() ? manager.findDirectory(file2) : manager.findFile(file2));
        }

        final <N> N findParent(Class<N> type) {
            for (Node node = this; node != null; node = node.getParent()) {
                if (!type.isInstance((Object)node)) continue;
                return type.cast((Object)node);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: 
                case 6: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Node";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scopeView/ScopeViewTreeModel$Node";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFolderIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canRepresent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileStatusColor";
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getFolderIcon";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "findFileSystemItem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

