/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomizableActionGroupProvider;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="com.intellij.ide.ui.customization.CustomActionsSchema", storages={@Storage(value="customization.xml")})
public class CustomActionsSchema
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(CustomActionsSchema.class);
    @NonNls
    private static final String ACTIONS_SCHEMA = "custom_actions_schema";
    @NonNls
    private static final String ACTIVE = "active";
    @NonNls
    private static final String ELEMENT_ACTION = "action";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String GROUP = "group";
    private final Map<String, String> myIconCustomizations = new HashMap<String, String>();
    private final Map<String, String> myIdToName = new LinkedHashMap<String, String>();
    private final Map<String, ActionGroup> myIdToActionGroup = new HashMap<String, ActionGroup>();
    private List<ActionUrl> myActions = new ArrayList<ActionUrl>();
    private boolean isFirstLoadState = true;
    private int myModificationStamp = 0;

    public CustomActionsSchema() {
        this.myIdToName.put("MainMenu", ActionsTreeUtil.MAIN_MENU_TITLE);
        this.myIdToName.put("MainToolBar", ActionsTreeUtil.MAIN_TOOLBAR);
        this.myIdToName.put("EditorPopupMenu", ActionsTreeUtil.EDITOR_POPUP);
        this.myIdToName.put("EditorGutterPopupMenu", "Editor Gutter Popup Menu");
        this.myIdToName.put("EditorTabPopupMenu", ActionsTreeUtil.EDITOR_TAB_POPUP);
        this.myIdToName.put("ProjectViewPopupMenu", ActionsTreeUtil.PROJECT_VIEW_POPUP);
        this.myIdToName.put("ScopeViewPopupMenu", "Scope View Popup Menu");
        this.myIdToName.put("FavoritesViewPopupMenu", ActionsTreeUtil.FAVORITES_POPUP);
        this.myIdToName.put("CommanderPopupMenu", ActionsTreeUtil.COMMANDER_POPUP);
        this.myIdToName.put("J2EEViewPopupMenu", ActionsTreeUtil.J2EE_POPUP);
        this.myIdToName.put("NavbarPopupMenu", "Navigation Bar");
        this.myIdToName.put("NavBarToolBar", "Navigation Bar Toolbar");
        if (TouchBarsManager.isTouchBarAvailable()) {
            this.myIdToName.put("TouchBar", "Touch Bar");
        }
        ArrayList extList = ContainerUtil.newArrayList();
        CustomizableActionGroupProvider.CustomizableActionGroupRegistrar registrar = (groupId, groupTitle) -> extList.add(Couple.of((Object)groupId, (Object)groupTitle));
        for (CustomizableActionGroupProvider provider : (CustomizableActionGroupProvider[])CustomizableActionGroupProvider.EP_NAME.getExtensions()) {
            provider.registerGroups(registrar);
        }
        Collections.sort(extList, (o1, o2) -> StringUtil.naturalCompare((String)((String)o1.second), (String)((String)o2.second)));
        for (Couple couple : extList) {
            this.myIdToName.put((String)couple.first, (String)couple.second);
        }
    }

    public static CustomActionsSchema getInstance() {
        return (CustomActionsSchema)ServiceManager.getService(CustomActionsSchema.class);
    }

    public void addAction(ActionUrl url) {
        this.myActions.add(url);
        this.resortActions();
    }

    @NotNull
    public List<ActionUrl> getActions() {
        List<ActionUrl> list2 = this.myActions;
        if (list2 == null) {
            CustomActionsSchema.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public void setActions(@NotNull List<ActionUrl> actions) {
        if (actions == null) {
            CustomActionsSchema.$$$reportNull$$$0(1);
        }
        this.myActions = actions;
        this.resortActions();
    }

    public void copyFrom(CustomActionsSchema result2) {
        this.myIdToActionGroup.clear();
        this.myActions.clear();
        this.myIconCustomizations.clear();
        for (ActionUrl actionUrl : result2.myActions) {
            ActionUrl url = new ActionUrl(new ArrayList<String>(actionUrl.getGroupPath()), actionUrl.getComponent(), actionUrl.getActionType(), actionUrl.getAbsolutePosition());
            url.setInitialPosition(actionUrl.getInitialPosition());
            this.myActions.add(url);
        }
        this.resortActions();
        this.myIconCustomizations.putAll(result2.myIconCustomizations);
    }

    private void resortActions() {
        Collections.sort(this.myActions, ActionUrlComparator.INSTANCE);
    }

    public boolean isModified(CustomActionsSchema schema) {
        List<ActionUrl> storedActions = schema.getActions();
        if (ApplicationManager.getApplication().isUnitTestMode() && !storedActions.isEmpty()) {
            System.err.println("stored: " + storedActions.toString());
            System.err.println("actual: " + this.getActions().toString());
        }
        if (storedActions.size() != this.getActions().size()) {
            return true;
        }
        for (int i = 0; i < this.getActions().size(); ++i) {
            if (this.getActions().get(i).equals(storedActions.get(i))) continue;
            return true;
        }
        if (schema.myIconCustomizations.size() != this.myIconCustomizations.size()) {
            return true;
        }
        for (String actionId : this.myIconCustomizations.keySet()) {
            if (Comparing.strEqual((String)schema.getIconPath(actionId), (String)this.getIconPath(actionId))) continue;
            return true;
        }
        return false;
    }

    public void loadState(@NotNull Element element) {
        boolean reload2;
        if (element == null) {
            CustomActionsSchema.$$$reportNull$$$0(2);
        }
        this.myIdToActionGroup.clear();
        this.myActions.clear();
        this.myIconCustomizations.clear();
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        Element schElement = element;
        String activeName = element.getAttributeValue(ACTIVE);
        if (activeName != null) {
            block0: for (Element toolbarElement : element.getChildren(ACTIONS_SCHEMA)) {
                for (Object o : toolbarElement.getChildren("option")) {
                    if (!Comparing.strEqual((String)((Element)o).getAttributeValue("name"), (String)"myName") || !Comparing.strEqual((String)((Element)o).getAttributeValue("value"), (String)activeName)) continue;
                    schElement = toolbarElement;
                    continue block0;
                }
            }
        }
        for (Element groupElement : schElement.getChildren(GROUP)) {
            ActionUrl url = new ActionUrl();
            url.readExternal(groupElement);
            this.myActions.add(url);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            System.err.println("read custom actions: " + this.myActions.toString());
        }
        for (Element action : element.getChildren(ELEMENT_ACTION)) {
            String actionId = action.getAttributeValue(ATTRIBUTE_ID);
            String iconPath = action.getAttributeValue(ATTRIBUTE_ICON);
            if (actionId == null) continue;
            this.myIconCustomizations.put(actionId, iconPath);
        }
        boolean bl = reload2 = !this.isFirstLoadState;
        if (this.isFirstLoadState) {
            this.isFirstLoadState = false;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.initActionIcons();
            if (reload2) {
                CustomActionsSchema.setCustomizationSchemaForCurrentProjects();
            }
        });
    }

    public void clearFirstLoadState() {
        this.isFirstLoadState = false;
    }

    public static void setCustomizationSchemaForCurrentProjects() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(project);
            if (frame == null) continue;
            frame.updateView();
        }
        IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(null);
        if (frame != null) {
            frame.updateView();
        }
        CustomActionsSchema.getInstance().incrementModificationStamp();
    }

    public void incrementModificationStamp() {
        ++this.myModificationStamp;
    }

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    public Element getState() {
        Element element = new Element("state");
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (ActionUrl group : this.myActions) {
            Element groupElement = new Element(GROUP);
            group.writeExternal(groupElement);
            element.addContent(groupElement);
        }
        this.writeIcons(element);
        return element;
    }

    public AnAction getCorrectedAction(String id) {
        if (!this.myIdToName.containsKey(id)) {
            return ActionManager.getInstance().getAction(id);
        }
        ActionGroup existing = this.myIdToActionGroup.get(id);
        if (existing != null) {
            return existing;
        }
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction(id);
        if (actionGroup != null) {
            String name = this.myIdToName.get(id);
            ActionGroup corrected = CustomizationUtil.correctActionGroup(actionGroup, this, name, name, true);
            this.myIdToActionGroup.put(id, corrected);
            return corrected;
        }
        return null;
    }

    public void fillActionGroups(DefaultMutableTreeNode root) {
        ActionManager actionManager = ActionManager.getInstance();
        for (String id : this.myIdToName.keySet()) {
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction(id);
            if (actionGroup == null) continue;
            root.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createGroup(actionGroup, this.myIdToName.get(id), null, null, true, null, false)));
        }
    }

    public boolean isCorrectActionGroup(ActionGroup group, String defaultGroupName) {
        if (this.myActions.isEmpty()) {
            return false;
        }
        String text2 = group.getTemplatePresentation().getText();
        if (!StringUtil.isEmpty((String)text2)) {
            for (ActionUrl url : this.myActions) {
                String id;
                if (url.getGroupPath().contains(text2) || url.getGroupPath().contains(defaultGroupName)) {
                    return true;
                }
                if (!(url.getComponent() instanceof Group)) continue;
                Group urlGroup = (Group)url.getComponent();
                String string = id = urlGroup.getName() != null ? urlGroup.getName() : urlGroup.getId();
                if (id != null && !id.equals(text2) && !id.equals(defaultGroupName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public List<ActionUrl> getChildActions(ActionUrl url) {
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = url.getGroupPath();
        for (ActionUrl actionUrl : this.myActions) {
            int index;
            if (groupPath.size() > actionUrl.getGroupPath().size()) continue;
            for (index = 0; index < groupPath.size() && Comparing.equal((String)groupPath.get(index), (String)actionUrl.getGroupPath().get(index)); ++index) {
            }
            if (index != groupPath.size()) continue;
            result2.add(actionUrl);
        }
        return result2;
    }

    public void removeIconCustomization(String actionId) {
        this.myIconCustomizations.remove(actionId);
    }

    public void addIconCustomization(String actionId, String iconPath) {
        this.myIconCustomizations.put(actionId, iconPath != null ? FileUtil.toSystemIndependentName((String)iconPath) : null);
    }

    public String getIconPath(String actionId) {
        String path = this.myIconCustomizations.get(actionId);
        return path == null ? "" : path;
    }

    private void writeIcons(Element parent) {
        for (String actionId : this.myIconCustomizations.keySet()) {
            Element action = new Element(ELEMENT_ACTION);
            action.setAttribute(ATTRIBUTE_ID, actionId);
            String icon = this.myIconCustomizations.get(actionId);
            if (icon != null) {
                action.setAttribute(ATTRIBUTE_ICON, icon);
            }
            parent.addContent(action);
        }
    }

    private void initActionIcons() {
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : this.myIconCustomizations.keySet()) {
            Icon icon;
            AnAction anAction = actionManager.getAction(actionId);
            if (anAction == null) continue;
            String iconPath = this.myIconCustomizations.get(actionId);
            if (iconPath != null && new File(FileUtil.toSystemDependentName((String)iconPath)).exists()) {
                Image image = null;
                try {
                    image = ImageLoader.loadFromStream((InputStream)VfsUtilCore.convertToURL((String)VfsUtil.pathToUrl((String)iconPath)).openStream());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                icon = image == null ? null : new JBImageIcon(image);
            } else {
                icon = AllIcons.Toolbar.Unknown;
            }
            anAction.getTemplatePresentation().setIcon(icon);
            anAction.getTemplatePresentation().setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            anAction.setDefaultIcon(false);
        }
        IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(null);
        if (frame != null) {
            frame.updateView();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/CustomActionsSchema";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/CustomActionsSchema";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setActions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionUrlComparator
    implements Comparator<ActionUrl> {
        static final ActionUrlComparator INSTANCE = new ActionUrlComparator();
        static int DELETED = 1;

        private ActionUrlComparator() {
        }

        @Override
        public int compare(ActionUrl u1, ActionUrl u2) {
            int w2;
            int w1 = ActionUrlComparator.getEquivalenceClass(u1);
            if (w1 != (w2 = ActionUrlComparator.getEquivalenceClass(u2))) {
                return w1 - w2;
            }
            if (w1 == DELETED) {
                return u2.getAbsolutePosition() - u1.getAbsolutePosition();
            }
            return u1.getAbsolutePosition() - u2.getAbsolutePosition();
        }

        private static int getEquivalenceClass(ActionUrl url) {
            switch (url.getActionType()) {
                case -1: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 3;
        }
    }
}

