/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    private final Rectangle viewRect = new Rectangle();
    private final Rectangle textRect = new Rectangle();
    private final Rectangle iconRect = new Rectangle();
    protected static JBValue HELP_BUTTON_DIAMETER = new JBValue.Float(22.0f);
    protected static JBValue MINIMUM_BUTTON_WIDTH = new JBValue.Float(72.0f);
    protected static JBValue HORIZONTAL_PADDING = new JBValue.Float(14.0f);

    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    public static boolean isSmallComboButton(Component c) {
        ComboBoxAction a = DarculaButtonUI.getComboAction(c);
        return a != null && a.isSmallVariant();
    }

    public static ComboBoxAction getComboAction(Component c) {
        return c instanceof AbstractButton ? (ComboBoxAction)((JComponent)c).getClientProperty("styleCombo") : null;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap());
        b.setMargin((Insets)JBUI.emptyInsets());
    }

    protected int textIconGap() {
        return JBUI.scale((int)4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        if (UIUtil.isHelpButton((Component)c)) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd()));
            int diam = HELP_BUTTON_DIAMETER.get();
            int x = r.x + (r.width - diam) / 2;
            int y = r.x + (r.height - diam) / 2;
            g.fill(new Ellipse2D.Float(x, y, diam, diam));
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
            return false;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            float bw;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
            float f = bw = DarculaButtonUI.isSmallComboButton(c) ? 0.0f : DarculaUIUtil.BW.getFloat();
            if (!c.hasFocus() && !DarculaButtonUI.isSmallComboButton(c) && c.isEnabled() && UIManager.getBoolean("Button.darcula.paintShadow")) {
                JBColor shadowColor = JBColor.namedColor((String)"Button.darcula.shadowColor", (Color)new Color(-1499027840, true));
                int shadowWidth = JBUI.scale((int)JBUI.getInt((String)"Button.darcula.shadowWidth", (int)2));
                g2.setColor((Color)(DarculaButtonUI.isDefaultButton(c) ? JBColor.namedColor((String)"Button.darcula.defaultShadowColor", (Color)shadowColor) : shadowColor));
                g2.fill(new RoundRectangle2D.Float(bw, bw + (float)shadowWidth, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
            if (c.isEnabled()) {
                g2.setPaint(this.getBackground(c, r));
                g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            }
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    private Paint getBackground(JComponent c, Rectangle r) {
        Color backgroundColor = (Color)c.getClientProperty("JButton.backgroundColor");
        return backgroundColor != null ? backgroundColor : (DarculaButtonUI.isSmallComboButton(c) ? JBColor.namedColor((String)"Button.darcula.smallComboButtonBackground", (Color)UIUtil.getPanelBackground()) : (DarculaButtonUI.isDefaultButton(c) ? UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getDefaultButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getDefaultButtonColorEnd()) : UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd())));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.paintDecorations((Graphics2D)g, c)) {
            this.paintContents(g, (AbstractButton)c);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text2) {
        int mnemonicIndex;
        if (UIUtil.isHelpButton((Component)c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        g.setColor(this.getButtonTextColor(button));
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text2, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            this.paintDisabledText(g, text2, c, textRect, metrics);
        }
    }

    protected Color getButtonTextColor(AbstractButton button) {
        Color textColor = (Color)button.getClientProperty("JButton.textColor");
        return textColor != null ? textColor : DarculaUIUtil.getButtonTextColor(button);
    }

    public static Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledText");
    }

    protected void paintDisabledText(Graphics g, String text2, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text2, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }

    protected void paintContents(Graphics g, AbstractButton b) {
        if (b instanceof JBOptionButton) {
            return;
        }
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)b, g);
        boolean isDotButton = DarculaButtonUI.isSquare(b) && b.getIcon() == AllIcons.General.Ellipsis;
        String text2 = isDotButton ? "..." : b.getText();
        Icon icon = isDotButton ? null : b.getIcon();
        text2 = this.layout(b, text2, icon, fm, b.getWidth(), b.getHeight());
        if (DarculaButtonUI.isSquare(b)) {
            if (b.getIcon() == AllIcons.General.Ellipsis) {
                UISettings.setupAntialiasing((Graphics)g);
                this.paintText(g, b, this.textRect, text2);
            } else if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
        } else {
            if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
            if (text2 != null && !text2.isEmpty()) {
                View v = (View)b.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g);
                    this.paintText(g, b, this.textRect, text2);
                }
            }
        }
    }

    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        Insets i = c.getInsets();
        if (UIUtil.isHelpButton((Component)c) || DarculaButtonUI.isSquare(c)) {
            int helpDiam = HELP_BUTTON_DIAMETER.get();
            return new Dimension(Math.max(prefSize.width, helpDiam + i.left + i.right), Math.max(prefSize.height, helpDiam + i.top + i.bottom));
        }
        int width = DarculaButtonUI.getComboAction(c) != null ? prefSize.width : Math.max(HORIZONTAL_PADDING.get() * 2 + prefSize.width, MINIMUM_BUTTON_WIDTH.get() + i.left + i.right);
        int height = Math.max(prefSize.height, this.getMinimumHeight() + i.top + i.bottom);
        return new Dimension(width, height);
    }

    protected int getMinimumHeight() {
        return DarculaUIUtil.MINIMUM_HEIGHT.get();
    }

    @Override
    public final Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        int textIconGap = StringUtil.isEmpty((String)b.getText()) || b.getIcon() == null ? 0 : b.getIconTextGap();
        Dimension size = BasicGraphicsUtils.getPreferredButtonSize(b, textIconGap);
        return this.getDarculaButtonSize(c, size);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (DarculaButtonUI.isDefaultButton(c)) {
            this.setupDefaultButton((JButton)c);
        }
    }

    protected void setupDefaultButton(JButton button) {
        if (!SystemInfo.isMac && !button.getFont().isBold()) {
            button.setFont(new FontUIResource(button.getFont().deriveFont(1)));
        }
    }

    protected Color getButtonColorStart() {
        return JBColor.namedColor((String)"Button.darcula.startColor", (int)0x555A5C);
    }

    protected Color getButtonColorEnd() {
        return JBColor.namedColor((String)"Button.darcula.endColor", (int)4277832);
    }

    protected Color getDefaultButtonColorStart() {
        return JBColor.namedColor((String)"Button.darcula.defaultStartColor", (int)3690347);
    }

    protected Color getDefaultButtonColorEnd() {
        return JBColor.namedColor((String)"Button.darcula.defaultEndColor", (int)2306371);
    }

    protected String layout(AbstractButton b, String text2, Icon icon, FontMetrics fm, int width, int height) {
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.viewRect.setBounds(0, 0, width, height);
        this.modifyViewRect(b, this.viewRect);
        return SwingUtilities.layoutCompoundLabel(b, fm, text2, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, StringUtil.isEmpty((String)text2) || icon == null ? 0 : b.getIconTextGap());
    }

    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getMargin());
    }
}

