/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPropertyNameReference
implements PsiReference {
    private final JsonProperty myProperty;

    public JsonPropertyNameReference(@NotNull JsonProperty property) {
        if (property == null) {
            JsonPropertyNameReference.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
    }

    @NotNull
    public PsiElement getElement() {
        JsonProperty jsonProperty = this.myProperty;
        if (jsonProperty == null) {
            JsonPropertyNameReference.$$$reportNull$$$0(1);
        }
        return jsonProperty;
    }

    @NotNull
    public TextRange getRangeInElement() {
        JsonValue nameElement = this.myProperty.getNameElement();
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)nameElement);
        if (textRange == null) {
            JsonPropertyNameReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myProperty;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myProperty.getName();
        if (string == null) {
            JsonPropertyNameReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myProperty.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JsonPropertyNameReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof JsonProperty)) {
            return false;
        }
        JsonProperty otherProperty = (JsonProperty)element;
        PsiElement selfResolve = this.resolve();
        return otherProperty.getName().equals(this.getCanonicalText()) && selfResolve != otherProperty;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JsonPropertyNameReference.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/psi/impl/JsonPropertyNameReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/psi/impl/JsonPropertyNameReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

