/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ReadOnlyASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraverserBasedASTNode<N>
extends ReadOnlyASTNode {
    protected final N myNode;
    protected final SyntaxTraverser<N> myTraverser;
    private volatile PsiElement myPsi;
    private volatile ASTNode[] myKids;
    private static final AtomicFieldUpdater<TraverserBasedASTNode, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(TraverserBasedASTNode.class, PsiElement.class);
    private static final AtomicFieldUpdater<TraverserBasedASTNode, ASTNode[]> ourKidsUpdater = AtomicFieldUpdater.forFieldOfType(TraverserBasedASTNode.class, ASTNode[].class);

    @NotNull
    public static <N> FileASTNode createFileNode(@NotNull SyntaxTraverser<N> traverser, @NotNull N node, @NotNull PsiFile psiFile) {
        if (traverser == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(0);
        }
        if (node == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(2);
        }
        FileNode<N> fileNode = new FileNode<N>(traverser, node, psiFile);
        if (fileNode == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(3);
        }
        return fileNode;
    }

    @NotNull
    public static FileViewProvider createViewProvider(@NotNull String fileName, @NotNull Language language, @NotNull PsiManager psiManager) {
        if (fileName == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(4);
        }
        if (language == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(5);
        }
        if (psiManager == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(6);
        }
        ReadOnlyViewProvider readOnlyViewProvider = new ReadOnlyViewProvider(fileName, language, psiManager);
        if (readOnlyViewProvider == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(7);
        }
        return readOnlyViewProvider;
    }

    public TraverserBasedASTNode(@NotNull N node, int index, @Nullable TraverserBasedASTNode<?> parent, @NotNull SyntaxTraverser<N> traverser) {
        if (node == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(8);
        }
        if (traverser == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(9);
        }
        super(parent, index);
        this.myTraverser = traverser;
        this.myNode = node;
    }

    @NotNull
    public IElementType getElementType() {
        IElementType iElementType = this.myTraverser.api.typeOf(this.myNode);
        if (iElementType == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myTraverser.api.textOf(this.myNode);
        if (charSequence == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(11);
        }
        return charSequence;
    }

    public TextRange getTextRange() {
        return this.myTraverser.api.rangeOf(this.myNode);
    }

    @Override
    protected ASTNode[] getChildArray() {
        ASTNode[] kids = this.myKids;
        if (kids != null) {
            return kids;
        }
        kids = this.childrenImpl();
        return ourKidsUpdater.compareAndSet((Object)this, null, (Object)kids) ? kids : this.myKids;
    }

    private ASTNode[] childrenImpl() {
        List children2 = this.myTraverser.children(this.myNode).transform(this.CHILD_TRANSFORM(this.myTraverser, 0)).toList();
        if (!children2.isEmpty() || this.getTreeParent() == null) {
            return children2.isEmpty() ? EMPTY_ARRAY : children2.toArray(ASTNode.EMPTY_ARRAY);
        }
        IElementType type = this.myTraverser.api.typeOf(this.myNode);
        if (!(type instanceof ILazyParseableElementType)) {
            return EMPTY_ARRAY;
        }
        PsiBuilder builder2 = ((ILazyParseableElementType)type).parseLight((ASTNode)this);
        SyntaxTraverser s = SyntaxTraverser.lightTraverser((PsiBuilder)builder2);
        int shift = this.myTraverser.api.rangeOf(this.myNode).getStartOffset();
        List childrenLazy = s.api.children(s.getRoot()).transform(this.CHILD_TRANSFORM(s, shift)).toList();
        return childrenLazy.toArray(ASTNode.EMPTY_ARRAY);
    }

    @NotNull
    protected <NN> TraverserBasedASTNode<NN> createChildNode(int index, NN input, SyntaxTraverser<NN> s, int shift) {
        TraverserBasedASTNode<NN> traverserBasedASTNode = shift == 0 ? new TraverserBasedASTNode<NN>(input, index, this, s) : new ShiftedNode<NN>(this, index, shift, s, input);
        if (traverserBasedASTNode == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(12);
        }
        return traverserBasedASTNode;
    }

    public PsiElement getPsi() {
        PsiElement psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getPsiImpl();
        return ourPsiUpdater.compareAndSet((Object)this, null, (Object)psi) ? psi : this.myPsi;
    }

    public PsiElement getPsiImpl() {
        IElementType type = this.getElementType();
        ParserDefinition pd = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage());
        if (pd != null && pd.getWhitespaceTokens().contains(type) || pd == null && type == TokenType.WHITE_SPACE) {
            return new PsiWhiteSpaceImpl(this.getChars());
        }
        if (pd != null && pd.getCommentTokens().contains(type)) {
            return new ASTWrapperPsiComment(this);
        }
        if (pd == null || this.myNode instanceof LighterASTTokenNode) {
            return new ASTWrapperPsiElement(this);
        }
        return pd.createElement((ASTNode)this);
    }

    @NotNull
    private <NN> Function<NN, ASTNode> CHILD_TRANSFORM(final SyntaxTraverser<NN> s, final int shift) {
        Function function = new Function<NN, ASTNode>(){
            int index = 0;

            public ASTNode fun(@Nullable NN input) {
                return TraverserBasedASTNode.this.createChildNode(this.index++, input, s, shift);
            }
        };
        if (function == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(13);
        }
        return function;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TraverserBasedASTNode)) {
            return false;
        }
        return Comparing.equal(this.myNode, ((TraverserBasedASTNode)((Object)obj)).myNode);
    }

    public int hashCode() {
        return this.myNode.hashCode();
    }

    @NotNull
    public static PsiElement[] getChildrenAsPsiArray(@NotNull ASTNode node) {
        ASTNode[] kids;
        if (node == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(14);
        }
        if ((kids = ((ReadOnlyASTNode)node).getChildArray()).length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                TraverserBasedASTNode.$$$reportNull$$$0(15);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] result2 = new PsiElement[kids.length];
        int idx = 0;
        for (ASTNode o : kids) {
            PsiElement psi = o.getPsi();
            if (psi == null) continue;
            result2[idx++] = psi;
        }
        if (result2 == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(16);
        }
        return result2;
    }

    @Nullable
    public static PsiElement getFirstPsiChild(@NotNull ASTNode node) {
        ASTNode[] kids;
        if (node == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(17);
        }
        for (ASTNode o : kids = ((ReadOnlyASTNode)node).getChildArray()) {
            PsiElement psi = o.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    @Nullable
    public static PsiElement getLastPsiChild(@NotNull ASTNode node) {
        if (node == null) {
            TraverserBasedASTNode.$$$reportNull$$$0(18);
        }
        ASTNode[] kids = ((ReadOnlyASTNode)node).getChildArray();
        for (int i = kids.length - 1; i >= 0; --i) {
            ASTNode o = kids[i];
            PsiElement psi = o.getPsi();
            if (psi == null) continue;
            return psi;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 1: 
            case 8: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/TraverserBasedASTNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/TraverserBasedASTNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildNode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "CHILD_TRANSFORM";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsPsiArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFileNode";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createViewProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenAsPsiArray";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPsiChild";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLastPsiChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReadOnlyViewProvider
    extends SingleRootFileViewProvider {
        ReadOnlyViewProvider(@NotNull String name, @NotNull Language language, @NotNull PsiManager psiManager) {
            if (name == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(0);
            }
            if (language == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(1);
            }
            if (psiManager == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(2);
            }
            super(psiManager, (VirtualFile)new LightVirtualFile(name, language, (CharSequence)""), false);
        }

        @Override
        @Nullable
        protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull FileType fileType) {
            if (project == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(4);
            }
            if (fileType == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException("Should not try to create mutable PSI");
        }

        @Override
        @Nullable
        protected PsiFile createFile(@NotNull Language lang) {
            if (lang == null) {
                ReadOnlyViewProvider.$$$reportNull$$$0(6);
            }
            throw new UnsupportedOperationException("Should not try to create mutable PSI");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/TraverserBasedASTNode$ReadOnlyViewProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ASTWrapperPsiComment
    extends ASTWrapperPsiElement
    implements PsiComment {
        public ASTWrapperPsiComment(@NotNull ASTNode node) {
            if (node == null) {
                ASTWrapperPsiComment.$$$reportNull$$$0(0);
            }
            super(node);
        }

        public IElementType getTokenType() {
            return this.getNode().getElementType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/TraverserBasedASTNode$ASTWrapperPsiComment", "<init>"));
        }
    }

    private static class ShiftedNode<N>
    extends TraverserBasedASTNode<N> {
        private final int myShift;

        ShiftedNode(TraverserBasedASTNode<?> parent, int index, int shift, @NotNull SyntaxTraverser<N> traverser, @NotNull N node) {
            if (traverser == null) {
                ShiftedNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                ShiftedNode.$$$reportNull$$$0(1);
            }
            super(node, index, parent, traverser);
            this.myShift = shift;
        }

        @Override
        public TextRange getTextRange() {
            return super.getTextRange().shiftRight(this.myShift);
        }

        @Override
        @NotNull
        protected <NN> TraverserBasedASTNode<NN> createChildNode(int index, NN input, SyntaxTraverser<NN> s, int shift) {
            ShiftedNode<NN> shiftedNode = new ShiftedNode<NN>(this, index, this.myShift + shift, s, input);
            if (shiftedNode == null) {
                ShiftedNode.$$$reportNull$$$0(2);
            }
            return shiftedNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traverser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/TraverserBasedASTNode$ShiftedNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/TraverserBasedASTNode$ShiftedNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileNode<N>
    extends TraverserBasedASTNode<N>
    implements FileASTNode {
        private final PsiFile myPsiFile;
        private final CharTableImpl myCharTable;

        FileNode(@NotNull SyntaxTraverser<N> traverser, @NotNull N node, @NotNull PsiFile psiFile) {
            if (traverser == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (node == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            super(node, -1, null, traverser);
            this.myCharTable = new CharTableImpl();
            this.myPsiFile = psiFile;
            ((ReadOnlyViewProvider)psiFile.getViewProvider()).forceCachedPsi(psiFile);
        }

        @Override
        public PsiElement getPsi() {
            return this.myPsiFile;
        }

        @NotNull
        public CharTable getCharTable() {
            CharTableImpl charTableImpl = this.myCharTable;
            if (charTableImpl == null) {
                FileNode.$$$reportNull$$$0(3);
            }
            return charTableImpl;
        }

        public boolean isParsed() {
            return true;
        }

        @NotNull
        public LighterAST getLighterAST() {
            TreeBackedLighterAST treeBackedLighterAST = new TreeBackedLighterAST((FileASTNode)this);
            if (treeBackedLighterAST == null) {
                FileNode.$$$reportNull$$$0(4);
            }
            return treeBackedLighterAST;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traverser";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/TraverserBasedASTNode$FileNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/TraverserBasedASTNode$FileNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharTable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLighterAST";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

