/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGithubTagDownloadedProjectGenerator
extends WebProjectTemplate<GithubTagInfo> {
    private static final Logger LOG = Logger.getInstance(AbstractGithubTagDownloadedProjectGenerator.class);

    @Override
    @NotNull
    @Nls
    public final String getName() {
        String string = this.getDisplayName();
        if (string == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected abstract String getDisplayName();

    @NotNull
    public abstract String getGithubUserName();

    @NotNull
    public abstract String getGithubRepositoryName();

    @Override
    @Nullable
    public abstract String getDescription();

    private String getTitle() {
        return this.getDisplayName();
    }

    @Override
    @Nullable
    public String getHelpId() {
        return "create.from.template." + this.getGithubUserName() + "." + this.getGithubRepositoryName();
    }

    @Override
    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag, @NotNull Module module2) {
        if (project == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(4);
        }
        try {
            this.unpackToDir(project, VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), tag);
        }
        catch (GeneratorException e) {
            this.showErrorMessage(project, e.getMessage());
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (baseDir == null) {
                AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(15);
            }
            baseDir.refresh(true, true);
        });
    }

    @NotNull
    public GithubProjectGeneratorPeer createPeer() {
        GithubProjectGeneratorPeer githubProjectGeneratorPeer = new GithubProjectGeneratorPeer(this);
        if (githubProjectGeneratorPeer == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(5);
        }
        return githubProjectGeneratorPeer;
    }

    @Override
    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private void unpackToDir(@Nullable Project project, @NotNull File extractToDir, @NotNull GithubTagInfo tag) throws GeneratorException {
        if (extractToDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(6);
        }
        if (tag == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(7);
        }
        File zipArchiveFile = this.getCacheFile(tag);
        String primaryUrl = this.getPrimaryZipArchiveUrlForDownload(tag);
        boolean downloaded = false;
        if (primaryUrl != null) {
            try {
                this.downloadAndUnzip(project, primaryUrl, zipArchiveFile, extractToDir, false);
                downloaded = true;
            }
            catch (GeneratorException e) {
                LOG.info("Can't download " + primaryUrl, (Throwable)e);
                FileUtil.delete((File)zipArchiveFile);
            }
        }
        if (!downloaded) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new GeneratorException("Download " + tag.getZipballUrl() + " is skipped in unit test mode");
            }
            this.downloadAndUnzip(project, tag.getZipballUrl(), zipArchiveFile, extractToDir, true);
        }
    }

    private void downloadAndUnzip(@Nullable Project project, @NotNull String url, @NotNull File zipArchiveFile, @NotNull File extractToDir, boolean retryOnError) throws GeneratorException {
        if (url == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(8);
        }
        if (zipArchiveFile == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(9);
        }
        if (extractToDir == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(10);
        }
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously(project, url, this.getTitle(), zipArchiveFile, this.getGithubUserName(), this.getGithubRepositoryName(), retryOnError);
        LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
        ZipUtil.unzipWithProgressSynchronously(project, this.getTitle(), zipArchiveFile, extractToDir, this.getPathConvertor(), true);
    }

    @Nullable
    protected NullableFunction<String, String> getPathConvertor() {
        return null;
    }

    @Nullable
    public abstract String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo var1);

    @NotNull
    private File getCacheFile(@NotNull GithubTagInfo tag) {
        if (tag == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(11);
        }
        String fileName = tag.getName() + ".zip";
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Can't urlEncode", (Throwable)e);
        }
        File file2 = GithubDownloadUtil.findCacheFile(this.getGithubUserName(), this.getGithubRepositoryName(), fileName);
        if (file2 == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(12);
        }
        return file2;
    }

    private void showErrorMessage(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(13);
        }
        if (message == null) {
            AbstractGithubTagDownloadedProjectGenerator.$$$reportNull$$$0(14);
        }
        String fullMessage = "Error creating " + this.getDisplayName() + " project. " + message;
        String title = "Create " + this.getDisplayName() + " Project";
        Messages.showErrorDialog((Project)project, (String)fullMessage, (String)title);
    }

    public ActionLink createGitHubLink() {
        ActionLink link = new ActionLink(this.getName() + " on GitHub", (AnAction)DumbAwareAction.create(e -> BrowserUtil.open((String)("https://github.com/" + this.getGithubUserName() + "/" + this.getGithubRepositoryName()))));
        link.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        return link;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractToDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipArchiveFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/AbstractGithubTagDownloadedProjectGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unpackToDir";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndUnzip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

