/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.splitter;

import java.util.Comparator;

public class Interval {
    public static final Comparator START_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Interval) {
            return ((Interval)o1).compareToStart((Integer)o2);
        }
        return -((Interval)o2).compareToStart((Integer)o1);
    };
    public static final Comparator END_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Interval) {
            return ((Interval)o1).compareToEnd((Integer)o2);
        }
        return -((Interval)o2).compareToEnd((Integer)o1);
    };
    private final int myStart;
    private final int myLength;

    public Interval(int start, int length) {
        this.myStart = start;
        this.myLength = length;
    }

    public int getEnd() {
        return this.myStart + this.myLength;
    }

    public int getStart() {
        return this.myStart;
    }

    private int compareToStart(Integer start) {
        return this.myStart - start;
    }

    private int compareToEnd(Integer end) {
        return this.getEnd() - end;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        return this.myStart == other.myStart && this.myLength == other.myLength;
    }

    public int hashCode() {
        return this.myStart ^ this.myLength << 20;
    }

    public String toString() {
        return "[" + this.myStart + ", " + this.getEnd() + ")";
    }

    public static Interval fromTo(int start, int end) {
        return new Interval(start, end - start);
    }

    public int getLength() {
        return this.myLength;
    }

    public static Interval toInf(int start) {
        return Interval.fromTo(start, Integer.MAX_VALUE);
    }

    public boolean contains(int location) {
        return location > this.myStart && location < this.getEnd() || location == this.myStart;
    }
}

