/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.BidiTextDirection;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;

public abstract class SetEditorBidiTextDirectionAction
extends ToggleAction {
    private final BidiTextDirection myDirection;

    private SetEditorBidiTextDirectionAction(BidiTextDirection direction) {
        this.myDirection = direction;
    }

    public boolean isSelected(AnActionEvent e) {
        return EditorSettingsExternalizable.getInstance().getBidiTextDirection() == this.myDirection;
    }

    public void setSelected(AnActionEvent e, boolean state2) {
        if (this.myDirection != EditorSettingsExternalizable.getInstance().getBidiTextDirection()) {
            EditorSettingsExternalizable.getInstance().setBidiTextDirection(this.myDirection);
            EditorFactory.getInstance().refreshAllEditors();
        }
    }

    public static class Rtl
    extends SetEditorBidiTextDirectionAction {
        public Rtl() {
            super(BidiTextDirection.RTL);
        }
    }

    public static class Ltr
    extends SetEditorBidiTextDirectionAction {
        public Ltr() {
            super(BidiTextDirection.LTR);
        }
    }

    public static class ContentBased
    extends SetEditorBidiTextDirectionAction {
        public ContentBased() {
            super(BidiTextDirection.CONTENT_BASED);
        }
    }
}

