/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectStoreClassProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.project.ProjectKt;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimedReference;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ProjectImpl
extends PlatformComponentManagerImpl
implements ProjectEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectImpl");
    public static final String NAME_FILE = ".name";
    public static final Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    public static final Key<String> CREATION_TRACE = Key.create((String)"ProjectImpl.CREATION_TRACE");
    public static final String LIGHT_PROJECT_NAME = "light_temp";
    private final AtomicBoolean mySavingInProgress;
    private String myName;
    private final boolean myLight;
    private static boolean ourClassesAreLoaded;
    private volatile boolean temporarilyDisposed;

    protected ProjectImpl(@NotNull String filePath, @Nullable String projectName) {
        if (filePath == null) {
            ProjectImpl.$$$reportNull$$$0(0);
        }
        super((ComponentManager)ApplicationManager.getApplication(), "Project " + (projectName == null ? filePath : projectName));
        this.mySavingInProgress = new AtomicBoolean(false);
        this.putUserData(CREATION_TIME, System.nanoTime());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.putUserData(CREATION_TRACE, DebugUtil.currentStackTrace());
        }
        this.getPicoContainer().registerComponentInstance(Project.class, (Object)this);
        if (!this.isDefault()) {
            this.getStateStore().setPath(filePath);
        }
        this.myName = projectName;
        this.myLight = ApplicationManager.getApplication().isUnitTestMode() && filePath.contains(LIGHT_PROJECT_NAME);
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed() || this.temporarilyDisposed;
    }

    public boolean isLight() {
        return this.myLight;
    }

    void setTemporarilyDisposed(boolean disposed) {
        this.temporarilyDisposed = disposed;
    }

    boolean isTemporarilyDisposed() {
        return this.temporarilyDisposed;
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            ProjectImpl.$$$reportNull$$$0(1);
        }
        if (!projectName.equals(this.myName)) {
            this.myName = projectName;
            StartupManager.getInstance((Project)this).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
                if (this.isDisposed()) {
                    return;
                }
                JFrame frame = WindowManager.getInstance().getFrame((Project)this);
                String title = FrameTitleBuilder.getInstance().getProjectTitle(this);
                if (frame != null && title != null) {
                    frame.setTitle(title);
                }
            }));
        }
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            ProjectImpl.$$$reportNull$$$0(2);
        }
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        super.bootstrapPicoContainer(name);
        MutablePicoContainer picoContainer = this.getPicoContainer();
        final ProjectStoreClassProvider projectStoreClassProvider = (ProjectStoreClassProvider)picoContainer.getComponentInstanceOfType(ProjectStoreClassProvider.class);
        picoContainer.registerComponentImplementation(PathMacroManager.class, ProjectPathMacroManager.class);
        picoContainer.registerComponent(new ComponentAdapter(){
            private ComponentAdapter myDelegate;

            @NotNull
            private ComponentAdapter getDelegate() {
                if (this.myDelegate == null) {
                    Class<? extends IComponentStore> storeClass = projectStoreClassProvider.getProjectStoreClass(ProjectImpl.this.isDefault());
                    this.myDelegate = new CachingConstructorInjectionComponentAdapter(storeClass, storeClass, null, true);
                }
                ComponentAdapter componentAdapter = this.myDelegate;
                if (componentAdapter == null) {
                    1.$$$reportNull$$$0(0);
                }
                return componentAdapter;
            }

            public Object getComponentKey() {
                return IComponentStore.class;
            }

            public Class getComponentImplementation() {
                return this.getDelegate().getComponentImplementation();
            }

            public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                return this.getDelegate().getComponentInstance(container);
            }

            public void verify(PicoContainer container) throws PicoIntrospectionException {
                this.getDelegate().verify(container);
            }

            public void accept(PicoVisitor visitor2) {
                visitor2.visitComponentAdapter((ComponentAdapter)this);
                this.getDelegate().accept(visitor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl$1", "getDelegate"));
            }
        });
    }

    @NotNull
    IProjectStore getStateStore() {
        IProjectStore iProjectStore = ProjectKt.getStateStore(this);
        if (iProjectStore == null) {
            ProjectImpl.$$$reportNull$$$0(3);
        }
        return iProjectStore;
    }

    public boolean isOpen() {
        return ProjectManagerEx.getInstanceEx().isProjectOpened(this);
    }

    public boolean isInitialized() {
        return !this.isDisposed() && this.isOpen() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    @Override
    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            ProjectImpl.$$$reportNull$$$0(4);
        }
        ComponentConfig[] componentConfigArray = plugin.getProjectComponents();
        if (componentConfigArray == null) {
            ProjectImpl.$$$reportNull$$$0(5);
        }
        return componentConfigArray;
    }

    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return this.isDefault() ? null : this.getStateStore().getProjectFilePath();
    }

    public VirtualFile getProjectFile() {
        return this.isDefault() ? null : LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectFilePath());
    }

    public VirtualFile getBaseDir() {
        return this.isDefault() ? null : LocalFileSystem.getInstance().findFileByPath(this.getStateStore().getProjectBasePath());
    }

    @Nullable
    public @SystemIndependent String getBasePath() {
        return this.isDefault() ? null : this.getStateStore().getProjectBasePath();
    }

    @NotNull
    public String getName() {
        if (this.myName == null) {
            String string = this.getStateStore().getProjectName();
            if (string == null) {
                ProjectImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public @SystemDependent String getPresentableUrl() {
        if (this.isDefault()) {
            return null;
        }
        IProjectStore store = this.getStateStore();
        return PathUtil.toSystemDependentName((String)(store.getStorageScheme() == StorageScheme.DIRECTORY_BASED ? store.getProjectBasePath() : store.getProjectFilePath()));
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String prefix = !this.isDefault() && this.getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED ? "" : this.getName();
        String string = prefix + Integer.toHexString(str.hashCode());
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        String workspaceFilePath = this.isDefault() ? null : this.getStateStore().getWorkspaceFilePath();
        return workspaceFilePath == null ? null : LocalFileSystem.getInstance().findFileByPath(workspaceFilePath);
    }

    @Override
    public void init() {
        long start = System.currentTimeMillis();
        ProgressIndicator progressIndicator = this.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        this.init(progressIndicator);
        long time = System.currentTimeMillis() - start;
        String message = this.getComponentConfigCount() + " project components initialized in " + time + " ms";
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            LOG.debug(message);
        } else {
            LOG.info(message);
        }
        if (!this.isDefault() && !application.isHeadlessEnvironment()) {
            this.distributeProgress();
        }
        if (this.myName == null) {
            this.myName = this.getStateStore().getProjectName();
        }
        ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)this);
    }

    @Override
    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(9);
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded() / (double)(ourClassesAreLoaded ? 10 : 2));
    }

    private void distributeProgress() {
        double modulesPart;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this);
        if (!(moduleManager instanceof ModuleManagerImpl)) {
            return;
        }
        double toDistribute = 1.0 - indicator.getFraction();
        int modulesCount = ((ModuleManagerImpl)moduleManager).getModulePathsCount();
        EditorsSplitters splitters = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this)).getMainSplitters();
        int editors = splitters.getEditorsCount();
        double d = modulesPart = ourClassesAreLoaded || editors == 0 ? toDistribute : toDistribute * 0.5;
        if (modulesCount != 0) {
            double step = modulesPart / (double)modulesCount;
            ((ModuleManagerImpl)moduleManager).setProgressStep(step);
        }
        if (editors != 0) {
            splitters.setProgressStep(toDistribute - modulesPart / (double)editors);
        }
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean isForce) {
        if (!ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            return;
        }
        if (!this.mySavingInProgress.compareAndSet(false, true)) {
            return;
        }
        HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
        try {
            StoreUtil.save(ServiceKt.getStateStore(this), this, isForce);
        }
        finally {
            this.mySavingInProgress.set(false);
            ((ProjectEx.ProjectSaved)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectEx.ProjectSaved.TOPIC)).saved(this);
        }
    }

    @Override
    public synchronized void dispose() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertWriteAccessAllowed();
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this)) {
            throw new IllegalStateException("Must call .dispose() for a closed project only. See ProjectManager.closeProject() or ProjectUtil.closeAndDispose().");
        }
        LOG.assertTrue(!super.isDisposed(), (Object)(this + " is disposed already"));
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        TimedReference.disposeTimed();
        LaterInvocator.purgeExpiredItems();
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ProjectImpl.$$$reportNull$$$0(10);
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            ProjectImpl.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        AreaPicoContainer areaPicoContainer = Extensions.getArea((AreaInstance)this).getPicoContainer();
        if (areaPicoContainer == null) {
            ProjectImpl.$$$reportNull$$$0(12);
        }
        return areaPicoContainer;
    }

    public boolean isDefault() {
        return false;
    }

    @NonNls
    public String toString() {
        return "Project" + (this.isDisposed() ? " (Disposed" + (this.temporarilyDisposed ? " temporarily" : "") + ")" : (this.isDefault() ? "" : " '" + this.getPresentableUrl() + "'")) + (this.isDefault() ? " (Default)" : "") + " " + this.getName();
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPicoContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProjectName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bootstrapPicoContainer";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMyComponentConfigsFromDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

