/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.FrameState;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WindowStateServiceImpl
extends WindowStateService
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    @NonNls
    private static final String MAXIMIZED = "maximized";
    @NonNls
    private static final String FULL_SCREEN = "full-screen";
    private static final Logger LOG = Logger.getInstance(WindowStateService.class);
    private final Map<String, WindowState> myStateMap = new TreeMap<String, WindowState>();

    WindowStateServiceImpl() {
    }

    abstract Point getDefaultLocationFor(@NotNull String var1);

    abstract Dimension getDefaultSizeFor(@NotNull String var1);

    abstract Rectangle getDefaultBoundsFor(@NotNull String var1);

    abstract boolean getDefaultMaximizedFor(Object var1, @NotNull String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getState() {
        Element element = new Element(STATE);
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            for (Map.Entry<String, WindowState> entry : this.myStateMap.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                WindowState state2 = entry.getValue();
                Element child = new Element(STATE);
                if (state2.myLocation != null) {
                    child.setAttribute(X, Integer.toString(((WindowState)state2).myLocation.x));
                    child.setAttribute(Y, Integer.toString(((WindowState)state2).myLocation.y));
                }
                if (state2.mySize != null) {
                    child.setAttribute(WIDTH, Integer.toString(((WindowState)state2).mySize.width));
                    child.setAttribute(HEIGHT, Integer.toString(((WindowState)state2).mySize.height));
                }
                if (state2.myMaximized) {
                    child.setAttribute(MAXIMIZED, Boolean.toString(true));
                }
                if (state2.myFullScreen) {
                    child.setAttribute(FULL_SCREEN, Boolean.toString(true));
                }
                child.setAttribute(KEY, key);
                element.addContent(child);
            }
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(@NotNull Element element) {
        if (element == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(0);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            this.myStateMap.clear();
            for (Element child : element.getChildren()) {
                String key;
                if (!STATE.equals(child.getName()) || (key = child.getAttributeValue(KEY)) == null) continue;
                Point location = null;
                try {
                    location = new Point(Integer.parseInt(child.getAttributeValue(X)), Integer.parseInt(child.getAttributeValue(Y)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Dimension size = null;
                try {
                    size = new Dimension(Integer.parseInt(child.getAttributeValue(WIDTH)), Integer.parseInt(child.getAttributeValue(HEIGHT)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (location == null && size == null) continue;
                WindowState state2 = new WindowState();
                state2.myLocation = location;
                state2.mySize = size;
                state2.myMaximized = Boolean.parseBoolean(child.getAttributeValue(MAXIMIZED));
                state2.myFullScreen = Boolean.parseBoolean(child.getAttributeValue(FULL_SCREEN));
                this.myStateMap.put(key, state2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStateFor(Object object, @NotNull String key, @NotNull Component component) {
        Frame frame;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(1);
        }
        if (component == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(2);
        }
        Point location = null;
        Dimension size = null;
        boolean maximized = false;
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            WindowState state2 = this.getFor(object, key, WindowState.class);
            if (state2 != null) {
                location = state2.myLocation;
                size = state2.mySize;
                maximized = state2.myMaximized;
            }
        }
        if (location == null && size == null) {
            location = this.getDefaultLocationFor(key);
            if (!WindowStateServiceImpl.isVisible(location, size = this.getDefaultSizeFor(key))) {
                return false;
            }
            maximized = this.getDefaultMaximizedFor(object, key);
        }
        Frame frame2 = frame = component instanceof Frame ? (Frame)component : null;
        if (frame != null && 0 != frame.getExtendedState()) {
            frame.setExtendedState(0);
        }
        Rectangle bounds = component.getBounds();
        if (location != null) {
            bounds.setLocation(location);
        }
        if (size != null) {
            bounds.setSize(size);
        }
        if (bounds.isEmpty()) {
            bounds.setSize(component.getPreferredSize());
        }
        component.setBounds(bounds);
        if (maximized && frame != null) {
            frame.setExtendedState(6);
        }
        return true;
    }

    public void saveStateFor(Object object, @NotNull String key, @NotNull Component component) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(3);
        }
        if (component == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(4);
        }
        FrameState state2 = FrameState.getFrameState(component);
        this.putFor(object, key, state2.getLocation(), true, state2.getSize(), true, state2.isMaximized(), true, state2.isFullScreen(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationFor(Object object, @NotNull String key) {
        Point location;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(5);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            location = this.getFor(object, key, Point.class);
        }
        return location != null ? location : this.getDefaultLocationFor(key);
    }

    public void putLocationFor(Object object, @NotNull String key, Point location) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(6);
        }
        this.putFor(object, key, location, true, null, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getSizeFor(Object object, @NotNull String key) {
        Dimension size;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(7);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            size = this.getFor(object, key, Dimension.class);
        }
        return size != null ? size : this.getDefaultSizeFor(key);
    }

    public void putSizeFor(Object object, @NotNull String key, Dimension size) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(8);
        }
        this.putFor(object, key, null, false, size, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBoundsFor(Object object, @NotNull String key) {
        Rectangle bounds;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(9);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            bounds = this.getFor(object, key, Rectangle.class);
        }
        return bounds != null ? bounds : this.getDefaultBoundsFor(key);
    }

    public void putBoundsFor(Object object, @NotNull String key, Rectangle bounds) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(10);
        }
        Point location = bounds == null ? null : bounds.getLocation();
        Dimension size = bounds == null ? null : bounds.getSize();
        this.putFor(object, key, location, true, size, true, false, false, false, false);
    }

    private <T> T getFor(Object object, @NotNull String key, @NotNull Class<T> type) {
        GraphicsDevice screen;
        float scale;
        Function<String, Object> getState2;
        Object state2;
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(11);
        }
        if (type == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(12);
        }
        if ((state2 = (getState2 = arg_0 -> this.lambda$getFor$0(scale = WindowStateServiceImpl.getSysScale(screen = WindowStateServiceImpl.getScreen(object)), type, arg_0)).apply(WindowStateServiceImpl.getKey(screen, key))) == null) {
            state2 = getState2.apply(WindowStateServiceImpl.getOldKey(screen, key));
        }
        if (state2 != null) {
            return (T)state2;
        }
        if (object != null) {
            return this.getFor(null, key, type);
        }
        return (T)getState2.apply(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFor(Object object, @NotNull String key, Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (key == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(13);
        }
        Map<String, WindowState> map2 = this.myStateMap;
        synchronized (map2) {
            GraphicsDevice screen = WindowStateServiceImpl.getScreen(object);
            float scale = WindowStateServiceImpl.getSysScale(screen);
            BiFunction<String, String, Void> putState = (newKey, oldKey) -> {
                WindowState state2;
                WindowState oldState;
                WindowState windowState = oldState = oldKey != null ? this.myStateMap.remove(oldKey) : null;
                if (oldState != null) {
                    oldState.scaleDown(scale);
                    WindowState newState = this.myStateMap.get(newKey);
                    if (newState != null) {
                        newState.merge(oldState);
                    } else {
                        this.myStateMap.put((String)newKey, oldState);
                    }
                }
                if ((state2 = this.myStateMap.get(newKey)) != null) {
                    if (state2.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                        state2.scaleUp(scale);
                    } else {
                        this.myStateMap.remove(newKey);
                    }
                } else {
                    state2 = new WindowState();
                    if (state2.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                        state2.scaleUp(scale);
                        this.myStateMap.put((String)newKey, state2);
                    }
                }
                return null;
            };
            putState.apply(WindowStateServiceImpl.getKey(screen, key), WindowStateServiceImpl.getOldKey(screen, key));
            if (screen != null) {
                putState.apply(WindowStateServiceImpl.getKey(null, key), WindowStateServiceImpl.getOldKey(null, key));
            }
            putState.apply(key, null);
        }
    }

    private static float getSysScale(GraphicsDevice screen) {
        return UIUtil.isJreHiDPIEnabled() && screen != null ? JBUI.sysScale((GraphicsConfiguration)screen.getDefaultConfiguration()) : 1.0f;
    }

    @NotNull
    private static String getOldKey(@Nullable GraphicsDevice screen, String key) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key + ".headless";
            if (string == null) {
                WindowStateServiceImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key);
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(device, bounds);
            sb.append('/').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        if (screen != null) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(screen, bounds);
            sb.append('@').append(bounds.x);
            sb.append('.').append(bounds.y);
            sb.append('.').append(bounds.width);
            sb.append('.').append(bounds.height);
        }
        String string = sb.toString();
        if (string == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getKey(@Nullable GraphicsDevice screen, String key) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (environment.isHeadlessInstance()) {
            String string = key + ".headless";
            if (string == null) {
                WindowStateServiceImpl.$$$reportNull$$$0(16);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(key);
        if (screen == null) {
            for (GraphicsDevice device : environment.getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                WindowStateServiceImpl.normalizeSize(device, bounds);
                sb.append('/').append(bounds.width);
                sb.append('.').append(bounds.height);
            }
        } else {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            WindowStateServiceImpl.normalizeSize(screen, bounds);
            sb.append('@').append(bounds.width);
            sb.append('.').append(bounds.height);
            if (JBUI.isPixHiDPI((GraphicsConfiguration)screen.getDefaultConfiguration())) {
                int dpi = (int)(96.0f * JBUI.pixScale((GraphicsConfiguration)screen.getDefaultConfiguration()));
                sb.append("@").append(dpi).append("dpi");
            }
        }
        String string = sb.toString();
        if (string == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void normalizeSize(GraphicsDevice screen, Rectangle bounds) {
        if (UIUtil.isJreHiDPIEnabled()) {
            float scale = JBUI.sysScale((GraphicsConfiguration)screen.getDefaultConfiguration());
            bounds.setSize((int)Math.ceil((float)bounds.width * scale), (int)Math.ceil((float)bounds.height * scale));
        }
    }

    private static GraphicsDevice getScreen(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Project) {
            Project project = (Project)object;
            object = WindowManager.getInstance().getFrame(project);
            if (object == null) {
                LOG.warn("cannot find a project frame for " + project);
                return null;
            }
        }
        if (object instanceof Window) {
            GraphicsDevice device;
            Window window = (Window)object;
            GraphicsConfiguration gc = window.getGraphicsConfiguration();
            GraphicsDevice graphicsDevice = device = gc != null ? window.getGraphicsConfiguration().getDevice() : ScreenUtil.getScreenDevice((Rectangle)window.getBounds());
            if (device != null) {
                return device;
            }
        }
        LOG.warn("cannot find a screen for " + object);
        return null;
    }

    private static boolean isVisible(WindowState state2) {
        return state2 != null && WindowStateServiceImpl.isVisible(state2.myLocation, state2.mySize);
    }

    private static boolean isVisible(Point location, Dimension size) {
        if (location == null) {
            return size != null;
        }
        if (ScreenUtil.isVisible((Point)location)) {
            return true;
        }
        if (size == null) {
            return false;
        }
        return ScreenUtil.isVisible((Rectangle)new Rectangle(location, size));
    }

    private /* synthetic */ Object lambda$getFor$0(float scale, @NotNull Class type, String _key) {
        WindowState state2;
        if (type == null) {
            WindowStateServiceImpl.$$$reportNull$$$0(18);
        }
        if ((state2 = this.myStateMap.get(_key)) == null) {
            return null;
        }
        if (WindowStateServiceImpl.isVisible(state2 = state2.copy().scaleDown(scale))) {
            if (type == WindowState.class) {
                return state2;
            }
            if (type == Point.class) {
                return state2.getLocation();
            }
            if (type == Dimension.class) {
                return state2.getSize();
            }
            if (type == Rectangle.class) {
                return state2.getBounds();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/WindowStateServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/WindowStateServiceImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldKey";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadStateFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveStateFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocationFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putLocationFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSizeFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putSizeFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBoundsFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putBoundsFor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putFor";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class WindowState {
        private Point myLocation;
        private Dimension mySize;
        private boolean myMaximized;
        private boolean myFullScreen;

        private WindowState() {
        }

        private Point getLocation() {
            return this.myLocation == null ? null : new Point(this.myLocation);
        }

        private Dimension getSize() {
            return this.mySize == null ? null : new Dimension(this.mySize);
        }

        private Rectangle getBounds() {
            return this.myLocation == null || this.mySize == null ? null : new Rectangle(this.myLocation, this.mySize);
        }

        private WindowState scaleDown(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            if (this.myLocation != null) {
                this.myLocation.setLocation((float)this.myLocation.x / scale, (float)this.myLocation.y / scale);
            }
            if (this.mySize != null) {
                this.mySize.setSize((float)this.mySize.width / scale, (float)this.mySize.height / scale);
            }
            return this;
        }

        public WindowState scaleUp(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            if (this.myLocation != null) {
                this.myLocation.setLocation((float)this.myLocation.x * scale, (float)this.myLocation.y * scale);
            }
            if (this.mySize != null) {
                this.mySize.setSize((float)this.mySize.width * scale, (float)this.mySize.height * scale);
            }
            return this;
        }

        private WindowState copy() {
            WindowState ws = new WindowState();
            ws.myLocation = this.myLocation == null ? null : this.myLocation.getLocation();
            ws.mySize = this.mySize == null ? null : this.mySize.getSize();
            ws.myMaximized = this.myMaximized;
            ws.myFullScreen = this.myFullScreen;
            return ws;
        }

        private boolean set(Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
            if (locationSet) {
                Point point = this.myLocation = location == null ? null : new Point(location);
            }
            if (sizeSet) {
                Dimension dimension = this.mySize = size == null ? null : new Dimension(size);
            }
            if (maximizedSet) {
                this.myMaximized = maximized;
            }
            if (fullScreenSet) {
                this.myFullScreen = fullScreen;
            }
            return this.myLocation != null || this.mySize != null;
        }

        private void merge(@NotNull WindowState state2) {
            if (state2 == null) {
                WindowState.$$$reportNull$$$0(0);
            }
            if (this.myLocation == null && state2.myLocation != null) {
                this.myLocation = state2.myLocation.getLocation();
            }
            if (this.mySize == null && state2.mySize != null) {
                this.mySize = state2.mySize.getSize();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", WindowStateServiceImpl.STATE, "com/intellij/openapi/util/WindowStateServiceImpl$WindowState", "merge"));
        }
    }
}

