/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(0);
        }
        boolean enabled = e.getProject() != null && !UtilKt.isEmpty(this.getUnversionedFiles(e, e.getProject()));
        e.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace()) || "ChangesViewPopup".equals(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e, project).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project, unversionedFiles, (Condition<FileStatus>)((Condition)this::isStatusForAddition), (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    public static boolean addUnversioned(@NotNull Project project, @NotNull List<VirtualFile> files2, @NotNull Condition<FileStatus> unversionedFileCondition, @Nullable ChangesBrowserBase browser) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(3);
        }
        if (unversionedFileCondition == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(4);
        }
        LocalChangeList targetChangeList = null;
        Consumer changeConsumer = null;
        if (browser instanceof CommitDialogChangesBrowser) {
            targetChangeList = ((CommitDialogChangesBrowser)browser).getSelectedChangeList();
        }
        if (browser != null) {
            changeConsumer = changes -> browser.getViewer().includeChanges((Collection<?>)changes);
        }
        return ScheduleForAdditionAction.addUnversioned(project, files2, targetChangeList, (Consumer<List<Change>>)changeConsumer, unversionedFileCondition);
    }

    private static boolean addUnversioned(@NotNull Project project, @NotNull List<VirtualFile> files2, @Nullable LocalChangeList targetChangeList, @Nullable Consumer<List<Change>> changesConsumer, @NotNull Condition<FileStatus> unversionedFileCondition) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(6);
        }
        if (unversionedFileCondition == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(7);
        }
        if (files2.isEmpty()) {
            return true;
        }
        ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project);
        if (targetChangeList == null) {
            targetChangeList = manager.getDefaultChangeList();
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VcsException> exceptions = manager.addUnversionedFiles(targetChangeList, files2, unversionedFileCondition, changesConsumer);
        return exceptions.isEmpty();
    }

    @NotNull
    private Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project) {
        boolean hasExplicitUnversioned;
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(9);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        boolean bl = hasExplicitUnversioned = !UtilKt.isEmpty((Stream)((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY)));
        Stream<VirtualFile> stream = hasExplicitUnversioned ? (Stream<VirtualFile>)e.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY) : (this.checkVirtualFiles(e) ? UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))).filter(file2 -> this.isFileUnversioned((VirtualFile)file2, vcsManager, changeListManager)) : Stream.empty());
        if (stream == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(10);
        }
        return stream;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull ChangeListManager changeListManager) {
        AbstractVcs vcs;
        if (file2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(11);
        }
        if (vcsManager == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(12);
        }
        if (changeListManager == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(13);
        }
        return (vcs = vcsManager.getVcsFor(file2)) != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(changeListManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.UNKNOWN;
    }

    protected boolean checkVirtualFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(14);
        }
        return ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unversionedFileCondition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addUnversioned";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedFiles";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnversioned";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkVirtualFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

