/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffWithLocalAction
extends AnAction
implements DumbAware,
AnActionExtensionProvider {
    private final boolean myUseBeforeVersion;

    public ShowDiffWithLocalAction() {
        this(false);
        this.getTemplatePresentation().setIcon(AllIcons.Actions.DiffWithCurrent);
    }

    public ShowDiffWithLocalAction(boolean useBeforeVersion) {
        this.myUseBeforeVersion = useBeforeVersion;
        ActionUtil.copyFrom((AnAction)this, (String)(useBeforeVersion ? "Vcs.ShowDiffWithLocal.Before" : "Vcs.ShowDiffWithLocal"));
    }

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(0);
        }
        return e.getData(VcsDataKeys.CHANGES_SELECTION) != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(1);
        }
        if (ChangeListManager.getInstance((Project)(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).isFreezedWithNotification(null)) {
            return;
        }
        ListSelection selection = (ListSelection)e.getRequiredData(VcsDataKeys.CHANGES_SELECTION);
        ListSelection changesToLocal = selection.map(change -> this.getChangeWithLocal((Change)change));
        if (!changesToLocal.isEmpty()) {
            ShowDiffAction.showDiffForChange(project, (ListSelection<Change>)changesToLocal);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ListSelection selection = (ListSelection)e.getData(VcsDataKeys.CHANGES_SELECTION);
        boolean isInAir = CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext()));
        e.getPresentation().setEnabled(project != null && selection != null && !isInAir && this.canShowDiff(selection.getList()));
    }

    @Nullable
    private Change getChangeWithLocal(@NotNull Change c) {
        FilePath otherFile;
        ContentRevision otherRevision;
        if (c == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(3);
        }
        ContentRevision revision = this.myUseBeforeVersion ? c.getBeforeRevision() : c.getAfterRevision();
        ContentRevision contentRevision = otherRevision = this.myUseBeforeVersion ? c.getAfterRevision() : c.getBeforeRevision();
        if (!ShowDiffWithLocalAction.isValidRevision(revision)) {
            return null;
        }
        FilePath filePath = revision.getFile();
        if (filePath.getVirtualFile() == null && otherRevision != null && (otherFile = otherRevision.getFile()).getVirtualFile() != null) {
            filePath = otherFile;
        }
        ContentRevision contentRevision2 = CurrentContentRevision.create((FilePath)filePath);
        return new Change(revision, contentRevision2);
    }

    private boolean canShowDiff(@NotNull List<Change> changes) {
        if (changes == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(changes, c -> this.getChangeWithLocal((Change)c) != null);
    }

    private static boolean isValidRevision(@Nullable ContentRevision revision) {
        return revision != null && !revision.getFile().isNonLocal() && !revision.getFile().isDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ShowDiffWithLocalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChangeWithLocal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowDiff";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ShowDiffBeforeWithLocalAction
    extends ShowDiffWithLocalAction {
        public ShowDiffBeforeWithLocalAction() {
            super(true);
        }
    }
}

