/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

public class RefreshProgress
extends ProgressIndicatorBase {
    private static final Project[] NULL_ARRAY = new Project[]{null};
    private final String myMessage;

    @NotNull
    public static ProgressIndicator create(@NotNull String message) {
        Application app;
        if (message == null) {
            RefreshProgress.$$$reportNull$$$0(0);
        }
        Object object = (app = ApplicationManager.getApplication()) == null || app.isUnitTestMode() ? new EmptyProgressIndicator() : new RefreshProgress(message);
        if (object == null) {
            RefreshProgress.$$$reportNull$$$0(1);
        }
        return object;
    }

    private RefreshProgress(@NotNull String message) {
        if (message == null) {
            RefreshProgress.$$$reportNull$$$0(2);
        }
        super(true);
        this.myMessage = message;
    }

    @Override
    public void start() {
        super.start();
        this.updateIndicators(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.updateIndicators(false);
    }

    private void updateIndicators(boolean start) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            WindowManager windowManager = WindowManager.getInstance();
            if (windowManager == null) {
                return;
            }
            Project[] projects = ProjectManager.getInstance().getOpenProjects();
            if (projects.length == 0) {
                projects = NULL_ARRAY;
            }
            for (Project project : projects) {
                StatusBarEx statusBar = (StatusBarEx)windowManager.getStatusBar(project);
                if (statusBar == null) continue;
                if (start) {
                    statusBar.startRefreshIndication(this.myMessage);
                    continue;
                }
                statusBar.stopRefreshIndication();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshProgress";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

