/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesktopLayout {
    private static final Logger LOG = Logger.getInstance(DesktopLayout.class);
    private static final Comparator<WindowInfoImpl> ourWindowInfoComparator = (o1, o2) -> {
        int d = DesktopLayout.getAnchorWeight(o1.getAnchor()) - DesktopLayout.getAnchorWeight(o2.getAnchor());
        return d == 0 ? o1.getOrder() - o2.getOrder() : d;
    };
    static final String TAG = "layout";
    private final Map<String, WindowInfoImpl> myIdToInfo = new THashMap();
    private final ClearableLazyValue<List<WindowInfoImpl>> myRegisteredInfos = new ClearableLazyValue<List<WindowInfoImpl>>(){

        @NotNull
        protected List<WindowInfoImpl> compute() {
            if (DesktopLayout.this.myIdToInfo.isEmpty()) {
                List<WindowInfoImpl> list2 = Collections.emptyList();
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }
            ArrayList<WindowInfoImpl> result2 = new ArrayList<WindowInfoImpl>();
            for (WindowInfoImpl value : DesktopLayout.this.myIdToInfo.values()) {
                if (!value.isRegistered()) continue;
                result2.add(value);
            }
            result2.sort(ourWindowInfoComparator);
            ArrayList<WindowInfoImpl> arrayList = result2;
            if (arrayList == null) {
                1.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/DesktopLayout$1", "compute"));
        }
    };

    private static int getAnchorWeight(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(0);
        }
        if (anchor2 == ToolWindowAnchor.TOP) {
            return 1;
        }
        if (anchor2 == ToolWindowAnchor.LEFT) {
            return 2;
        }
        if (anchor2 == ToolWindowAnchor.BOTTOM) {
            return 3;
        }
        if (anchor2 == ToolWindowAnchor.RIGHT) {
            return 4;
        }
        return 0;
    }

    public final void copyFrom(@NotNull DesktopLayout layout) {
        if (layout == null) {
            DesktopLayout.$$$reportNull$$$0(1);
        }
        THashMap old = new THashMap(this.myIdToInfo);
        this.myIdToInfo.clear();
        for (WindowInfoImpl otherInfo : layout.myIdToInfo.values()) {
            WindowInfoImpl oldInfo = (WindowInfoImpl)old.get(otherInfo.getId());
            if (oldInfo == null) {
                WindowInfoImpl newInfo = otherInfo.copy();
                newInfo.setRegistered(otherInfo.isRegistered());
                this.myIdToInfo.put(otherInfo.getId(), newInfo);
                continue;
            }
            oldInfo.copyFrom(otherInfo);
            oldInfo.setRegistered(otherInfo.isRegistered());
            this.myIdToInfo.put(otherInfo.getId(), oldInfo);
        }
        this.normalizeOrders();
    }

    private void normalizeOrders() {
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.TOP));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.LEFT));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.BOTTOM));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.RIGHT));
        this.myRegisteredInfos.drop();
    }

    final WindowInfoImpl register(@NotNull String id, @NotNull ToolWindowAnchor anchor2, boolean splitMode) {
        WindowInfoImpl info;
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(2);
        }
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(3);
        }
        if ((info = this.myIdToInfo.get(id)) == null) {
            info = new WindowInfoImpl();
            info.setId(id);
            info.setAnchor(anchor2);
            info.setSplit(splitMode);
            this.myIdToInfo.put(id, info);
        }
        if (!info.isRegistered()) {
            info.setRegistered(true);
            this.myRegisteredInfos.drop();
        }
        return info;
    }

    final void unregister(@NotNull String id) {
        WindowInfoImpl info;
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(4);
        }
        if ((info = this.myIdToInfo.get(id)).isRegistered()) {
            info.setRegistered(false);
            this.myRegisteredInfos.drop();
        }
    }

    final WindowInfoImpl getInfo(@NotNull String id, boolean onlyRegistered) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(5);
        }
        WindowInfoImpl info = this.myIdToInfo.get(id);
        if (onlyRegistered && info != null && !info.isRegistered()) {
            return null;
        }
        return info;
    }

    @Nullable
    final String getActiveId() {
        for (WindowInfoImpl info : this.getInfos()) {
            if (!info.isActive()) continue;
            return info.getId();
        }
        return null;
    }

    @NotNull
    final List<WindowInfoImpl> getInfos() {
        List list2 = (List)this.myRegisteredInfos.getValue();
        if (list2 == null) {
            DesktopLayout.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private List<WindowInfoImpl> getAllInfos(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(7);
        }
        ArrayList<WindowInfoImpl> result2 = new ArrayList<WindowInfoImpl>();
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (anchor2 != info.getAnchor()) continue;
            result2.add(info);
        }
        result2.sort(ourWindowInfoComparator);
        ArrayList<WindowInfoImpl> arrayList = result2;
        if (arrayList == null) {
            DesktopLayout.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void normalizeOrder(@NotNull List<WindowInfoImpl> infos) {
        if (infos == null) {
            DesktopLayout.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < infos.size(); ++i) {
            infos.get(i).setOrder(i);
        }
    }

    final boolean isToolWindowRegistered(@NotNull String id) {
        WindowInfoImpl info;
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(10);
        }
        return (info = this.myIdToInfo.get(id)) != null && info.isRegistered();
    }

    @NotNull
    final Comparator<StripeButton> comparator(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(11);
        }
        MyStripeButtonComparator myStripeButtonComparator = new MyStripeButtonComparator(anchor2);
        if (myStripeButtonComparator == null) {
            DesktopLayout.$$$reportNull$$$0(12);
        }
        return myStripeButtonComparator;
    }

    private int getMaxOrder(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(13);
        }
        int res = -1;
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (anchor2 != info.getAnchor() || res >= info.getOrder()) continue;
            res = info.getOrder();
        }
        return res;
    }

    final void setAnchor(@NotNull String id, @NotNull ToolWindowAnchor newAnchor, int newOrder) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(14);
        }
        if (newAnchor == null) {
            DesktopLayout.$$$reportNull$$$0(15);
        }
        if (newOrder == -1) {
            newOrder = this.getMaxOrder(newAnchor) + 1;
        }
        WindowInfoImpl info = this.getInfo(id, true);
        ToolWindowAnchor oldAnchor = info.getAnchor();
        List<WindowInfoImpl> infos = this.getAllInfos(newAnchor);
        for (int i = infos.size() - 1; i > -1; --i) {
            WindowInfoImpl info2 = infos.get(i);
            if (newOrder > info2.getOrder()) continue;
            info2.setOrder(info2.getOrder() + 1);
        }
        info.setAnchor(newAnchor);
        info.setOrder(newOrder);
        DesktopLayout.normalizeOrder(this.getAllInfos(oldAnchor));
        if (oldAnchor != newAnchor) {
            DesktopLayout.normalizeOrder(this.getAllInfos(newAnchor));
        }
        this.myRegisteredInfos.drop();
    }

    final void setSplitMode(@NotNull String id, boolean split) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(16);
        }
        this.getInfo(id, true).setSplit(split);
    }

    public final void readExternal(@NotNull Element layoutElement) {
        if (layoutElement == null) {
            DesktopLayout.$$$reportNull$$$0(17);
        }
        THashSet registered = new THashSet();
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (!info.isRegistered()) continue;
            registered.add(info.getId());
        }
        this.myIdToInfo.clear();
        for (Element e : layoutElement.getChildren("window_info")) {
            WindowInfoImpl info = (WindowInfoImpl)XmlSerializer.deserialize((Element)e, WindowInfoImpl.class);
            info.normalizeAfterRead();
            if (info.getId() == null) {
                LOG.warn("Skip invalid window info (no id): " + JDOMUtil.writeElement((Element)e));
                continue;
            }
            if (registered.contains(info.getId())) {
                info.setRegistered(true);
            }
            this.myIdToInfo.put(info.getId(), info);
        }
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (info.getOrder() != -1) continue;
            info.setOrder(this.getMaxOrder(info.getAnchor()) + 1);
        }
        this.normalizeOrders();
    }

    @Nullable
    public final Element writeExternal(@NotNull String tagName) {
        if (tagName == null) {
            DesktopLayout.$$$reportNull$$$0(18);
        }
        if (this.myIdToInfo.isEmpty()) {
            return null;
        }
        ArrayList<WindowInfoImpl> list2 = new ArrayList<WindowInfoImpl>(this.myIdToInfo.values());
        list2.sort(ourWindowInfoComparator);
        Element state2 = new Element(tagName);
        for (WindowInfoImpl info : list2) {
            Element element = XmlSerializer.serialize((Object)info);
            if (element == null) continue;
            state2.addContent(element);
        }
        return state2;
    }

    @NotNull
    List<String> getVisibleIdsOn(@NotNull ToolWindowAnchor anchor2, @NotNull ToolWindowManagerImpl manager) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(19);
        }
        if (manager == null) {
            DesktopLayout.$$$reportNull$$$0(20);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (WindowInfoImpl each : this.getAllInfos(anchor2)) {
            ToolWindow window = manager.getToolWindow(each.getId());
            if (window == null || !window.isAvailable() && !UISettings.getInstance().getAlwaysShowWindowsButton()) continue;
            ids.add(each.getId());
        }
        ArrayList<String> arrayList = ids;
        if (arrayList == null) {
            DesktopLayout.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = TAG;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/DesktopLayout";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAnchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/DesktopLayout";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInfos";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "comparator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleIdsOn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorWeight";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllInfos";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "normalizeOrder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowRegistered";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "comparator";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMaxOrder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAnchor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSplitMode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleIdsOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyStripeButtonComparator
    implements Comparator<StripeButton> {
        private final Map<String, WindowInfoImpl> myIdToInfo;

        public MyStripeButtonComparator(ToolWindowAnchor anchor2) {
            if (anchor2 == null) {
                MyStripeButtonComparator.$$$reportNull$$$0(0);
            }
            this.myIdToInfo = new THashMap();
            for (WindowInfoImpl info : DesktopLayout.this.getInfos()) {
                if (anchor2 != info.getAnchor()) continue;
                this.myIdToInfo.put(info.getId(), info.copy());
            }
        }

        @Override
        public final int compare(StripeButton obj1, StripeButton obj2) {
            WindowInfoImpl info1 = this.myIdToInfo.get(obj1.getWindowInfo().getId());
            int order1 = info1 != null ? info1.getOrder() : 0;
            WindowInfoImpl info2 = this.myIdToInfo.get(obj2.getWindowInfo().getId());
            int order2 = info2 != null ? info2.getOrder() : 0;
            return order1 - order2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout$MyStripeButtonComparator", "<init>"));
        }
    }
}

