/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.filter;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.ui.FilterComponent;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class InspectionFilterAction
extends DefaultActionGroup
implements Toggleable,
DumbAware {
    private static final int MIN_LANGUAGE_COUNT_TO_WRAP = 11;
    private final SeverityRegistrar mySeverityRegistrar;
    private final InspectionsFilter myInspectionsFilter;
    @NotNull
    private final FilterComponent myFilterComponent;
    private final String version;
    private final String presentableVersion;

    public InspectionFilterAction(@NotNull InspectionProfileImpl profile2, @NotNull InspectionsFilter inspectionsFilter, @NotNull Project project, @NotNull FilterComponent filterComponent) {
        if (profile2 == null) {
            InspectionFilterAction.$$$reportNull$$$0(0);
        }
        if (inspectionsFilter == null) {
            InspectionFilterAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            InspectionFilterAction.$$$reportNull$$$0(2);
        }
        if (filterComponent == null) {
            InspectionFilterAction.$$$reportNull$$$0(3);
        }
        super("Filter Inspections", true);
        this.version = ApplicationInfo.getInstance().getMajorVersion() + (StringUtil.isEmptyOrSpaces((String)StringUtil.trimStart((String)ApplicationInfo.getInstance().getMinorVersion(), (String)"0")) ? "" : "." + ApplicationInfo.getInstance().getMinorVersion());
        this.presentableVersion = ApplicationNamesInfo.getInstance().getProductName() + " " + this.version;
        this.myInspectionsFilter = inspectionsFilter;
        this.myFilterComponent = filterComponent;
        this.mySeverityRegistrar = profile2.getProfileManager().getSeverityRegistrar();
        this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
        this.tune(profile2, project);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().putClientProperty("selected", (Object)(!this.myInspectionsFilter.isEmptyFilter() ? 1 : 0));
    }

    private void tune(InspectionProfileImpl profile2, Project project) {
        this.addAction((AnAction)new ResetFilterAction());
        this.addSeparator();
        if (ApplicationNamesInfo.getInstance().getProductName().contains("IDEA")) {
            this.addAction(new ShowNewInspectionsAction());
        }
        this.addSeparator();
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(true));
        this.addAction((AnAction)new ShowEnabledOrDisabledInspectionsAction(false));
        this.addAction((AnAction)new ShowOnlyModifiedInspectionsAction());
        this.addSeparator();
        for (HighlightSeverity highlightSeverity : LevelChooserAction.getSeverities(this.mySeverityRegistrar)) {
            this.add((AnAction)new ShowWithSpecifiedSeverityInspectionsAction(highlightSeverity));
        }
        this.addSeparator();
        THashSet languageIds = new THashSet();
        for (ScopeToolState scopeToolState : profile2.getDefaultStates(project)) {
            languageIds.add(scopeToolState.getTool().getLanguage());
        }
        SmartList smartList = new SmartList();
        for (String id : languageIds) {
            Language language;
            if (id == null || (language = Language.findLanguageByID((String)id)) == null || language instanceof MetaLanguage) continue;
            smartList.add(language);
        }
        if (!smartList.isEmpty()) {
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup("Filter by Language", smartList.size() >= 11);
            this.add((AnAction)defaultActionGroup);
            Collections.sort(smartList, Comparator.comparing(Language::getDisplayName));
            for (Language language : smartList) {
                defaultActionGroup.add((AnAction)new LanguageFilterAction(language));
            }
            defaultActionGroup.add((AnAction)new LanguageFilterAction(null));
            this.addSeparator();
        }
        this.add((AnAction)new ShowAvailableOnlyOnAnalyzeInspectionsAction());
        this.add((AnAction)new ShowOnlyCleanupInspectionsAction());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "profile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionsFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "filterComponent";
                break;
            }
        }
        objectArray[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ShowOnlyModifiedInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowOnlyModifiedInspectionsAction() {
            super("Show Only Modified Inspections");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isShowOnlyModifiedInspections();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            InspectionFilterAction.this.myInspectionsFilter.setShowOnlyModifiedInspections(state2);
        }
    }

    private class ShowNewInspectionsAction
    extends AnAction
    implements DumbAware {
        private ShowNewInspectionsAction() {
            super("Show New Inspections in " + InspectionFilterAction.this.presentableVersion, "Shows new inspections which are available since " + InspectionFilterAction.this.presentableVersion, AllIcons.Actions.Lightning);
        }

        public void actionPerformed(AnActionEvent e) {
            InspectionFilterAction.this.myFilterComponent.setFilter("\"New in " + InspectionFilterAction.this.version + "\"");
        }
    }

    private class LanguageFilterAction
    extends CheckboxAction
    implements DumbAware {
        private final Language myLanguage;

        public LanguageFilterAction(Language language) {
            super(language == null ? "Language is not specified" : language.getDisplayName());
            this.myLanguage = language;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.containsLanguage(this.myLanguage);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                InspectionFilterAction.this.myInspectionsFilter.addLanguage(this.myLanguage);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeLanguage(this.myLanguage);
            }
        }
    }

    private class ShowEnabledOrDisabledInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final Boolean myShowEnabledActions;

        public ShowEnabledOrDisabledInspectionsAction(boolean showEnabledActions) {
            super("Show Only " + (showEnabledActions ? "Enabled" : "Disabled"));
            this.myShowEnabledActions = showEnabledActions;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.getSuitableInspectionsStates() == this.myShowEnabledActions;
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            boolean previousState = this.isSelected(e);
            InspectionFilterAction.this.myInspectionsFilter.setSuitableInspectionsStates(previousState ? null : this.myShowEnabledActions);
        }
    }

    private class ShowWithSpecifiedSeverityInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        private final HighlightSeverity mySeverity;

        private ShowWithSpecifiedSeverityInspectionsAction(HighlightSeverity severity) {
            super(SingleInspectionProfilePanel.renderSeverity(severity), null, HighlightDisplayLevel.find((HighlightSeverity)severity).getIcon());
            this.mySeverity = severity;
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.containsSeverity(this.mySeverity);
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            if (state2) {
                InspectionFilterAction.this.myInspectionsFilter.addSeverity(this.mySeverity);
            } else {
                InspectionFilterAction.this.myInspectionsFilter.removeSeverity(this.mySeverity);
            }
        }
    }

    private class ShowAvailableOnlyOnAnalyzeInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowAvailableOnlyOnAnalyzeInspectionsAction() {
            super("Show Only \"Available only for Analyze | Inspect Code\"");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isAvailableOnlyForAnalyze();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            InspectionFilterAction.this.myInspectionsFilter.setAvailableOnlyForAnalyze(state2);
        }
    }

    private class ShowOnlyCleanupInspectionsAction
    extends CheckboxAction
    implements DumbAware {
        public ShowOnlyCleanupInspectionsAction() {
            super("Show Only Cleanup Inspections");
        }

        public boolean isSelected(AnActionEvent e) {
            return InspectionFilterAction.this.myInspectionsFilter.isShowOnlyCleanupInspections();
        }

        public void setSelected(AnActionEvent e, boolean state2) {
            InspectionFilterAction.this.myInspectionsFilter.setShowOnlyCleanupInspections(state2);
        }
    }

    private class ResetFilterAction
    extends DumbAwareAction {
        public ResetFilterAction() {
            super("Reset Filter");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetFilterAction.$$$reportNull$$$0(0);
            }
            InspectionFilterAction.this.myInspectionsFilter.reset();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetFilterAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(!InspectionFilterAction.this.myInspectionsFilter.isEmptyFilter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/profile/codeInspection/ui/filter/InspectionFilterAction$ResetFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

