/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.util.XmlPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementImpl
extends CompositePsiElement
implements XmlElement {
    public XmlElementImpl(IElementType type) {
        super(type);
    }

    public boolean processElements(PsiElementProcessor processor2, PsiElement place) {
        return XmlPsiUtil.processXmlElements(this, processor2, false);
    }

    public boolean processChildren(PsiElementProcessor processor2) {
        return XmlPsiUtil.processXmlElementChildren(this, processor2, false);
    }

    public XmlElement findElementByTokenType(final IElementType type) {
        final XmlElement[] result2 = new XmlElement[]{null};
        this.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof TreeElement && ((ASTNode)element).getElementType() == type) {
                    result2[0] = (XmlElement)element;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlElementImpl$1", "execute"));
            }
        }, this);
        return result2[0];
    }

    @Override
    public PsiElement getContext() {
        XmlElement data = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
        if (data != null) {
            return data;
        }
        return this.getAstParent();
    }

    private PsiElement getAstParent() {
        return super.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        if (!this.isPhysical()) {
            XmlElement including = (XmlElement)this.getUserData(INCLUDING_ELEMENT);
            if (including != null) {
                XmlElement xmlElement = including;
                if (xmlElement == null) {
                    XmlElementImpl.$$$reportNull$$$0(0);
                }
                return xmlElement;
            }
            PsiElement astParent = this.getAstParent();
            PsiElement parentNavigation = astParent.getNavigationElement();
            if (parentNavigation.getTextOffset() == this.getTextOffset()) {
                PsiElement psiElement = parentNavigation;
                if (psiElement == null) {
                    XmlElementImpl.$$$reportNull$$$0(1);
                }
                return psiElement;
            }
            XmlElementImpl xmlElementImpl = this;
            if (xmlElementImpl == null) {
                XmlElementImpl.$$$reportNull$$$0(2);
            }
            return xmlElementImpl;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            XmlElementImpl.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @Override
    public PsiElement getParent() {
        return this.getContext();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.getContainingFile().getLanguage();
        if (language == null) {
            XmlElementImpl.$$$reportNull$$$0(4);
        }
        return language;
    }

    @Nullable
    protected static String getNameFromEntityRef(CompositeElement compositeElement, IElementType xmlEntityDeclStart) {
        ASTNode node = compositeElement.findChildByType(xmlEntityDeclStart);
        if (node == null) {
            return null;
        }
        ASTNode name = node.getTreeNext();
        if (name != null && name.getElementType() == TokenType.WHITE_SPACE) {
            name = name.getTreeNext();
        }
        if (name != null && name.getElementType() == XmlElementType.XML_ENTITY_REF) {
            final StringBuilder builder2 = new StringBuilder();
            ((XmlElement)name.getPsi()).processElements(new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    builder2.append(element.getText());
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlElementImpl$2", "execute"));
                }
            }, name.getPsi());
            if (builder2.length() > 0) {
                return builder2.toString();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        if (globalSearchScope == null) {
            XmlElementImpl.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        XmlElementImpl element1 = this;
        if (element1 instanceof XmlTag && another instanceof XmlTag && !element1.isPhysical() && !another.isPhysical()) {
            return element1.getText().equals(another.getText());
        }
        return false;
    }

    public boolean skipValidation() {
        PsiFile containingFile;
        Boolean doNotValidate = (Boolean)DO_NOT_VALIDATE.get((UserDataHolder)this);
        if (doNotValidate != null) {
            return doNotValidate;
        }
        OuterLanguageElement element = (OuterLanguageElement)PsiTreeUtil.getChildOfType((PsiElement)this, OuterLanguageElement.class);
        if (element == null) {
            for (PsiElement child = this.getFirstChild(); !(child == null || child instanceof XmlText && (element = (OuterLanguageElement)PsiTreeUtil.getChildOfType((PsiElement)child, OuterLanguageElement.class)) != null); child = child.getNextSibling()) {
            }
        }
        doNotValidate = element == null ? Boolean.valueOf(false) : Boolean.valueOf((containingFile = this.getContainingFile()).getViewProvider().getBaseLanguage() != containingFile.getLanguage());
        this.putUserData(DO_NOT_VALIDATE, doNotValidate);
        return doNotValidate;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(DO_NOT_VALIDATE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/source/xml/XmlElementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

