/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.inplace.MyLookupExpression;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.NotNullList;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.PositionTracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InplaceRefactoring {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.inplace.VariableInplaceRenamer");
    @NonNls
    protected static final String PRIMARY_VARIABLE_NAME = "PrimaryVariable";
    @NonNls
    protected static final String OTHER_VARIABLE_NAME = "OtherVariable";
    protected static final Stack<InplaceRefactoring> ourRenamersStack = new Stack();
    public static final Key<InplaceRefactoring> INPLACE_RENAMER = Key.create((String)"EditorInplaceRenamer");
    public static final Key<Boolean> INTRODUCE_RESTART = Key.create((String)"INTRODUCE_RESTART");
    protected PsiNamedElement myElementToRename;
    protected final Editor myEditor;
    protected final Project myProject;
    protected RangeMarker myRenameOffset;
    protected String myAdvertisementText;
    private ArrayList<RangeHighlighter> myHighlighters;
    protected String myInitialName;
    protected String myOldName;
    protected RangeMarker myBeforeRevert;
    protected String myInsertedName;
    protected LinkedHashSet<String> myNameSuggestions;
    protected StartMarkAction myMarkAction;
    protected PsiElement myScope;
    protected RangeMarker myCaretRangeMarker;
    protected Balloon myBalloon;
    protected String myTitle;
    protected RelativePoint myTarget;

    public InplaceRefactoring(@NotNull Editor editor, @Nullable PsiNamedElement elementToRename, @NotNull Project project) {
        if (editor == null) {
            InplaceRefactoring.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InplaceRefactoring.$$$reportNull$$$0(1);
        }
        this(editor, elementToRename, project, elementToRename != null ? elementToRename.getName() : null, elementToRename != null ? elementToRename.getName() : null);
    }

    public InplaceRefactoring(@NotNull Editor editor, @Nullable PsiNamedElement elementToRename, @NotNull Project project, @Nullable String oldName) {
        if (editor == null) {
            InplaceRefactoring.$$$reportNull$$$0(2);
        }
        if (project == null) {
            InplaceRefactoring.$$$reportNull$$$0(3);
        }
        this(editor, elementToRename, project, elementToRename != null ? elementToRename.getName() : null, oldName);
    }

    public InplaceRefactoring(@NotNull Editor editor, @Nullable PsiNamedElement elementToRename, @NotNull Project project, @Nullable String initialName, @Nullable String oldName) {
        if (editor == null) {
            InplaceRefactoring.$$$reportNull$$$0(4);
        }
        if (project == null) {
            InplaceRefactoring.$$$reportNull$$$0(5);
        }
        this.myBeforeRevert = null;
        this.myEditor = editor;
        this.myElementToRename = elementToRename;
        this.myProject = project;
        this.myOldName = oldName;
        if (this.myElementToRename != null) {
            this.myInitialName = initialName;
            PsiFile containingFile = this.myElementToRename.getContainingFile();
            if (!this.notSameFile(InplaceRefactoring.getTopLevelVirtualFile(containingFile.getViewProvider()), containingFile) && this.myElementToRename != null && this.myElementToRename.getTextRange() != null) {
                this.myRenameOffset = this.myEditor.getDocument().createRangeMarker(this.myElementToRename.getTextRange());
                this.myRenameOffset.setGreedyToRight(true);
                this.myRenameOffset.setGreedyToLeft(true);
            }
        }
    }

    public static void unableToStartWarning(Project project, Editor editor) {
        StartMarkAction startMarkAction = StartMarkAction.canStart(project);
        String message = startMarkAction.getCommandName() + " is not finished yet.";
        Document oldDocument = startMarkAction.getDocument();
        if (editor == null || oldDocument != editor.getDocument()) {
            int exitCode = Messages.showYesNoDialog((Project)project, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), (String)"Continue Started", (String)"Cancel Started", (Icon)Messages.getErrorIcon());
            InplaceRefactoring.navigateToStarted(oldDocument, project, exitCode);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
        }
    }

    public void setAdvertisementText(String advertisementText) {
        this.myAdvertisementText = advertisementText;
    }

    public boolean performInplaceRefactoring(LinkedHashSet<String> nameSuggestions) {
        this.myNameSuggestions = nameSuggestions;
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix((PsiElement)this.myElementToRename)) {
            return false;
        }
        FileViewProvider fileViewProvider = this.myElementToRename.getContainingFile().getViewProvider();
        VirtualFile file2 = InplaceRefactoring.getTopLevelVirtualFile(fileViewProvider);
        SearchScope referencesSearchScope = this.getReferencesSearchScope(file2);
        Collection<PsiReference> refs = this.collectRefs(referencesSearchScope);
        this.addReferenceAtCaret(refs);
        for (PsiReference ref : refs) {
            PsiFile containingFile = ref.getElement().getContainingFile();
            if (!this.notSameFile(file2, containingFile)) continue;
            return false;
        }
        PsiElement scope = this.checkLocalScope();
        if (scope == null) {
            return false;
        }
        PsiFile containingFile = scope.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)containingFile)) {
            return true;
        }
        this.myEditor.putUserData(INPLACE_RENAMER, (Object)this);
        ourRenamersStack.push((Object)this);
        NotNullList stringUsages = new NotNullList();
        this.collectAdditionalElementsToRename((List<Pair<PsiElement, TextRange>>)stringUsages);
        return this.buildTemplateAndStart(refs, (Collection<Pair<PsiElement, TextRange>>)stringUsages, scope, containingFile);
    }

    protected boolean notSameFile(@Nullable VirtualFile file2, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            InplaceRefactoring.$$$reportNull$$$0(6);
        }
        return !Comparing.equal((Object)InplaceRefactoring.getTopLevelVirtualFile(containingFile.getViewProvider()), (Object)file2);
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file2) {
        if (file2 == null) {
            return ProjectScope.getProjectScope((Project)this.myElementToRename.getProject());
        }
        PsiFile containingFile = this.myElementToRename.getContainingFile();
        if (!file2.equals(containingFile.getVirtualFile())) {
            PsiFile topLevelFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            return topLevelFile == null ? ProjectScope.getProjectScope((Project)this.myElementToRename.getProject()) : new LocalSearchScope((PsiElement)topLevelFile);
        }
        return new LocalSearchScope((PsiElement)containingFile);
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        SearchScope searchScope = PsiSearchHelper.getInstance((Project)this.myElementToRename.getProject()).getUseScope((PsiElement)this.myElementToRename);
        if (searchScope instanceof LocalSearchScope) {
            PsiElement[] elements = this.getElements((LocalSearchScope)searchScope);
            return PsiTreeUtil.findCommonParent((PsiElement[])elements);
        }
        return null;
    }

    @NotNull
    private PsiElement[] getElements(LocalSearchScope searchScope) {
        PsiElement[] elements = searchScope.getScope();
        FileViewProvider provider = this.myElementToRename.getContainingFile().getViewProvider();
        for (PsiElement element : elements) {
            if (element instanceof PsiFile && ((PsiFile)element).getViewProvider() == provider) continue;
            if (elements == null) {
                InplaceRefactoring.$$$reportNull$$$0(7);
            }
            return elements;
        }
        PsiElement[] psiElementArray = new PsiElement[]{this.myElementToRename.getContainingFile()};
        if (psiElementArray == null) {
            InplaceRefactoring.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    protected abstract void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> var1);

    protected abstract boolean shouldSelectAll();

    protected MyLookupExpression createLookupExpression(PsiElement selectedElement) {
        return new MyLookupExpression(this.getInitialName(), this.myNameSuggestions, this.myElementToRename, selectedElement, this.shouldSelectAll(), this.myAdvertisementText);
    }

    protected boolean acceptReference(PsiReference reference) {
        return true;
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        Query search2 = ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope, (boolean)false);
        CommonProcessors.CollectProcessor<PsiReference> processor2 = new CommonProcessors.CollectProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                return InplaceRefactoring.this.acceptReference(reference);
            }
        };
        search2.forEach((Processor)processor2);
        return processor2.getResults();
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
        PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
        this.myScope = context != null ? context.getContainingFile() : scope;
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(this.myScope);
        PsiElement nameIdentifier = this.getNameIdentifier();
        int offset = InjectedLanguageUtil.getTopLevelEditor(this.myEditor).getCaretModel().getOffset();
        PsiElement selectedElement = this.getSelectedInEditorElement(nameIdentifier, refs, stringUsages, offset);
        boolean subrefOnPrimaryElement = false;
        boolean hasReferenceOnNameIdentifier = false;
        for (PsiReference psiReference : refs) {
            if (this.isReferenceAtCaret(selectedElement, psiReference)) {
                builder2.replaceElement(psiReference.getElement(), this.getRangeToRename(psiReference), PRIMARY_VARIABLE_NAME, this.createLookupExpression(selectedElement), true);
                subrefOnPrimaryElement = true;
                continue;
            }
            this.addVariable(psiReference, selectedElement, builder2, offset);
            hasReferenceOnNameIdentifier |= this.isReferenceAtCaret(nameIdentifier, psiReference);
        }
        if (!(nameIdentifier == null || subrefOnPrimaryElement && (hasReferenceOnNameIdentifier |= selectedElement.getTextRange().contains(nameIdentifier.getTextRange())))) {
            this.addVariable(nameIdentifier, selectedElement, builder2);
        }
        for (Pair pair : stringUsages) {
            this.addVariable((PsiElement)pair.first, (TextRange)pair.second, selectedElement, builder2);
        }
        this.addAdditionalVariables(builder2);
        int segmentsLimit = Registry.intValue((String)"inplace.rename.segments.limit", (int)-1);
        if (segmentsLimit != -1 && builder2.getElementsCount() > segmentsLimit) {
            return false;
        }
        try {
            this.myMarkAction = this.startRename();
        }
        catch (StartMarkAction.AlreadyStartedException alreadyStartedException) {
            Document oldDocument = alreadyStartedException.getDocument();
            if (oldDocument != this.myEditor.getDocument()) {
                int exitCode = Messages.showYesNoCancelDialog((Project)this.myProject, (String)alreadyStartedException.getMessage(), (String)this.getCommandName(), (String)"Navigate to Started", (String)"Cancel Started", (String)"Cancel", (Icon)Messages.getErrorIcon());
                if (exitCode == 2) {
                    return true;
                }
                this.navigateToAlreadyStarted(oldDocument, exitCode);
                return true;
            }
            if (!ourRenamersStack.isEmpty() && ourRenamersStack.peek() == this) {
                ourRenamersStack.pop();
                if (!ourRenamersStack.empty()) {
                    this.myOldName = ((InplaceRefactoring)InplaceRefactoring.ourRenamersStack.peek()).myOldName;
                }
            }
            this.revertState();
            TemplateState templateState = TemplateManagerImpl.getTemplateState(InjectedLanguageUtil.getTopLevelEditor(this.myEditor));
            if (templateState != null) {
                templateState.gotoEnd(true);
            }
            return false;
        }
        this.beforeTemplateStart();
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(() -> this.startTemplate(builder2));
        if (this.myBalloon == null) {
            this.showBalloon();
        }
        return true;
    }

    protected boolean isReferenceAtCaret(PsiElement selectedElement, PsiReference ref) {
        TextRange textRange = ref.getRangeInElement().shiftRight(ref.getElement().getTextRange().getStartOffset());
        if (selectedElement != null) {
            TextRange selectedElementRange = selectedElement.getTextRange();
            LOG.assertTrue(selectedElementRange != null, (Object)selectedElement);
            if (selectedElementRange != null && selectedElementRange.contains(textRange)) {
                return true;
            }
        }
        return false;
    }

    protected void beforeTemplateStart() {
        this.myCaretRangeMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getCaretModel().getOffset(), this.myEditor.getCaretModel().getOffset());
        this.myCaretRangeMarker.setGreedyToLeft(true);
        this.myCaretRangeMarker.setGreedyToRight(true);
    }

    private void startTemplate(TemplateBuilderImpl builder2) {
        final Disposable disposable = Disposer.newDisposable();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer(disposable);
        MyTemplateListener templateListener = new MyTemplateListener(){

            @Override
            protected void restoreDaemonUpdateState() {
                Disposer.dispose((Disposable)disposable);
            }
        };
        int offset = this.myEditor.getCaretModel().getOffset();
        Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(this.myEditor);
        TextRange range2 = this.myScope.getTextRange();
        assert (range2 != null);
        RangeMarker rangeMarker = topLevelEditor.getDocument().createRangeMarker(range2);
        Template template = builder2.buildInlineTemplate();
        template.setToShortenLongNames(false);
        template.setToReformat(false);
        this.myHighlighters = new ArrayList();
        topLevelEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        TemplateManager.getInstance(this.myProject).startTemplate(topLevelEditor, template, templateListener);
        this.restoreOldCaretPositionAndSelection(offset);
        this.highlightTemplateVariables(template, topLevelEditor);
    }

    private void highlightTemplateVariables(Template template, Editor topLevelEditor) {
        if (this.myHighlighters != null) {
            HashMap<TextRange, TextAttributes> rangesToHighlight = new HashMap<TextRange, TextAttributes>();
            TemplateState templateState = TemplateManagerImpl.getTemplateState(topLevelEditor);
            if (templateState != null) {
                EditorColorsManager colorsManager = EditorColorsManager.getInstance();
                for (int i = 0; i < templateState.getSegmentsCount(); ++i) {
                    TextRange segmentOffset = templateState.getSegmentRange(i);
                    String name = template.getSegmentName(i);
                    TextAttributes attributes = null;
                    if (name.equals(PRIMARY_VARIABLE_NAME)) {
                        attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
                    } else if (name.equals(OTHER_VARIABLE_NAME)) {
                        attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                    }
                    if (attributes == null) continue;
                    rangesToHighlight.put(segmentOffset, attributes);
                }
            }
            this.addHighlights(rangesToHighlight, topLevelEditor, this.myHighlighters, HighlightManager.getInstance((Project)this.myProject));
        }
    }

    private void restoreOldCaretPositionAndSelection(int offset) {
        Runnable runnable2 = () -> {
            this.myEditor.getCaretModel().moveToOffset(this.restoreCaretOffset(offset));
            this.restoreSelection();
        };
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
        if (lookup != null && lookup.getLookupStart() <= this.restoreCaretOffset(offset)) {
            lookup.setFocusDegree(LookupImpl.FocusDegree.UNFOCUSED);
            lookup.performGuardedChange(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected void restoreSelection() {
    }

    protected int restoreCaretOffset(int offset) {
        return this.myCaretRangeMarker.isValid() ? this.myCaretRangeMarker.getEndOffset() : offset;
    }

    protected void navigateToAlreadyStarted(Document oldDocument, @Messages.YesNoResult int exitCode) {
        InplaceRefactoring.navigateToStarted(oldDocument, this.myProject, exitCode);
    }

    private static void navigateToStarted(Document oldDocument, Project project, @Messages.YesNoResult int exitCode) {
        VirtualFile virtualFile;
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(oldDocument);
        if (file2 != null && (virtualFile = file2.getVirtualFile()) != null) {
            FileEditor[] editors;
            for (FileEditor editor : editors = FileEditorManager.getInstance((Project)project).getEditors(virtualFile)) {
                Editor textEditor;
                TemplateState templateState;
                if (!(editor instanceof TextEditor) || (templateState = TemplateManagerImpl.getTemplateState(textEditor = ((TextEditor)editor).getEditor())) == null) continue;
                if (exitCode == 0) {
                    TextRange range2 = templateState.getVariableRange(PRIMARY_VARIABLE_NAME);
                    if (range2 == null) continue;
                    new OpenFileDescriptor(project, virtualFile, range2.getStartOffset()).navigate(true);
                    return;
                }
                if (exitCode <= 0) continue;
                templateState.gotoEnd();
                return;
            }
        }
    }

    @Nullable
    protected PsiElement getNameIdentifier() {
        return this.myElementToRename instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)this.myElementToRename).getNameIdentifier() : null;
    }

    public static EditorEx createPreviewComponent(Project project, FileType languageFileType) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        UndoUtil.disableUndoFor((Document)document);
        EditorEx previewEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, project, languageFileType, true);
        previewEditor.setOneLineMode(true);
        EditorSettings settings = previewEditor.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        previewEditor.setHorizontalScrollbarVisible(false);
        previewEditor.setVerticalScrollbarVisible(false);
        previewEditor.setCaretEnabled(false);
        settings.setLineCursorWidth(1);
        Color bg = previewEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
        previewEditor.setBackgroundColor(bg);
        previewEditor.setBorder(BorderFactory.createCompoundBorder((Border)new DottedBorder(Color.gray), new LineBorder(bg, 2)));
        return previewEditor;
    }

    @Nullable
    protected StartMarkAction startRename() throws StartMarkAction.AlreadyStartedException {
        StartMarkAction[] markAction = new StartMarkAction[1];
        StartMarkAction.AlreadyStartedException[] ex = new StartMarkAction.AlreadyStartedException[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                markAction[0] = StartMarkAction.start(this.myEditor, this.myProject, this.getCommandName());
            }
            catch (StartMarkAction.AlreadyStartedException e) {
                ex[0] = e;
            }
        }, this.getCommandName(), null);
        if (ex[0] != null) {
            throw ex[0];
        }
        return markAction[0];
    }

    @Nullable
    protected PsiNamedElement getVariable() {
        PsiFile psiFile;
        if (this.myElementToRename != null && this.myElementToRename.isValid()) {
            if (Comparing.strEqual((String)this.myOldName, (String)this.myElementToRename.getName())) {
                return this.myElementToRename;
            }
            if (this.myRenameOffset != null) {
                return (PsiNamedElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)this.myElementToRename.getContainingFile(), (int)this.myRenameOffset.getStartOffset(), (int)this.myRenameOffset.getEndOffset(), PsiNameIdentifierOwner.class);
            }
        }
        if (this.myRenameOffset != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return (PsiNamedElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)this.myRenameOffset.getStartOffset(), (int)this.myRenameOffset.getEndOffset(), PsiNameIdentifierOwner.class);
        }
        return this.myElementToRename;
    }

    protected void moveOffsetAfter(boolean success2) {
        if (this.myCaretRangeMarker != null) {
            this.myCaretRangeMarker.dispose();
        }
    }

    protected void addAdditionalVariables(TemplateBuilderImpl builder2) {
    }

    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
        PsiFile myEditorFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiReference reference = (myEditorFile != null ? myEditorFile : this.myElementToRename.getContainingFile()).findReferenceAt(this.myEditor.getCaretModel().getOffset());
        if (reference instanceof PsiMultiReference) {
            PsiReference[] references;
            for (PsiReference ref : references = ((PsiMultiReference)reference).getReferences()) {
                this.addReferenceIfNeeded(refs, ref);
            }
        } else {
            this.addReferenceIfNeeded(refs, reference);
        }
    }

    private void addReferenceIfNeeded(@NotNull Collection<PsiReference> refs, @Nullable PsiReference reference) {
        if (refs == null) {
            InplaceRefactoring.$$$reportNull$$$0(9);
        }
        if (reference != null && reference.isReferenceTo((PsiElement)this.myElementToRename) && !refs.contains(reference)) {
            refs.add(reference);
        }
    }

    protected void showDialogAdvertisement(String actionId) {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(actionId);
        if (shortcuts.length > 0) {
            this.setAdvertisementText("Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to show dialog with more options");
        }
    }

    public String getInitialName() {
        if (this.myInitialName == null) {
            PsiNamedElement variable = this.getVariable();
            if (variable != null) {
                return variable.getName();
            }
            LOG.error("Initial name should be provided");
            return "";
        }
        return this.myInitialName;
    }

    protected void revertState() {
        if (this.myOldName == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(this.myEditor);
            ApplicationManager.getApplication().runWriteAction(() -> {
                TemplateState state2 = TemplateManagerImpl.getTemplateState(topLevelEditor);
                assert (state2 != null);
                int segmentsCount = state2.getSegmentsCount();
                Document document = topLevelEditor.getDocument();
                for (int i = 0; i < segmentsCount; ++i) {
                    TextRange segmentRange = state2.getSegmentRange(i);
                    document.replaceString(segmentRange.getStartOffset(), segmentRange.getEndOffset(), (CharSequence)this.myOldName);
                }
            });
            if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(topLevelEditor.getDocument());
            }
        }, this.getCommandName(), null);
    }

    protected abstract String getCommandName();

    public void finish(boolean success2) {
        if (!ourRenamersStack.isEmpty() && ourRenamersStack.peek() == this) {
            ourRenamersStack.pop();
        }
        if (this.myHighlighters != null) {
            if (!this.myProject.isDisposed()) {
                HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
                for (RangeHighlighter highlighter : this.myHighlighters) {
                    highlightManager.removeSegmentHighlighter(this.myEditor, highlighter);
                }
            }
            this.myHighlighters = null;
            this.myEditor.putUserData(INPLACE_RENAMER, null);
        }
        if (this.myBalloon != null && !this.isRestart()) {
            this.myBalloon.hide();
        }
    }

    protected void addHighlights(@NotNull Map<TextRange, TextAttributes> ranges, @NotNull Editor editor, @NotNull Collection<RangeHighlighter> highlighters, @NotNull HighlightManager highlightManager) {
        if (ranges == null) {
            InplaceRefactoring.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            InplaceRefactoring.$$$reportNull$$$0(11);
        }
        if (highlighters == null) {
            InplaceRefactoring.$$$reportNull$$$0(12);
        }
        if (highlightManager == null) {
            InplaceRefactoring.$$$reportNull$$$0(13);
        }
        for (Map.Entry<TextRange, TextAttributes> entry : ranges.entrySet()) {
            TextRange range2 = entry.getKey();
            TextAttributes attributes = entry.getValue();
            highlightManager.addOccurrenceHighlight(editor, range2.getStartOffset(), range2.getEndOffset(), attributes, 0, highlighters, null);
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
    }

    protected abstract boolean performRefactoring();

    protected void performCleanup() {
    }

    private void addVariable(PsiReference reference, PsiElement selectedElement, TemplateBuilderImpl builder2, int offset) {
        PsiElement element = reference.getElement();
        if (element == selectedElement && this.checkRangeContainsOffset(offset, reference.getRangeInElement(), element)) {
            builder2.replaceElement(reference.getElement(), this.getRangeToRename(reference), PRIMARY_VARIABLE_NAME, this.createLookupExpression(selectedElement), true);
        } else {
            builder2.replaceElement(reference.getElement(), this.getRangeToRename(reference), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
    }

    private void addVariable(PsiElement element, PsiElement selectedElement, TemplateBuilderImpl builder2) {
        this.addVariable(element, null, selectedElement, builder2);
    }

    private void addVariable(PsiElement element, @Nullable TextRange textRange, PsiElement selectedElement, TemplateBuilderImpl builder2) {
        if (element == selectedElement) {
            builder2.replaceElement(element, this.getRangeToRename(element), PRIMARY_VARIABLE_NAME, this.createLookupExpression((PsiElement)this.myElementToRename), true);
        } else if (textRange != null) {
            builder2.replaceElement(element, textRange, OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        } else {
            builder2.replaceElement(element, this.getRangeToRename(element), OTHER_VARIABLE_NAME, PRIMARY_VARIABLE_NAME, false);
        }
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            InplaceRefactoring.$$$reportNull$$$0(14);
        }
        TextRange textRange = new TextRange(0, element.getTextLength());
        if (textRange == null) {
            InplaceRefactoring.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            InplaceRefactoring.$$$reportNull$$$0(16);
        }
        TextRange textRange = reference.getRangeInElement();
        if (textRange == null) {
            InplaceRefactoring.$$$reportNull$$$0(17);
        }
        return textRange;
    }

    public void setElementToRename(PsiNamedElement elementToRename) {
        this.myElementToRename = elementToRename;
    }

    protected boolean isIdentifier(String newName, Language language) {
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language);
        return namesValidator == null || namesValidator.isIdentifier(newName, this.myProject);
    }

    protected static VirtualFile getTopLevelVirtualFile(FileViewProvider fileViewProvider) {
        VirtualFile file2 = fileViewProvider.getVirtualFile();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        return file2;
    }

    public static void checkCleared() {
        try {
            assert (ourRenamersStack.isEmpty()) : ourRenamersStack;
        }
        finally {
            ourRenamersStack.clear();
        }
    }

    private PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, int offset) {
        TextRange range2;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            if (!this.checkRangeContainsOffset(offset, psiReference.getRangeInElement(), element)) continue;
            return element;
        }
        if (nameIdentifier != null && (range2 = nameIdentifier.getTextRange()) != null && this.checkRangeContainsOffset(offset, range2, nameIdentifier, 0)) {
            return nameIdentifier;
        }
        for (Pair pair : stringUsages) {
            if (!this.checkRangeContainsOffset(offset, (TextRange)pair.second, (PsiElement)pair.first)) continue;
            return (PsiElement)pair.first;
        }
        LOG.error(nameIdentifier + " by " + this.getClass().getName());
        return null;
    }

    private boolean checkRangeContainsOffset(int offset, TextRange textRange, PsiElement element) {
        return this.checkRangeContainsOffset(offset, textRange, element, element.getTextRange().getStartOffset());
    }

    private boolean checkRangeContainsOffset(int offset, TextRange textRange, PsiElement element, int shiftOffset) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        PsiLanguageInjectionHost injectionHost = injectedLanguageManager.getInjectionHost(element);
        if (injectionHost != null) {
            PsiLanguageInjectionHost initialInjectedHost;
            PsiElement nameIdentifier = this.getNameIdentifier();
            PsiLanguageInjectionHost psiLanguageInjectionHost = initialInjectedHost = nameIdentifier != null ? injectedLanguageManager.getInjectionHost(nameIdentifier) : null;
            if (initialInjectedHost != null && initialInjectedHost != injectionHost) {
                return false;
            }
            return injectedLanguageManager.injectedToHost(element, textRange).shiftRight(shiftOffset).containsOffset(offset);
        }
        return textRange.shiftRight(shiftOffset).containsOffset(offset);
    }

    protected boolean isRestart() {
        Boolean isRestart = (Boolean)this.myEditor.getUserData(INTRODUCE_RESTART);
        return isRestart != null && isRestart != false;
    }

    public static boolean canStartAnotherRefactoring(Editor editor, Project project, RefactoringActionHandler handler2, PsiElement ... element) {
        InplaceRefactoring inplaceRefactoring = InplaceRefactoring.getActiveInplaceRenamer(editor);
        return StartMarkAction.canStart(project) == null || inplaceRefactoring != null && inplaceRefactoring.startsOnTheSameElements(editor, handler2, element);
    }

    public static InplaceRefactoring getActiveInplaceRenamer(Editor editor) {
        return editor != null ? (InplaceRefactoring)editor.getUserData(INPLACE_RENAMER) : null;
    }

    protected boolean startsOnTheSameElements(Editor editor, RefactoringActionHandler handler2, PsiElement[] element) {
        return element.length == 1 && this.startsOnTheSameElement(handler2, element[0]);
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element) {
        return this.getVariable() == element;
    }

    protected void releaseResources() {
    }

    @Nullable
    protected JComponent getComponent() {
        return null;
    }

    protected void showBalloon() {
        JComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createDialogBalloonBuilder(component, null).setSmallVariant(true);
        this.myBalloon = balloonBuilder.createBalloon();
        Disposer.register((Disposable)this.myProject, (Disposable)this.myBalloon);
        Disposer.register((Disposable)this.myBalloon, (Disposable)new Disposable(){

            public void dispose() {
                InplaceRefactoring.this.releaseIfNotRestart();
                InplaceRefactoring.this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
            }
        });
        EditorUtil.disposeWithEditor(this.myEditor, (Disposable)this.myBalloon);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        final JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        this.myBalloon.show((PositionTracker)new PositionTracker<Balloon>((Component)this.myEditor.getContentComponent()){

            public RelativePoint recalculateLocation(Balloon object) {
                if (InplaceRefactoring.this.myTarget != null && !popupFactory.isBestPopupLocationVisible(InplaceRefactoring.this.myEditor)) {
                    return InplaceRefactoring.this.myTarget;
                }
                if (InplaceRefactoring.this.myCaretRangeMarker != null && InplaceRefactoring.this.myCaretRangeMarker.isValid()) {
                    InplaceRefactoring.this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, (Object)InplaceRefactoring.this.myEditor.offsetToVisualPosition(InplaceRefactoring.this.myCaretRangeMarker.getStartOffset()));
                }
                RelativePoint target2 = popupFactory.guessBestPopupLocation(InplaceRefactoring.this.myEditor);
                Point screenPoint = target2.getScreenPoint();
                int y = screenPoint.y;
                if (target2.getPoint().getY() > (double)InplaceRefactoring.this.myEditor.getLineHeight() + InplaceRefactoring.this.myBalloon.getPreferredSize().getHeight()) {
                    y -= InplaceRefactoring.this.myEditor.getLineHeight();
                }
                InplaceRefactoring.this.myTarget = new RelativePoint(new Point(screenPoint.x, y));
                return InplaceRefactoring.this.myTarget;
            }
        }, Balloon.Position.above);
    }

    protected void releaseIfNotRestart() {
        if (!this.isRestart()) {
            this.releaseResources();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/inplace/InplaceRefactoring";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notSameFile";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceIfNeeded";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHighlights";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MyTemplateListener
    extends TemplateEditingAdapter {
        private MyTemplateListener() {
        }

        protected abstract void restoreDaemonUpdateState();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeTemplateFinished(TemplateState templateState, Template template) {
            try {
                TextResult value = templateState.getVariableValue(InplaceRefactoring.PRIMARY_VARIABLE_NAME);
                InplaceRefactoring.this.myInsertedName = value != null ? value.toString().trim() : null;
                TextRange range2 = templateState.getCurrentVariableRange();
                int currentOffset = InplaceRefactoring.this.myEditor.getCaretModel().getOffset();
                if (range2 == null && InplaceRefactoring.this.myRenameOffset != null) {
                    range2 = new TextRange(InplaceRefactoring.this.myRenameOffset.getStartOffset(), InplaceRefactoring.this.myRenameOffset.getEndOffset());
                }
                RangeMarker rangeMarker = InplaceRefactoring.this.myBeforeRevert = range2 != null && range2.getEndOffset() >= currentOffset && range2.getStartOffset() <= currentOffset ? InplaceRefactoring.this.myEditor.getDocument().createRangeMarker(range2.getStartOffset(), currentOffset) : null;
                if (InplaceRefactoring.this.myBeforeRevert != null) {
                    InplaceRefactoring.this.myBeforeRevert.setGreedyToRight(true);
                }
                InplaceRefactoring.this.finish(true);
            }
            finally {
                this.restoreDaemonUpdateState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void templateFinished(Template template, boolean brokenOff) {
            boolean bind = false;
            try {
                if (!brokenOff) {
                    bind = InplaceRefactoring.this.performRefactoring();
                } else {
                    InplaceRefactoring.this.performCleanup();
                }
                InplaceRefactoring.this.moveOffsetAfter(!brokenOff);
            }
            finally {
                if (!bind) {
                    try {
                        ((EditorImpl)InjectedLanguageUtil.getTopLevelEditor(InplaceRefactoring.this.myEditor)).stopDumbLater();
                    }
                    finally {
                        FinishMarkAction.finish(InplaceRefactoring.this.myProject, InplaceRefactoring.this.myEditor, InplaceRefactoring.this.myMarkAction);
                        if (InplaceRefactoring.this.myBeforeRevert != null) {
                            InplaceRefactoring.this.myBeforeRevert.dispose();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void templateCancelled(Template template) {
            try {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)InplaceRefactoring.this.myProject);
                documentManager.commitAllDocuments();
                InplaceRefactoring.this.finish(false);
                InplaceRefactoring.this.moveOffsetAfter(false);
            }
            finally {
                try {
                    this.restoreDaemonUpdateState();
                }
                finally {
                    FinishMarkAction.finish(InplaceRefactoring.this.myProject, InplaceRefactoring.this.myEditor, InplaceRefactoring.this.myMarkAction);
                }
            }
        }
    }
}

