/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceType;
import com.intellij.util.ArrayUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeploymentSourceImpl
implements ModuleDeploymentSource {
    private final ModulePointer myPointer;

    public ModuleDeploymentSourceImpl(@NotNull ModulePointer pointer) {
        if (pointer == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(0);
        }
        this.myPointer = pointer;
    }

    @NotNull
    public ModulePointer getModulePointer() {
        ModulePointer modulePointer = this.myPointer;
        if (modulePointer == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(1);
        }
        return modulePointer;
    }

    @Nullable
    public Module getModule() {
        return this.myPointer.getModule();
    }

    @Nullable
    public VirtualFile getContentRoot() {
        Module module2 = this.myPointer.getModule();
        if (module2 == null) {
            return null;
        }
        return ModuleDeploymentSourceImpl.getContentRoot(module2);
    }

    public static VirtualFile getContentRoot(Module module2) {
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots());
    }

    @Nullable
    public File getFile() {
        VirtualFile contentRoot = this.getContentRoot();
        if (contentRoot == null) {
            return null;
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
    }

    @Nullable
    public String getFilePath() {
        File file2 = this.getFile();
        if (file2 == null) {
            return null;
        }
        return file2.getAbsolutePath();
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPointer.getModuleName();
        if (string == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Module;
    }

    public boolean isValid() {
        return this.getModule() != null;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDeploymentSource)) {
            return false;
        }
        return this.myPointer.equals(((ModuleDeploymentSource)o).getModulePointer());
    }

    public int hashCode() {
        return this.myPointer.hashCode();
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        DeploymentSourceType deploymentSourceType = (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(ModuleDeploymentSourceType.class);
        if (deploymentSourceType == null) {
            ModuleDeploymentSourceImpl.$$$reportNull$$$0(3);
        }
        return deploymentSourceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/ModuleDeploymentSourceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/ModuleDeploymentSourceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

