/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NST {
    private static final Logger LOG;
    private static final String ourRegistryKeyTouchbar = "ide.mac.touchbar.use";
    private static NSTLibrary ourNSTLibrary;
    private static String MIN_OS_VERSION;

    static boolean isSupportedOS() {
        return SystemInfo.isMac && SystemInfo.isOsVersionAtLeast((String)MIN_OS_VERSION);
    }

    static NSTLibrary loadLibrary() {
        UrlClassLoader.loadPlatformLibrary((String)"nst");
        System.setProperty("jna.encoding", "UTF8");
        HashMap nstOptions = new HashMap();
        ourNSTLibrary = (NSTLibrary)Native.loadLibrary((String)"nst", NSTLibrary.class, nstOptions);
        return ourNSTLibrary;
    }

    public static boolean isAvailable() {
        return ourNSTLibrary != null;
    }

    public static ID createTouchBar(String name, NSTLibrary.ItemCreator creator, String escID) {
        return ourNSTLibrary.createTouchBar(name, creator, escID);
    }

    public static void releaseTouchBar(ID tbObj) {
        ourNSTLibrary.releaseTouchBar(tbObj);
    }

    public static void setTouchBar(TouchBar tb) {
        ourNSTLibrary.setTouchBar(tb == null ? ID.NIL : tb.getNativePeer());
    }

    public static void selectItemsToShow(ID tbObj, String[] ids, int count) {
        ourNSTLibrary.selectItemsToShow(tbObj, ids, count);
    }

    public static void setPrincipal(ID tbObj, String uid) {
        ourNSTLibrary.setPrincipal(tbObj, uid);
    }

    public static ID createButton(String uid, int buttWidth, int buttFlags, String text2, Icon icon, NSTLibrary.Action action) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        byte[] raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        return ourNSTLibrary.createButton(uid, buttWidth, buttFlags, text2, raster4ByteRGBA, w, h, action);
    }

    public static ID createPopover(String uid, int itemWidth, String text2, Icon icon, ID tbObjExpand, ID tbObjTapAndHold) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        byte[] raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        return ourNSTLibrary.createPopover(uid, itemWidth, text2, raster4ByteRGBA, w, h, tbObjExpand, tbObjTapAndHold);
    }

    public static ID createScrubber(String uid, int itemWidth, List<TBItemScrubber.ItemData> items) {
        NSTLibrary.ScrubberItemData[] vals;
        return ourNSTLibrary.createScrubber(uid, itemWidth, vals, (vals = NST._makeItemsArray2(items)) != null ? vals.length : 0);
    }

    public static ID createGroupItem(String uid, ID[] items, int count) {
        return ourNSTLibrary.createGroupItem(uid, items, count);
    }

    public static void updateButton(ID buttonObj, int updateOptions, int buttWidth, int buttonFlags, String text2, Icon icon, NSTLibrary.Action action) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        byte[] raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.updateButton(buttonObj, updateOptions, buttWidth, buttonFlags, text2, raster4ByteRGBA, w, h, action);
    }

    public static void setArrowImage(ID buttObj, @Nullable Icon arrow) {
        BufferedImage img = NST._getImg4ByteRGBA(arrow);
        byte[] raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.setArrowImage(buttObj, raster4ByteRGBA, w, h);
    }

    public static void updatePopover(ID popoverObj, int itemWidth, String text2, Icon icon, ID tbObjExpand, ID tbObjTapAndHold) {
        BufferedImage img = NST._getImg4ByteRGBA(icon);
        byte[] raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.updatePopover(popoverObj, itemWidth, text2, raster4ByteRGBA, w, h, tbObjExpand, tbObjTapAndHold);
    }

    public static void updateScrubber(ID scrubObj, int itemWidth, List<TBItemScrubber.ItemData> items) {
        NSTLibrary.ScrubberItemData[] vals;
        ourNSTLibrary.updateScrubber(scrubObj, itemWidth, vals, (vals = NST._makeItemsArray2(items)) != null ? vals.length : 0);
    }

    private static NSTLibrary.ScrubberItemData[] _makeItemsArray2(List<TBItemScrubber.ItemData> items) {
        if (items == null) {
            return null;
        }
        NSTLibrary.ScrubberItemData scitem = new NSTLibrary.ScrubberItemData();
        NSTLibrary.ScrubberItemData[] result2 = (NSTLibrary.ScrubberItemData[])scitem.toArray(items.size());
        int c = 0;
        for (TBItemScrubber.ItemData id : items) {
            NSTLibrary.ScrubberItemData out = result2[c++];
            NST._fill(id, out);
        }
        return result2;
    }

    private static void _fill(TBItemScrubber.ItemData from, @NotNull NSTLibrary.ScrubberItemData out) {
        if (out == null) {
            NST.$$$reportNull$$$0(0);
        }
        if (from.myText != null) {
            byte[] data = Native.toByteArray((String)from.myText, (String)"UTF8");
            out.text = new Memory((long)(data.length + 1));
            out.text.write(0L, data, 0, data.length);
            out.text.setByte((long)data.length, (byte)0);
        } else {
            out.text = null;
        }
        if (from.myIcon != null) {
            BufferedImage img = NST._getImg4ByteRGBA(from.myIcon);
            byte[] raster = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            out.raster4ByteRGBA = new Memory((long)raster.length);
            out.raster4ByteRGBA.write(0L, raster, 0, raster.length);
            out.rasterW = img.getWidth();
            out.rasterH = img.getHeight();
        } else {
            out.raster4ByteRGBA = null;
            out.rasterW = 0;
            out.rasterH = 0;
        }
        out.action = from.myAction;
    }

    private static byte[] _getRaster(BufferedImage img) {
        if (img == null) {
            return null;
        }
        return ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
    }

    private static int _getImgW(BufferedImage img) {
        return img == null ? 0 : img.getWidth();
    }

    private static int _getImgH(BufferedImage img) {
        return img == null ? 0 : img.getHeight();
    }

    private static BufferedImage _getImg4ByteRGBA(Icon icon, float scale) {
        if (icon == null) {
            return null;
        }
        int w = Math.round((float)icon.getIconWidth() * scale);
        int h = Math.round((float)icon.getIconHeight() * scale);
        WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(w * h * 4), w, h, 4 * w, 4, new int[]{0, 1, 2, 3}, (Point)null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorModel.getRGBdefault().getColorSpace(), true, false, 3, 0);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g = image.createGraphics();
        g.scale(scale, scale);
        g.setComposite(AlphaComposite.SrcOver);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    private static BufferedImage _getImg4ByteRGBA(Icon icon) {
        if (icon == null || icon.getIconHeight() == 0) {
            return null;
        }
        Application app = ApplicationManager.getApplication();
        float fMulX = app != null && UISettings.getInstance().getPresentationMode() ? 40.0f / (float)icon.getIconHeight() : (icon.getIconHeight() < 24 ? 2.5f : 44.0f / (float)icon.getIconHeight());
        return NST._getImg4ByteRGBA(icon, fMulX);
    }

    static {
        block13: {
            LOG = Logger.getInstance(NST.class);
            ourNSTLibrary = null;
            MIN_OS_VERSION = "10.12.2";
            boolean isRegistryKeyEnabled = Registry.is((String)ourRegistryKeyTouchbar, (boolean)false);
            if (NST.isSupportedOS() && isRegistryKeyEnabled && Utils.isTouchBarServerRunning()) {
                try {
                    NST.loadLibrary();
                }
                catch (Throwable e) {
                    LOG.error("Failed to load nst library for touchbar: ", e);
                }
                if (ourNSTLibrary != null) {
                    try {
                        ID test = ourNSTLibrary.createTouchBar("test", uid -> ID.NIL, null);
                        if (test == null || test == ID.NIL) {
                            LOG.error("Failed to create native touchbar object, result is null");
                            ourNSTLibrary = null;
                            break block13;
                        }
                        ourNSTLibrary.releaseTouchBar(test);
                        LOG.info("nst library works properly, successfully created and released native touchbar object");
                    }
                    catch (Throwable e) {
                        LOG.error("nst library was loaded, but can't be used: ", e);
                        ourNSTLibrary = null;
                    }
                } else {
                    LOG.error("nst library wasn't loaded");
                }
            } else if (!NST.isSupportedOS()) {
                LOG.info("OS doesn't support touchbar, skip nst loading");
            } else if (!isRegistryKeyEnabled) {
                LOG.info("registry key 'ide.mac.touchbar.use' is disabled, skip nst loading");
            } else {
                LOG.info("touchbar-server isn't running, skip nst loading");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/ui/mac/touchbar/NST", "_fill"));
    }
}

