/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DomCollectionProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptorImpl;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationHolderImpl
extends SmartList<DomElementProblemDescriptor>
implements DomElementAnnotationHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl");
    private final SmartList<Annotation> myAnnotations = new SmartList();
    private final boolean myOnTheFly;

    public DomElementAnnotationHolderImpl(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, @Nullable String message, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(0);
        }
        DomElementProblemDescriptor domElementProblemDescriptor = this.createProblem(domElement, HighlightSeverity.ERROR, message, fixes);
        if (domElementProblemDescriptor == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(1);
        }
        return domElementProblemDescriptor;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, DomCollectionChildDescription childDescription, @Nullable String message) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(2);
        }
        DomCollectionProblemDescriptorImpl domCollectionProblemDescriptorImpl = this.addProblem(new DomCollectionProblemDescriptorImpl(domElement, message, HighlightSeverity.ERROR, childDescription));
        if (domCollectionProblemDescriptorImpl == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(3);
        }
        return domCollectionProblemDescriptorImpl;
    }

    @NotNull
    public final DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(4);
        }
        DomElementProblemDescriptor domElementProblemDescriptor = this.createProblem(domElement, highlightType, message, LocalQuickFix.EMPTY_ARRAY);
        if (domElementProblemDescriptor == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(5);
        }
        return domElementProblemDescriptor;
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(6);
        }
        return this.createProblem(domElement, highlightType, message, (TextRange)null, fixes);
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message, TextRange textRange, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(7);
        }
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message, highlightType, textRange, null, fixes));
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, ProblemHighlightType highlightType, String message, @Nullable TextRange textRange, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(8);
        }
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message, HighlightSeverity.ERROR, textRange, highlightType, fixes));
    }

    @NotNull
    public DomElementResolveProblemDescriptor createResolveProblem(@NotNull GenericDomValue element, @NotNull PsiReference reference) {
        if (element == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(10);
        }
        DomElementResolveProblemDescriptor domElementResolveProblemDescriptor = this.addProblem(new DomElementResolveProblemDescriptorImpl(element, reference, this.getQuickFixes(element, reference)));
        if (domElementResolveProblemDescriptor == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(11);
        }
        return domElementResolveProblemDescriptor;
    }

    @NotNull
    public Annotation createAnnotation(@NotNull DomElement element, HighlightSeverity severity, @Nullable String message) {
        XmlElement xmlElement;
        if (element == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(12);
        }
        LOG.assertTrue((xmlElement = element.getXmlElement()) != null, (Object)("No XML element for " + element));
        TextRange range2 = xmlElement.getTextRange();
        int startOffset = range2.getStartOffset();
        int endOffset = message == null ? startOffset : range2.getEndOffset();
        Annotation annotation = new Annotation(startOffset, endOffset, severity, message, null);
        this.myAnnotations.add((Object)annotation);
        Annotation annotation2 = annotation;
        if (annotation2 == null) {
            DomElementAnnotationHolderImpl.$$$reportNull$$$0(13);
        }
        return annotation2;
    }

    public final SmartList<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public int getSize() {
        return this.size();
    }

    private LocalQuickFix[] getQuickFixes(GenericDomValue element, PsiReference reference) {
        Object[] localQuickFixes;
        if (!this.myOnTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        Converter converter2 = WrappingConverter.getDeepestConverter((Converter)element.getConverter(), (GenericDomValue)element);
        if (converter2 instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter2;
            ContainerUtil.addAll((Collection)result2, (Object[])resolvingConverter.getQuickFixes(ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element))));
        }
        if (reference instanceof LocalQuickFixProvider && (localQuickFixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
            ContainerUtil.addAll((Collection)result2, (Object[])localQuickFixes);
        }
        return result2.isEmpty() ? LocalQuickFix.EMPTY_ARRAY : result2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public <T extends DomElementProblemDescriptor> T addProblem(T problemDescriptor) {
        this.add(problemDescriptor);
        return problemDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementAnnotationHolderImpl";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveProblem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createResolveProblem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

