/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTextFilterImpl
implements VcsLogDetailsFilter,
VcsLogTextFilter {
    @NotNull
    private final String myText;
    private final boolean myMatchCase;
    @Nullable
    private final Pattern myPattern;

    public VcsLogTextFilterImpl(@NotNull String text2, boolean isRegexAllowed, boolean matchCase) {
        if (text2 == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(0);
        }
        this.myText = text2;
        this.myMatchCase = matchCase;
        this.myPattern = VcsLogTextFilterImpl.createPattern(this.myText, isRegexAllowed, this.myMatchCase);
    }

    @Nullable
    private static Pattern createPattern(@NotNull String text2, boolean isRegexAllowed, boolean matchCase) {
        if (text2 == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(1);
        }
        if (isRegexAllowed && VcsLogUtil.maybeRegexp(text2)) {
            try {
                return matchCase ? Pattern.compile(text2) : Pattern.compile(text2, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public VcsLogTextFilterImpl(@NotNull String text2) {
        if (text2 == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(2);
        }
        this(text2, false, false);
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(3);
        }
        return VcsLogTextFilterImpl.matches(this, details.getFullMessage());
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isRegex() {
        return this.myPattern != null;
    }

    public boolean matchesCase() {
        return this.myMatchCase;
    }

    public String toString() {
        return (this.isRegex() ? "matching " : "containing ") + this.myText + " (case " + (this.myMatchCase ? "sensitive" : "insensitive") + ")";
    }

    public static boolean matches(@NotNull VcsLogTextFilter filter, @NotNull String message) {
        Pattern pattern;
        if (filter == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(5);
        }
        if (message == null) {
            VcsLogTextFilterImpl.$$$reportNull$$$0(6);
        }
        if ((pattern = filter instanceof VcsLogTextFilterImpl ? ((VcsLogTextFilterImpl)filter).myPattern : VcsLogTextFilterImpl.createPattern(filter.getText(), filter.isRegex(), filter.matchesCase())) != null) {
            return pattern.matcher(message).find();
        }
        if (filter.matchesCase()) {
            return message.contains(filter.getText());
        }
        return StringUtil.containsIgnoreCase((String)message, (String)filter.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsLogTextFilterImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

