/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsLogProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PersistentUtil {
    @NotNull
    public static final File LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    @NotNull
    private static final String CORRUPTION_MARKER = "corruption.marker";

    @NotNull
    public static String calcLogId(@NotNull Project project, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (project == null) {
            PersistentUtil.$$$reportNull$$$0(0);
        }
        if (logProviders == null) {
            PersistentUtil.$$$reportNull$$$0(1);
        }
        int hashcode = PersistentUtil.calcLogProvidersHash(logProviders);
        String string = project.getLocationHash() + "." + Integer.toHexString(hashcode);
        if (string == null) {
            PersistentUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static int calcLogProvidersHash(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            PersistentUtil.$$$reportNull$$$0(3);
        }
        List sortedRoots = ContainerUtil.sorted(logProviders.keySet(), Comparator.comparing(VirtualFile::getPath));
        return StringUtil.join((Collection)sortedRoots, root -> {
            if (logProviders == null) {
                PersistentUtil.$$$reportNull$$$0(29);
            }
            return root.getPath() + "." + ((VcsLogProvider)logProviders.get(root)).getSupportedVcs().getName();
        }, (String)".").hashCode();
    }

    @NotNull
    public static File getStorageFile(@NotNull String storageKind, @NotNull String logId, int version) {
        String safeLogId;
        File subdir;
        File mapFile;
        if (storageKind == null) {
            PersistentUtil.$$$reportNull$$$0(4);
        }
        if (logId == null) {
            PersistentUtil.$$$reportNull$$$0(5);
        }
        if (!(mapFile = new File(subdir = new File(LOG_CACHE, storageKind), (safeLogId = PathUtilRt.suggestFileName((String)logId, (boolean)true, (boolean)true)) + "." + version)).exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId));
        }
        File file2 = mapFile;
        if (file2 == null) {
            PersistentUtil.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public static <T> PersistentEnumeratorBase<T> createPersistentEnumerator(@NotNull KeyDescriptor<T> keyDescriptor, @NotNull String storageKind, @NotNull String logId, int version) throws IOException {
        if (keyDescriptor == null) {
            PersistentUtil.$$$reportNull$$$0(7);
        }
        if (storageKind == null) {
            PersistentUtil.$$$reportNull$$$0(8);
        }
        if (logId == null) {
            PersistentUtil.$$$reportNull$$$0(9);
        }
        File storageFile = PersistentUtil.getStorageFile(storageKind, logId, version);
        PersistentEnumeratorBase persistentEnumeratorBase = (PersistentEnumeratorBase)IOUtil.openCleanOrResetBroken(() -> {
            if (keyDescriptor == null) {
                PersistentUtil.$$$reportNull$$$0(28);
            }
            return new PersistentBTreeEnumerator(storageFile, keyDescriptor, Page.PAGE_SIZE, null, version);
        }, (File)storageFile);
        if (persistentEnumeratorBase == null) {
            PersistentUtil.$$$reportNull$$$0(10);
        }
        return persistentEnumeratorBase;
    }

    public static boolean deleteWithRenamingAllFilesStartingWith(@NotNull File baseFile) {
        File parentFile;
        if (baseFile == null) {
            PersistentUtil.$$$reportNull$$$0(11);
        }
        if ((parentFile = baseFile.getParentFile()) == null) {
            return false;
        }
        File[] files2 = parentFile.listFiles(pathname -> {
            if (baseFile == null) {
                PersistentUtil.$$$reportNull$$$0(27);
            }
            return pathname.getName().startsWith(baseFile.getName());
        });
        if (files2 == null) {
            return true;
        }
        boolean deleted = true;
        for (File f : files2) {
            deleted &= FileUtil.deleteWithRenaming((File)f);
        }
        return deleted;
    }

    public static boolean cleanupStorageFiles(@NotNull String subdirName, @NotNull String id) {
        if (subdirName == null) {
            PersistentUtil.$$$reportNull$$$0(12);
        }
        if (id == null) {
            PersistentUtil.$$$reportNull$$$0(13);
        }
        File subdir = new File(LOG_CACHE, subdirName);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        return PersistentUtil.deleteWithRenamingAllFilesStartingWith(new File(subdir, safeLogId + "."));
    }

    @NotNull
    public static File getStorageFile(@NotNull String subdirName, @NotNull String kind, @NotNull String id, int version, boolean forMapIndexStorage) {
        File storageFile;
        if (subdirName == null) {
            PersistentUtil.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            PersistentUtil.$$$reportNull$$$0(15);
        }
        if (id == null) {
            PersistentUtil.$$$reportNull$$$0(16);
        }
        File subdir = new File(LOG_CACHE, subdirName);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        File baseFile = PersistentUtil.getFileName(kind, subdir, safeLogId, version);
        File file2 = storageFile = forMapIndexStorage ? MapIndexStorage.getIndexStorageFile((File)baseFile) : baseFile;
        if (!storageFile.exists()) {
            for (int oldVersion = 0; oldVersion < version; ++oldVersion) {
                File baseOldStorageFile = PersistentUtil.getFileName(kind, subdir, safeLogId, oldVersion);
                File oldStorageFile = forMapIndexStorage ? MapIndexStorage.getIndexStorageFile((File)baseOldStorageFile) : baseOldStorageFile;
                IOUtil.deleteAllFilesStartingWith((File)oldStorageFile);
            }
        }
        File file3 = baseFile;
        if (file3 == null) {
            PersistentUtil.$$$reportNull$$$0(17);
        }
        return file3;
    }

    @NotNull
    public static File getStorageFile(@NotNull String subdirName, @NotNull String kind, @NotNull String id, int version) {
        if (subdirName == null) {
            PersistentUtil.$$$reportNull$$$0(18);
        }
        if (kind == null) {
            PersistentUtil.$$$reportNull$$$0(19);
        }
        if (id == null) {
            PersistentUtil.$$$reportNull$$$0(20);
        }
        File file2 = PersistentUtil.getStorageFile(subdirName, kind, id, version, false);
        if (file2 == null) {
            PersistentUtil.$$$reportNull$$$0(21);
        }
        return file2;
    }

    @NotNull
    private static File getFileName(@NotNull String kind, @NotNull File subdir, @NotNull String safeLogId, int version) {
        if (kind == null) {
            PersistentUtil.$$$reportNull$$$0(22);
        }
        if (subdir == null) {
            PersistentUtil.$$$reportNull$$$0(23);
        }
        if (safeLogId == null) {
            PersistentUtil.$$$reportNull$$$0(24);
        }
        File file2 = new File(subdir, safeLogId + "." + kind + "." + version);
        if (file2 == null) {
            PersistentUtil.$$$reportNull$$$0(25);
        }
        return file2;
    }

    @NotNull
    public static File getCorruptionMarkerFile() {
        File file2 = new File(LOG_CACHE, CORRUPTION_MARKER);
        if (file2 == null) {
            PersistentUtil.$$$reportNull$$$0(26);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/PersistentUtil";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageKind";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeLogId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/PersistentUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLogId";
                break;
            }
            case 6: 
            case 17: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPersistentEnumerator";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorruptionMarkerFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcLogId";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcLogProvidersHash";
                break;
            }
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPersistentEnumerator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deleteWithRenamingAllFilesStartingWith";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanupStorageFiles";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deleteWithRenamingAllFilesStartingWith$2";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPersistentEnumerator$1";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calcLogProvidersHash$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

