/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.memory.component.MemoryViewManager;
import com.intellij.xdebugger.memory.component.MemoryViewManagerState;
import com.intellij.xdebugger.memory.event.MemoryViewManagerListener;
import com.intellij.xdebugger.memory.tracking.TrackerForNewInstancesBase;
import com.intellij.xdebugger.memory.ui.ClassesTable;
import com.intellij.xdebugger.memory.ui.InstancesWindowBase;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.KeyboardUtils;
import com.intellij.xdebugger.memory.utils.SingleAlarmWithMutableDelay;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassesFilteredViewBase
extends BorderLayoutPanel
implements Disposable {
    protected static final double DELAY_BEFORE_INSTANCES_QUERY_COEFFICIENT = 0.5;
    protected static final double MAX_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    protected static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final String EMPTY_TABLE_CONTENT_WHEN_RUNNING = "The application is running";
    private static final String EMPTY_TABLE_CONTENT_WHEN_STOPPED = "Classes are not available";
    protected final Project myProject;
    protected final SingleAlarmWithMutableDelay mySingleAlarm;
    private final SearchTextField myFilterTextField;
    private final ClassesTable myTable;
    private final MyDebuggerSessionListener myDebugSessionListener;
    private final AtomicInteger myTime;
    private final AtomicInteger myLastUpdatingTime;
    protected volatile boolean myIsActive;

    public ClassesFilteredViewBase(final @NotNull XDebugSession debugSession) {
        if (debugSession == null) {
            ClassesFilteredViewBase.$$$reportNull$$$0(0);
        }
        this.myFilterTextField = new FilterTextField();
        this.myTime = new AtomicInteger(0);
        this.myLastUpdatingTime = new AtomicInteger(this.myTime.intValue());
        this.myProject = debugSession.getProject();
        debugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                debugSession.removeSessionListener((XDebugSessionListener)this);
            }
        });
        MemoryViewManagerState memoryViewManagerState = MemoryViewManager.getInstance().getState();
        this.myTable = this.createClassesTable(memoryViewManagerState);
        this.myTable.getEmptyText().setText(EMPTY_TABLE_CONTENT_WHEN_RUNNING);
        Disposer.register((Disposable)this, (Disposable)this.myTable);
        this.myTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredViewBase.this.handleClassSelection(ClassesFilteredViewBase.this.myTable.getSelectedClass());
                } else if (KeyboardUtils.isCharacter(keyCode) || KeyboardUtils.isBackSpace(keyCode)) {
                    String text2 = ClassesFilteredViewBase.this.myFilterTextField.getText();
                    String newText = KeyboardUtils.isBackSpace(keyCode) ? text2.substring(0, text2.length() - 1) : text2 + e.getKeyChar();
                    ClassesFilteredViewBase.this.myFilterTextField.setText(newText);
                    IdeFocusManager.getInstance((Project)ClassesFilteredViewBase.this.myProject).requestFocus((Component)ClassesFilteredViewBase.this.myFilterTextField, false);
                }
            }
        });
        this.myFilterTextField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.dispatch(e);
            }

            private void dispatch(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (ClassesFilteredViewBase.this.myTable.isInClickableMode() && (KeyboardUtils.isCharacter(keyCode) || KeyboardUtils.isEnterKey(keyCode))) {
                    ClassesFilteredViewBase.this.myTable.exitClickableMode();
                    ClassesFilteredViewBase.this.updateClassesAndCounts(true);
                } else if (KeyboardUtils.isUpDownKey(keyCode) || KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredViewBase.this.myTable.dispatchEvent(e);
                }
            }
        });
        this.myFilterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ClassesFilteredViewBase.this.myTable.setFilterPattern(ClassesFilteredViewBase.this.myFilterTextField.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = state2 -> {
            this.myTable.setFilteringByDiffNonZero(state2.isShowWithDiffOnly);
            this.myTable.setFilteringByInstanceExists(state2.isShowWithInstancesOnly);
            this.myTable.setFilteringByTrackingState(state2.isShowTrackedOnly);
            if (state2.isAutoUpdateModeOn && this.myTable.isInClickableMode()) {
                this.updateClassesAndCounts(true);
            }
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.myDebugSessionListener = new MyDebuggerSessionListener();
        debugSession.addSessionListener((XDebugSessionListener)this.myDebugSessionListener, (Disposable)this);
        this.mySingleAlarm = new SingleAlarmWithMutableDelay(suspendContext -> {
            ApplicationManager.getApplication().invokeLater(() -> this.myTable.setBusy(true));
            this.scheduleUpdateClassesCommand(suspendContext);
        }, this);
        this.mySingleAlarm.setDelay((int)TimeUnit.MILLISECONDS.toMillis(500L));
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu menu = ClassesFilteredViewBase.createContextMenu();
                menu.getComponent().show(comp, x, y);
            }
        });
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)2);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        group.setPopup(true);
        Presentation actionsPresentation = new Presentation("Memory View Settings");
        actionsPresentation.setIcon(AllIcons.General.GearPlain);
        ActionButton button = new ActionButton((AnAction)group, actionsPresentation, "unknown", (Dimension)new JBDimension(25, 25));
        BorderLayoutPanel topPanel = new BorderLayoutPanel();
        topPanel.addToCenter((Component)this.myFilterTextField);
        topPanel.addToRight((Component)button);
        this.addToTop((Component)topPanel);
        this.addToCenter(scroll);
    }

    @NotNull
    protected ClassesTable createClassesTable(MemoryViewManagerState memoryViewManagerState) {
        ClassesTable classesTable = new ClassesTable(this.myProject, this, memoryViewManagerState.isShowWithDiffOnly, memoryViewManagerState.isShowWithInstancesOnly, memoryViewManagerState.isShowTrackedOnly);
        if (classesTable == null) {
            ClassesFilteredViewBase.$$$reportNull$$$0(1);
        }
        return classesTable;
    }

    protected abstract void scheduleUpdateClassesCommand(XSuspendContext var1);

    @Nullable
    protected TrackerForNewInstancesBase getStrategy(@NotNull TypeInfo ref) {
        if (ref == null) {
            ClassesFilteredViewBase.$$$reportNull$$$0(2);
        }
        return null;
    }

    protected void handleClassSelection(@Nullable TypeInfo ref) {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (ref != null && debugSession != null && debugSession.isSuspended()) {
            if (!ref.canGetInstanceInfo()) {
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("Unable to get instances of class " + ref.name(), NotificationType.INFORMATION).notify(debugSession.getProject());
                return;
            }
            this.getInstancesWindow(ref, debugSession).show();
        }
    }

    protected abstract InstancesWindowBase getInstancesWindow(@NotNull TypeInfo var1, XDebugSession var2);

    protected void updateClassesAndCounts(boolean immediate) {
        ApplicationManager.getApplication().invokeLater(() -> {
            XSuspendContext suspendContext;
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
            if (debugSession != null && (suspendContext = debugSession.getSuspendContext()) != null) {
                if (immediate) {
                    this.mySingleAlarm.cancelAndRequestImmediate(suspendContext);
                } else {
                    this.mySingleAlarm.cancelAndRequest(suspendContext);
                }
            }
        }, this.myProject.getDisposed());
    }

    private static ActionPopupMenu createContextMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", group);
    }

    protected void doActivate() {
        this.myDebugSessionListener.setActive(true);
        if (this.isNeedUpdateView()) {
            if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                this.updateClassesAndCounts(true);
            } else {
                this.makeTableClickable();
            }
        }
    }

    private void makeTableClickable() {
        ApplicationManager.getApplication().invokeLater(() -> this.myTable.makeClickable(() -> this.updateClassesAndCounts(true)));
    }

    protected void doPause() {
        this.myDebugSessionListener.setActive(false);
        this.mySingleAlarm.cancelAllRequests();
    }

    private boolean isNeedUpdateView() {
        return this.myLastUpdatingTime.get() != this.myTime.get();
    }

    protected void viewUpdated() {
        this.myLastUpdatingTime.set(this.myTime.get());
    }

    public ClassesTable getTable() {
        return this.myTable;
    }

    public Object getData(String dataId) {
        return null;
    }

    @Nullable
    protected XDebugSessionListener getAdditionalSessionListener() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/memory/ui/ClassesFilteredViewBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/memory/ui/ClassesFilteredViewBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassesTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStrategy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean myIsActive = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean value) {
            this.myIsActive = value;
        }

        public void sessionResumed() {
            if (this.myIsActive) {
                XDebugSessionListener additionalSessionListener = ClassesFilteredViewBase.this.getAdditionalSessionListener();
                if (additionalSessionListener != null) {
                    additionalSessionListener.sessionResumed();
                }
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredViewBase.this.myTable.hideContent(ClassesFilteredViewBase.EMPTY_TABLE_CONTENT_WHEN_RUNNING));
                ClassesFilteredViewBase.this.mySingleAlarm.cancelAllRequests();
            }
        }

        public void sessionStopped() {
            XDebugSessionListener additionalSessionListener = ClassesFilteredViewBase.this.getAdditionalSessionListener();
            if (additionalSessionListener != null) {
                additionalSessionListener.sessionStopped();
            }
            ClassesFilteredViewBase.this.mySingleAlarm.cancelAllRequests();
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredViewBase.this.myTable.clean(ClassesFilteredViewBase.EMPTY_TABLE_CONTENT_WHEN_STOPPED));
        }

        public void sessionPaused() {
            ClassesFilteredViewBase.this.myTime.incrementAndGet();
            XDebugSessionListener additionalSessionListener = ClassesFilteredViewBase.this.getAdditionalSessionListener();
            if (additionalSessionListener != null) {
                additionalSessionListener.sessionPaused();
            }
            if (this.myIsActive) {
                if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                    ClassesFilteredViewBase.this.updateClassesAndCounts(false);
                } else {
                    ClassesFilteredViewBase.this.makeTableClickable();
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }
    }
}

