/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserColorLookup
extends LookupElementDecorator<LookupElement> {
    private static final String COLOR_STRING = XmlBundle.message((String)"choose.color.in.color.lookup", (Object[])new Object[0]);
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = color -> '#' + ColorUtil.toHex((Color)color);

    public UserColorLookup() {
        this(COLOR_TO_STRING_CONVERTER);
    }

    public UserColorLookup(Function<Color, String> colorToStringConverter) {
        this(colorToStringConverter, 2);
    }

    public UserColorLookup(final Function<Color, String> colorToStringConverter, int priority) {
        super(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)COLOR_STRING).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                UserColorLookup.handleUserSelection(context, (Function<Color, String>)colorToStringConverter);
            }
        }), (double)priority));
    }

    private static void handleUserSelection(InsertionContext context, @NotNull Function<Color, String> colorToStringConverter) {
        if (colorToStringConverter == null) {
            UserColorLookup.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        Editor editor = context.getEditor();
        int startOffset = context.getStartOffset();
        context.getDocument().deleteString(startOffset, context.getTailOffset());
        PsiElement element = context.getFile().findElementAt(editor.getCaretModel().getOffset());
        Color myColorAtCaret = element instanceof XmlToken ? UserColorLookup.getColorFromElement(element) : null;
        context.setLaterRunnable(() -> {
            if (colorToStringConverter == null) {
                UserColorLookup.$$$reportNull$$$0(1);
            }
            if (editor.isDisposed() || project.isDisposed()) {
                return;
            }
            List<ColorPickerListener> listeners = ColorPickerListenerFactory.createListenersFor(element);
            Color color = ColorChooser.chooseColor((Component)WindowManager.getInstance().suggestParentWindow(project), (String)XmlBundle.message((String)"choose.color.dialog.title", (Object[])new Object[0]), (Color)myColorAtCaret, (boolean)true, listeners, (boolean)true);
            if (color != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    if (colorToStringConverter == null) {
                        UserColorLookup.$$$reportNull$$$0(2);
                    }
                    editor.getCaretModel().moveToOffset(startOffset);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)((String)colorToStringConverter.fun((Object)color)));
                });
            }
        });
    }

    @Nullable
    public static Color getColorFromElement(PsiElement element) {
        if (!(element instanceof XmlToken)) {
            return null;
        }
        return ColorMap.getColor(element.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "colorToStringConverter";
        objectArray2[1] = "com/intellij/xml/util/UserColorLookup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleUserSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$handleUserSelection$2";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

