/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.widget;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsConfigurable;
import com.jetbrains.jsonSchema.widget.JsonSchemaStatusPopup;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaInfoPopupStep
extends BaseListPopupStep<JsonSchemaInfo> {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    @NotNull
    private final JsonSchemaService myService;
    private static final Icon EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)AllIcons.General.Add.getIconWidth()));

    public JsonSchemaInfoPopupStep(@NotNull List<JsonSchemaInfo> allSchemas, @NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull JsonSchemaService service2) {
        if (allSchemas == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(2);
        }
        if (service2 == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(3);
        }
        super(null, allSchemas);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myService = service2;
    }

    @NotNull
    public String getTextFor(JsonSchemaInfo value) {
        String string = value.getDescription();
        if (string == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(4);
        }
        return string;
    }

    public Icon getIconFor(JsonSchemaInfo value) {
        if (value == JsonSchemaStatusPopup.ADD_MAPPING) {
            return AllIcons.General.Add;
        }
        if (value == JsonSchemaStatusPopup.EDIT_MAPPINGS) {
            return AllIcons.Actions.Edit;
        }
        if (value == JsonSchemaStatusPopup.LOAD_REMOTE) {
            return AllIcons.Actions.Refresh;
        }
        return EMPTY_ICON;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(JsonSchemaInfo value) {
        List values = this.getValues();
        int index = values.indexOf(value);
        if (index - 1 >= 0) {
            JsonSchemaInfo info = (JsonSchemaInfo)values.get(index - 1);
            if (info == JsonSchemaStatusPopup.EDIT_MAPPINGS || info == JsonSchemaStatusPopup.ADD_MAPPING) {
                return new ListSeparator("Registered schemas");
            }
            if (value.getProvider() == null && info.getProvider() != null) {
                return new ListSeparator("SchemaStore.org schemas");
            }
        }
        return null;
    }

    public PopupStep onChosen(JsonSchemaInfo selectedValue, boolean finalChoice) {
        if (finalChoice) {
            if (selectedValue == JsonSchemaStatusPopup.EDIT_MAPPINGS || selectedValue == JsonSchemaStatusPopup.ADD_MAPPING) {
                return this.doFinalStep(() -> this.runSchemaEditorForCurrentFile());
            }
            if (selectedValue == JsonSchemaStatusPopup.LOAD_REMOTE) {
                return this.doFinalStep(() -> this.myService.triggerUpdateRemote());
            }
            JsonSchemaInfoPopupStep.setMapping(selectedValue, this.myVirtualFile, this.myProject);
            return this.doFinalStep(() -> this.myService.reset());
        }
        return PopupStep.FINAL_CHOICE;
    }

    private void runSchemaEditorForCurrentFile() {
        JsonSchemaMappingsConfigurable configurable = new JsonSchemaMappingsConfigurable(this.myProject);
        JsonSchemaMappingsProjectConfiguration mappingsConf = JsonSchemaMappingsProjectConfiguration.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)configurable, () -> {
            UserDefinedJsonSchemaConfiguration mappingForFile = mappingsConf.findMappingForFile(this.myVirtualFile);
            if (mappingForFile == null) {
                UserDefinedJsonSchemaConfiguration configuration = configurable.addProjectSchema();
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myVirtualFile, (VirtualFile)this.myProject.getBaseDir());
                configuration.patterns.add(new UserDefinedJsonSchemaConfiguration.Item(relativePath == null ? this.myVirtualFile.getUrl() : relativePath, false, false));
                mappingForFile = configuration;
            }
            configurable.selectInTree(mappingForFile);
        });
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    private static void setMapping(@Nullable JsonSchemaInfo selectedValue, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JsonSchemaInfoPopupStep.$$$reportNull$$$0(6);
        }
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project);
        VirtualFile projectBaseDir = project.getBaseDir();
        UserDefinedJsonSchemaConfiguration mappingForFile = configuration.findMappingForFile(virtualFile);
        if (mappingForFile != null) {
            for (UserDefinedJsonSchemaConfiguration.Item pattern : mappingForFile.patterns) {
                if (!Objects.equals(VfsUtil.findRelativeFile((VirtualFile)projectBaseDir, (String[])pattern.getPathParts()), virtualFile) && !virtualFile.getUrl().equals(pattern.getPath())) continue;
                mappingForFile.patterns.remove(pattern);
                if (mappingForFile.patterns.size() == 0 && mappingForFile.isApplicationDefined()) {
                    configuration.removeConfiguration(mappingForFile);
                    break;
                }
                mappingForFile.refreshPatterns();
                break;
            }
        }
        if (selectedValue == null) {
            return;
        }
        String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)projectBaseDir);
        if (path == null) {
            path = virtualFile.getUrl();
        }
        UserDefinedJsonSchemaConfiguration existing = configuration.findMappingBySchemaInfo(selectedValue);
        UserDefinedJsonSchemaConfiguration.Item item = new UserDefinedJsonSchemaConfiguration.Item(path, false, false);
        if (existing != null) {
            if (!existing.patterns.contains(item)) {
                existing.patterns.add(item);
                existing.refreshPatterns();
            }
        } else {
            configuration.addConfiguration(new UserDefinedJsonSchemaConfiguration(selectedValue.getDescription(), selectedValue.getSchemaVersion(), selectedValue.getUrl(project), true, Collections.singletonList(item)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSchemas";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/widget/JsonSchemaInfoPopupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/widget/JsonSchemaInfoPopupStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

