/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public class BuildoutConfigPanel
extends JPanel {
    private ComboboxWithBrowseButton myScript;
    private JPanel myPanel;
    private JTextArea myNoticeTextArea;
    private JPanel myErrorPanel;
    private final Module myModule;
    private boolean myFacetEnabled = true;
    private final BuildoutFacetConfiguration myConfiguration;

    public BuildoutConfigPanel(Module module2, BuildoutFacetConfiguration config) {
        this.myModule = module2;
        this.myConfiguration = config;
        this.$$$setupUI$$$();
        this.setLayout(new BorderLayout());
        this.add(this.myPanel);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myScript.addBrowseFolderListener("Choose a buildout script", "Select the target script that will invoke your code", null, descriptor2, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        this.myScript.getComboBox().setEditable(true);
        this.initErrorValidation();
    }

    public void setFacetEnabled(boolean facetEnabled) {
        if (this.myFacetEnabled != facetEnabled) {
            this.myFacetEnabled = facetEnabled;
            this.initErrorValidation();
        }
    }

    private void initErrorValidation() {
        FacetErrorPanel facetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)facetErrorPanel.getComponent(), "Center");
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                if (!BuildoutConfigPanel.this.myFacetEnabled) {
                    ValidationResult validationResult = ValidationResult.OK;
                    if (validationResult == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return validationResult;
                }
                ValidationResult validationResult = BuildoutConfigPanel.validateScriptName(BuildoutConfigPanel.this.getScriptName());
                if (validationResult == null) {
                    1.$$$reportNull$$$0(1);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/BuildoutConfigPanel$1", "check"));
            }
        }, new JComponent[]{this.myScript});
        facetErrorPanel.getValidatorsManager().validate();
    }

    private static ValidationResult validateScriptName(String scriptName) {
        if (StringUtil.isEmpty((String)scriptName)) {
            return new ValidationResult("Please specify buildout script");
        }
        try {
            BuildoutConfigPanel.getScriptFile(scriptName);
        }
        catch (ConfigurationException e) {
            return new ValidationResult(e.getMessage());
        }
        return ValidationResult.OK;
    }

    public boolean isModified(BuildoutFacetConfiguration configuration) {
        String ours;
        String their = configuration.getScriptName();
        return !Comparing.strEqual((String)their, (String)(ours = this.getScriptName()));
    }

    public String getScriptName() {
        return (String)this.myScript.getComboBox().getEditor().getItem();
    }

    public void reset() {
        List<File> scriptFiles = BuildoutFacet.getScripts(BuildoutFacet.getInstance(this.myModule), this.myModule.getProject().getBaseDir());
        List scripts = ContainerUtil.map(scriptFiles, file2 -> file2.getPath());
        this.myScript.getComboBox().setModel(new CollectionComboBoxModel(scripts, (Object)this.myConfiguration.getScriptName()));
        this.myScript.getComboBox().getEditor().setItem(this.myConfiguration.getScriptName());
    }

    public void apply() {
        String scriptName = this.getScriptName();
        this.myConfiguration.setScriptName(scriptName);
    }

    BuildoutFacetConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    void showNoticeText(boolean show) {
        this.myNoticeTextArea.setVisible(show);
    }

    @NotNull
    public static VirtualFile getScriptFile(String script_name) throws ConfigurationException {
        VirtualFile script_file = LocalFileSystem.getInstance().findFileByPath(script_name);
        if (script_file == null || script_file.isDirectory()) {
            throw new ConfigurationException("Invalid script file '" + script_name + "'");
        }
        VirtualFile virtualFile = script_file;
        if (virtualFile == null) {
            BuildoutConfigPanel.$$$reportNull$$$0(0);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/BuildoutConfigPanel", "getScriptFile"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextArea jTextArea;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScript = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Use paths from script: ");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setDisplayedMnemonicIndex(15);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNoticeTextArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText("Set to <buildout-dir>/bin/django.py for proper Django support ");
        jTextArea.setWrapStyleWord(true);
        jPanel2.add((Component)jTextArea, new GridConstraints(1, 1, 1, 1, 1, 1, 6, 2, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

