/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.completion.PyExtendedCompletionContributor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class PyClassNameCompletionContributor
extends PyExtendedCompletionContributor {
    @Override
    protected void doFillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(1);
        }
        PsiFile originalFile = parameters2.getOriginalFile();
        PsiElement element = parameters2.getPosition();
        PsiElement parent = element.getParent();
        PyClassNameCompletionContributor.addVariantsFromIndex(result2, originalFile, PyClassNameIndex.KEY, parent instanceof PyStringLiteralExpression ? this.getStringLiteralInsertHandler() : this.getImportingInsertHandler(), PyUtil::isTopLevel, PyClass.class, PyClassNameCompletionContributor.createClassElementHandler(originalFile));
        PyClassNameCompletionContributor.addVariantsFromIndex(result2, originalFile, PyFunctionNameIndex.KEY, this.getFunctionInsertHandler(parent), PyUtil::isTopLevel, PyFunction.class, Function.identity());
        PyClassNameCompletionContributor.addVariantsFromIndex(result2, originalFile, PyVariableNameIndex.KEY, parent instanceof PyStringLiteralExpression ? this.getStringLiteralInsertHandler() : this.getImportingInsertHandler(), PyUtil::isTopLevel, PyTargetExpression.class, Function.identity());
    }

    @NotNull
    private static Function<LookupElement, LookupElement> createClassElementHandler(@NotNull PsiFile file2) {
        PyFile pyFile;
        if (file2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((pyFile = PyUtil.as(file2, PyFile.class)) == null) {
            Function<LookupElement, LookupElement> function = Function.identity();
            if (function == null) {
                PyClassNameCompletionContributor.$$$reportNull$$$0(3);
            }
            return function;
        }
        Set sourceQNames = ContainerUtil.map2SetNotNull(pyFile.getFromImports(), PyFromImportStatement::getImportSourceQName);
        Function<LookupElement, LookupElement> function = le -> {
            PyClass cls = PyUtil.as(le.getPsiElement(), PyClass.class);
            if (cls == null) {
                return le;
            }
            String clsQName = cls.getQualifiedName();
            if (clsQName == null) {
                return le;
            }
            if (!sourceQNames.contains(QualifiedName.fromDottedString((String)clsQName).removeLastComponent())) {
                return le;
            }
            return PrioritizedLookupElement.withPriority((LookupElement)le, (double)5.0);
        };
        if (function == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(4);
        }
        return function;
    }

    private InsertHandler<LookupElement> getFunctionInsertHandler(PsiElement parent) {
        if (parent instanceof PyStringLiteralExpression) {
            return this.getStringLiteralInsertHandler();
        }
        if (parent.getParent() instanceof PyDecorator) {
            return this.getImportingInsertHandler();
        }
        return this.getFunctionInsertHandler();
    }

    private static <T extends PsiNamedElement> void addVariantsFromIndex(@NotNull CompletionResultSet resultSet, @NotNull PsiFile targetFile, @NotNull StubIndexKey<String, T> key, @NotNull InsertHandler<LookupElement> insertHandler, @NotNull Condition<? super T> condition, @NotNull Class<T> elementClass, @NotNull Function<LookupElement, LookupElement> elementHandler) {
        if (resultSet == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(6);
        }
        if (key == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(7);
        }
        if (insertHandler == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(9);
        }
        if (elementClass == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(10);
        }
        if (elementHandler == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(11);
        }
        Project project = targetFile.getProject();
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)targetFile);
        HashMap<String, LookupElementBuilder> uniqueResults = new HashMap<String, LookupElementBuilder>();
        Collection keys = StubIndex.getInstance().getAllKeys(key, project);
        for (String elementName : CompletionUtil.sortMatching(resultSet.getPrefixMatcher(), keys)) {
            for (PsiNamedElement element : StubIndex.getElements(key, (Object)elementName, (Project)project, (GlobalSearchScope)scope, elementClass)) {
                if (!condition.value((Object)element)) continue;
                String name = element.getName();
                ItemPresentation itemPresentation = ((NavigationItem)element).getPresentation();
                if (name == null || itemPresentation == null || itemPresentation.getLocationString() == null) continue;
                LookupElementBuilder builder2 = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withIcon(element.getIcon(0)).withTailText(" " + itemPresentation.getLocationString(), true).withInsertHandler(insertHandler);
                uniqueResults.put(itemPresentation.getPresentableText() + itemPresentation.getLocationString(), builder2);
            }
        }
        uniqueResults.values().stream().map(elementHandler).forEach(arg_0 -> ((CompletionResultSet)resultSet).addElement(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassElementHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClassElementHandler";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsFromIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

