/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertStaticMethodToFunctionIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.static.method.to.function", new Object[0]);
        if (string == null) {
            PyConvertStaticMethodToFunctionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.static.method.to.function", new Object[0]);
        if (string == null) {
            PyConvertStaticMethodToFunctionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PyDecorator staticMethod;
        if (project == null) {
            PyConvertStaticMethodToFunctionIntention.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof PyFile)) {
            return false;
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file2, editor.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function == null) {
            return false;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PyDecoratorList decoratorList = function.getDecoratorList();
        return decoratorList != null && (staticMethod = decoratorList.findDecorator("staticmethod")) != null;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PyDecorator decorator;
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyConvertStaticMethodToFunctionIntention.$$$reportNull$$$0(3);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = PyUtil.findNonWhitespaceAtOffset(file2, editor.getCaretModel().getOffset())), PyFunction.class)) == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        PyDecoratorList decoratorList = problemFunction.getDecoratorList();
        if (decoratorList != null && (decorator = decoratorList.findDecorator("staticmethod")) != null) {
            decorator.delete();
        }
        PsiElement copy = problemFunction.copy();
        problemFunction.delete();
        file2.addAfter(copy, (PsiElement)containingClass);
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            PyUtil.removeQualifier((PyReferenceExpression)usageElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertStaticMethodToFunctionIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertStaticMethodToFunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

