/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.postfix;

import com.intellij.codeInsight.template.postfix.templates.SurroundPostfixTemplateBase;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.codeInsight.postfix.PyPostfixUtils;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.refactoring.surround.surrounders.expressions.PyExpressionSurrounder;
import org.jetbrains.annotations.NotNull;

public class PyPrintPostfixTemplate
extends SurroundPostfixTemplateBase {
    public static final String DESCR = "print(expr)";

    protected PyPrintPostfixTemplate() {
        super("print", DESCR, PyPostfixUtils.PY_PSI_INFO, PyPostfixUtils.selectorTopmost());
    }

    @Override
    @NotNull
    protected Surrounder getSurrounder() {
        PyExpressionSurrounder pyExpressionSurrounder = new PyExpressionSurrounder(){

            @Override
            public boolean isApplicable(@NotNull PyExpression expr) {
                if (expr == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PyExpression expression) throws IncorrectOperationException {
                LanguageLevel level;
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                String textToGenerate = !(level = LanguageLevel.forElement((PsiElement)expression)).isPython2() ? "print(a)" : "print a";
                PyStatement pyStatement = PyElementGenerator.getInstance(project).createFromText(level, PyStatement.class, textToGenerate);
                if (level.isPython2()) {
                    pyStatement.getLastChild().replace((PsiElement)expression);
                } else {
                    PyArgumentList argumentList = (PyArgumentList)PsiTreeUtil.findChildOfType((PsiElement)pyStatement, PyArgumentList.class);
                    if (argumentList == null) {
                        return null;
                    }
                    argumentList.getArguments()[0].replace((PsiElement)expression);
                }
                pyStatement = (PyStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)pyStatement);
                pyStatement = (PyStatement)expression.getParent().replace((PsiElement)pyStatement);
                return TextRange.from((int)pyStatement.getTextRange().getEndOffset(), (int)0);
            }

            public String getTemplateDescription() {
                return PyPrintPostfixTemplate.DESCR;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expr";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/codeInsight/postfix/PyPrintPostfixTemplate$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isApplicable";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "surroundExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (pyExpressionSurrounder == null) {
            PyPrintPostfixTemplate.$$$reportNull$$$0(0);
        }
        return pyExpressionSurrounder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/postfix/PyPrintPostfixTemplate", "getSurrounder"));
    }
}

