/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.StatementEffectFunctionCallQuickFix;
import com.jetbrains.python.inspections.quickfix.StatementEffectIntroduceVariableQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStatementEffectInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.statement.effect", new Object[0]);
        if (string == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    @Override
    protected boolean isSuppressForCodeFragment() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyStatementEffectInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyStatementEffectInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session2) {
            super(holder, session2);
        }

        @Override
        public void visitPyExpressionStatement(PyExpressionStatement node) {
            PyStatementList statementList;
            PyExpression expression = node.getExpression();
            if (PsiTreeUtil.hasErrorElements((PsiElement)expression)) {
                return;
            }
            if (this.hasEffect(expression)) {
                return;
            }
            if (expression instanceof PyStringLiteralExpression) {
                return;
            }
            PyTryPart tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class);
            if (tryPart != null && (statementList = tryPart.getStatementList()).getStatements().length == 1 && statementList.getStatements()[0] == node) {
                return;
            }
            if (expression instanceof PyReferenceExpression && !((PyReferenceExpression)expression).isQualified()) {
                this.registerProblem((PsiElement)expression, PyBundle.message("INSP.NAME.statement.message", new Object[0]));
            } else {
                this.registerProblem((PsiElement)expression, PyBundle.message("INSP.NAME.statement.message", new Object[0]), new StatementEffectIntroduceVariableQuickFix());
            }
        }

        private boolean hasEffect(@Nullable PyExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PyCallExpression || expression instanceof PyYieldExpression) {
                return true;
            }
            if (expression instanceof PyListCompExpression) {
                if (this.hasEffect(((PyListCompExpression)expression).getResultExpression())) {
                    return true;
                }
            } else if (expression instanceof PyBinaryExpression) {
                String method;
                PyBinaryExpression binary = (PyBinaryExpression)expression;
                PyElementType operator = binary.getOperator();
                if (PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator)) {
                    return false;
                }
                PyExpression leftExpression = binary.getLeftExpression();
                PyExpression rightExpression = binary.getRightExpression();
                if (this.hasEffect(leftExpression) || this.hasEffect(rightExpression)) {
                    return true;
                }
                String string = method = operator == null ? null : operator.getSpecialMethodName();
                if (method != null) {
                    PyType type = this.myTypeEvalContext.getType(leftExpression);
                    if (type != null && !type.isBuiltin() && type.resolveMember(method, null, AccessDirection.READ, this.getResolveContext()) != null) {
                        return true;
                    }
                    if (rightExpression != null && (type = this.myTypeEvalContext.getType(rightExpression)) != null) {
                        String rmethod = "__r" + method.substring(2);
                        if (!type.isBuiltin() && type.resolveMember(rmethod, null, AccessDirection.READ, this.getResolveContext()) != null) {
                            return true;
                        }
                    }
                }
            } else {
                if (expression instanceof PyConditionalExpression) {
                    PyConditionalExpression conditionalExpression = (PyConditionalExpression)expression;
                    return this.hasEffect(conditionalExpression.getTruePart()) || this.hasEffect(conditionalExpression.getFalsePart());
                }
                if (expression instanceof PyParenthesizedExpression) {
                    PyParenthesizedExpression parenthesizedExpression = (PyParenthesizedExpression)expression;
                    return this.hasEffect(parenthesizedExpression.getContainedExpression());
                }
                if (expression instanceof PyReferenceExpression) {
                    ResolveResult[] results;
                    PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                    for (ResolveResult res : results = referenceExpression.getReference(this.getResolveContext()).multiResolve(true)) {
                        if (!(res.getElement() instanceof PyFunction)) continue;
                        this.registerProblem((PsiElement)expression, "Statement seems to have no effect and can be replaced with function call to have effect", new StatementEffectFunctionCallQuickFix());
                        return true;
                    }
                } else if (expression instanceof PyTupleExpression) {
                    PyExpression[] elements;
                    for (PyExpression element : elements = ((PyTupleExpression)expression).getElements()) {
                        if (!this.hasEffect(element)) continue;
                        return true;
                    }
                } else {
                    if (expression instanceof PyPrefixExpression) {
                        PyPrefixExpression prefixExpr = (PyPrefixExpression)expression;
                        return prefixExpr.getOperator() == PyTokenTypes.AWAIT_KEYWORD;
                    }
                    if (expression instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)expression).isEllipsis()) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

