/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyDictCreationInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DictCreationQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PyAssignmentStatement> myStatementPointer;

    public DictCreationQuickFix(@NotNull PyAssignmentStatement statement) {
        if (statement == null) {
            DictCreationQuickFix.$$$reportNull$$$0(0);
        }
        this.myStatementPointer = SmartPointerManager.createPointer((PsiElement)statement);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.dict.creation", new Object[0]);
        if (string == null) {
            DictCreationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            DictCreationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            DictCreationQuickFix.$$$reportNull$$$0(3);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        LinkedHashMap statementsMap = Maps.newLinkedHashMap();
        PyAssignmentStatement myStatement = (PyAssignmentStatement)this.myStatementPointer.getElement();
        if (myStatement == null) {
            return;
        }
        PyExpression assignedValue = myStatement.getAssignedValue();
        if (assignedValue instanceof PyDictLiteralExpression) {
            for (PyKeyValueExpression expression : ((PyDictLiteralExpression)assignedValue).getElements()) {
                PyExpression value = expression.getValue();
                if (value == null) continue;
                statementsMap.put(expression.getKey().getText(), value.getText());
            }
            PyStatement statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)myStatement, PyStatement.class);
            while (statement instanceof PyAssignmentStatement) {
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)statement;
                PyExpression target2 = myStatement.getTargets()[0];
                String targetName = target2.getName();
                if (targetName == null) continue;
                List<Pair<PyExpression, PyExpression>> targetsToValues = PyDictCreationInspection.getDictTargets(target2, targetName, assignmentStatement);
                PyStatement nextStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PyStatement.class);
                if (targetsToValues == null || targetsToValues.isEmpty()) break;
                for (Pair<PyExpression, PyExpression> targetToValue : targetsToValues) {
                    PySubscriptionExpression subscription = (PySubscriptionExpression)targetToValue.first;
                    PyExpression indexExpression = subscription.getIndexExpression();
                    assert (indexExpression != null);
                    String indexText = indexExpression instanceof PyTupleExpression ? "(" + indexExpression.getText() + ")" : indexExpression.getText();
                    String valueText = targetToValue.second instanceof PyTupleExpression ? "(" + ((PyExpression)targetToValue.second).getText() + ")" : ((PyExpression)targetToValue.second).getText();
                    statementsMap.put(indexText, valueText);
                    statement.delete();
                }
                statement = nextStatement;
            }
            ArrayList statements = Lists.newArrayList();
            for (Map.Entry entry : statementsMap.entrySet()) {
                statements.add((String)entry.getKey() + ": " + (String)entry.getValue());
            }
            PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(myStatement), "{" + StringUtil.join((Collection)statements, (String)", ") + "}");
            if (expression != null) {
                assignedValue.replace((PsiElement)expression);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

