/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkChooserCombo
extends ComboboxWithBrowseButton {
    private final List<ActionListener> myChangedListeners;
    private static final Logger LOG = Logger.getInstance(PythonSdkChooserCombo.class);
    @Nullable
    private String myNewProjectPath;

    public PythonSdkChooserCombo(final @Nullable Project project, final @Nullable Module module2, @NotNull List<Sdk> sdks, @Nullable String newProjectPath, @NotNull Condition<Sdk> acceptableSdkCondition) {
        if (sdks == null) {
            PythonSdkChooserCombo.$$$reportNull$$$0(0);
        }
        if (acceptableSdkCondition == null) {
            PythonSdkChooserCombo.$$$reportNull$$$0(1);
        }
        super((JComboBox)new ComboBox());
        this.myChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myNewProjectPath = newProjectPath;
        Sdk initialSelection = (Sdk)ContainerUtil.find(sdks, acceptableSdkCondition);
        JComboBox comboBox = this.getComboBox();
        comboBox.setModel(new CollectionComboBoxModel(sdks, (Object)initialSelection));
        comboBox.setRenderer(new PySdkListCellRenderer(null));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkChooserCombo.this.showOptions(project, module2);
                PythonSdkChooserCombo.this.notifyChanged(e);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkChooserCombo.this.notifyChanged(e);
                PythonSdkChooserCombo.this.updateTooltip();
            }
        });
        new ComboboxSpeedSearch(comboBox);
        this.updateTooltip();
    }

    private void updateTooltip() {
        Object item = this.getComboBox().getSelectedItem();
        this.getComboBox().setToolTipText(item instanceof Sdk ? ((Sdk)item).getHomePath() : null);
    }

    private void showOptions(@Nullable Project project, @Nullable Module module2) {
        PyConfigurableInterpreterList interpreterList = PyConfigurableInterpreterList.getInstance(project);
        Sdk[] sdks = interpreterList.getModel().getSdks();
        JComboBox comboBox = this.getComboBox();
        Sdk oldSelectedSdk = (Sdk)comboBox.getSelectedItem();
        PythonSdkDetailsStep.show(project, module2, sdks, null, (JComponent)((Object)this), this.getButton().getLocationOnScreen(), this.myNewProjectPath, (NullableConsumer<Sdk>)((NullableConsumer)sdk -> {
            if (sdk == null) {
                return;
            }
            ProjectSdksModel projectSdksModel = interpreterList.getModel();
            if (projectSdksModel.findSdk((Sdk)sdk) == null) {
                projectSdksModel.addSdk((Sdk)sdk);
                try {
                    projectSdksModel.apply();
                }
                catch (ConfigurationException e) {
                    LOG.error("Error adding new python interpreter " + e.getMessage());
                }
            }
            List<Sdk> committedSdks = interpreterList.getAllPythonSdks();
            Sdk copiedSdk = interpreterList.getModel().findSdk(sdk.getName());
            comboBox.setModel(new CollectionComboBoxModel(committedSdks, (Object)oldSelectedSdk));
            comboBox.setSelectedItem(copiedSdk);
            this.notifyChanged(null);
        }));
    }

    private void notifyChanged(ActionEvent e) {
        for (ActionListener changedListener : this.myChangedListeners) {
            changedListener.actionPerformed(e);
        }
    }

    public void addChangedListener(ActionListener listener2) {
        this.myChangedListeners.add(listener2);
    }

    public void setNewProjectPath(@Nullable String newProjectPath) {
        this.myNewProjectPath = newProjectPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sdks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "acceptableSdkCondition";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/newProject/steps/PythonSdkChooserCombo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

