/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.psi.PyFile;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public enum LanguageLevel {
    PYTHON24(24, false, true, false, false),
    PYTHON25(25, false, true, false, false),
    PYTHON26(26, true, true, false, false),
    PYTHON27(27, true, true, true, false),
    PYTHON30(30, true, false, false, true),
    PYTHON31(31, true, false, true, true),
    PYTHON32(32, true, false, true, true),
    PYTHON33(33, true, false, true, true),
    PYTHON34(34, true, false, true, true),
    PYTHON35(35, true, false, true, true),
    PYTHON36(36, true, false, true, true),
    PYTHON37(37, true, false, true, true);

    public static final List<LanguageLevel> SUPPORTED_LEVELS;
    private static final LanguageLevel DEFAULT2;
    private static final LanguageLevel DEFAULT3;
    public static LanguageLevel FORCE_LANGUAGE_LEVEL;
    private final int myVersion;
    private final boolean myHasWithStatement;
    private final boolean myHasPrintStatement;
    private final boolean mySupportsSetLiterals;
    private final boolean myIsPy3K;
    public static final Key<LanguageLevel> KEY;

    @NotNull
    public static LanguageLevel getDefault() {
        LanguageLevel languageLevel = DEFAULT2;
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(0);
        }
        return languageLevel;
    }

    private LanguageLevel(int version, boolean hasWithStatement, boolean hasPrintStatement, boolean supportsSetLiterals, boolean isPy3K) {
        this.myVersion = version;
        this.myHasWithStatement = hasWithStatement;
        this.myHasPrintStatement = hasPrintStatement;
        this.mySupportsSetLiterals = supportsSetLiterals;
        this.myIsPy3K = isPy3K;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public boolean hasWithStatement() {
        return this.myHasWithStatement;
    }

    public boolean hasPrintStatement() {
        return this.myHasPrintStatement;
    }

    public boolean supportsSetLiterals() {
        return this.mySupportsSetLiterals;
    }

    public boolean isPython2() {
        return !this.myIsPy3K;
    }

    public boolean isPy3K() {
        return this.myIsPy3K;
    }

    public boolean isOlderThan(@NotNull LanguageLevel other) {
        if (other == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return this.myVersion < other.myVersion;
    }

    public boolean isAtLeast(@NotNull LanguageLevel other) {
        if (other == null) {
            LanguageLevel.$$$reportNull$$$0(2);
        }
        return this.myVersion >= other.myVersion;
    }

    public static LanguageLevel fromPythonVersion(@NotNull String pythonVersion) {
        if (pythonVersion == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        if (pythonVersion.startsWith("2")) {
            if (pythonVersion.startsWith("2.4")) {
                return PYTHON24;
            }
            if (pythonVersion.startsWith("2.5")) {
                return PYTHON25;
            }
            if (pythonVersion.startsWith("2.6")) {
                return PYTHON26;
            }
            if (pythonVersion.startsWith("2.7")) {
                return PYTHON27;
            }
            return DEFAULT2;
        }
        if (pythonVersion.startsWith("3")) {
            if (pythonVersion.startsWith("3.0")) {
                return PYTHON30;
            }
            if (pythonVersion.startsWith("3.1")) {
                return PYTHON31;
            }
            if (pythonVersion.startsWith("3.2")) {
                return PYTHON32;
            }
            if (pythonVersion.startsWith("3.3")) {
                return PYTHON33;
            }
            if (pythonVersion.startsWith("3.4")) {
                return PYTHON34;
            }
            if (pythonVersion.startsWith("3.5")) {
                return PYTHON35;
            }
            if (pythonVersion.startsWith("3.6")) {
                return PYTHON36;
            }
            if (pythonVersion.startsWith("3.7")) {
                return PYTHON37;
            }
            return DEFAULT3;
        }
        return LanguageLevel.getDefault();
    }

    @NotNull
    public static LanguageLevel forElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            LanguageLevel.$$$reportNull$$$0(4);
        }
        if ((containingFile = element.getContainingFile()) instanceof PyFile) {
            LanguageLevel languageLevel = ((PyFile)containingFile).getLanguageLevel();
            if (languageLevel == null) {
                LanguageLevel.$$$reportNull$$$0(5);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(6);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLatest() {
        LanguageLevel languageLevel = (LanguageLevel)((Object)ArrayUtil.getLastElement((Object[])LanguageLevel.values()));
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(7);
        }
        return languageLevel;
    }

    public String toString() {
        return this.myVersion / 10 + "." + this.myVersion % 10;
    }

    static {
        SUPPORTED_LEVELS = ImmutableList.copyOf((Collection)Stream.of(LanguageLevel.values()).filter(v -> v.myVersion > 33 || v.myVersion == 26 || v.myVersion == 27).collect(Collectors.toList()));
        DEFAULT2 = PYTHON27;
        DEFAULT3 = PYTHON37;
        FORCE_LANGUAGE_LEVEL = null;
        KEY = new Key("python.language.level");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/LanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/LanguageLevel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatest";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOlderThan";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromPythonVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

