/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassAttributesIndex;
import com.jetbrains.python.psi.stubs.PyClassNameIndexInsensitive;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyQualifiedReference
extends PyReferenceImpl {
    private static final Logger LOG = Logger.getInstance(PyQualifiedReference.class);

    public PyQualifiedReference(PyQualifiedExpression element, PyResolveContext context) {
        super(element, context);
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        PyPsiUtils.assertValid((PsiElement)this.myElement);
        ResolveResultList ret = new ResolveResultList();
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                PyQualifiedReference.$$$reportNull$$$0(0);
            }
            return resolveResultList;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        PyPsiUtils.assertValid((PsiElement)qualifier);
        if (qualifier == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                PyQualifiedReference.$$$reportNull$$$0(1);
            }
            return resolveResultList;
        }
        PyType qualifierType = this.myContext.getTypeEvalContext().getType(qualifier);
        if (PyUtil.isClassPrivateName(referencedName) && qualifierType instanceof PyClassType && PyQualifiedReference.isOtherClassQualifying(qualifier, (PyClassType)qualifierType)) {
            List<RatedResolveResult> list2 = Collections.emptyList();
            if (list2 == null) {
                PyQualifiedReference.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (qualifierType != null) {
            qualifierType.assertValid("qualifier: " + qualifier);
            AccessDirection ctx = AccessDirection.of(this.myElement);
            List<? extends RatedResolveResult> membersOfQualifier = qualifierType.resolveMember(referencedName, qualifier, ctx, this.myContext);
            if (membersOfQualifier == null) {
                ResolveResultList resolveResultList = ret;
                if (resolveResultList == null) {
                    PyQualifiedReference.$$$reportNull$$$0(3);
                }
                return resolveResultList;
            }
            ret.addAll(membersOfQualifier);
        }
        if (qualifier instanceof PyQualifiedExpression && ret.isEmpty() && PyQualifiedReference.addAssignedAttributes(ret, referencedName, (PyQualifiedExpression)qualifier)) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                PyQualifiedReference.$$$reportNull$$$0(4);
            }
            return resolveResultList;
        }
        if ((PyTypeChecker.isUnknown(qualifierType, this.myContext.getTypeEvalContext()) || qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages()) && this.myContext.allowImplicits() && PyQualifiedReference.canQualifyAnImplicitName(qualifier)) {
            this.addImplicitResolveResults(referencedName, ret);
        }
        if ("__doc__".equals(referencedName)) {
            this.addDocReference(ret, qualifier, qualifierType);
        }
        ResolveResultList resolveResultList = ret;
        if (resolveResultList == null) {
            PyQualifiedReference.$$$reportNull$$$0(5);
        }
        return resolveResultList;
    }

    private static boolean isOtherClassQualifying(@NotNull PyExpression qualifier, @NotNull PyClassType qualifierType) {
        PsiElement theirClass;
        PyClass ourClass;
        List<PsiElement> match;
        if (qualifier == null) {
            PyQualifiedReference.$$$reportNull$$$0(6);
        }
        if (qualifierType == null) {
            PyQualifiedReference.$$$reportNull$$$0(7);
        }
        if ((match = PyUtil.searchForWrappingMethod((PsiElement)qualifier, true)) == null) {
            return true;
        }
        return match.size() > 1 && (ourClass = PyiUtil.stubToOriginal(qualifierType.getPyClass(), PyClass.class)) != (theirClass = CompletionUtil.getOriginalOrSelf(match.get(match.size() - 1)));
    }

    private void addImplicitResolveResults(String referencedName, ResolveResultList ret) {
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope(project);
        Collection<PyFunction> functions = PyFunctionNameIndex.find(referencedName, project, scope);
        PsiFile containingFile = this.myElement.getContainingFile();
        List<Object> imports = containingFile instanceof PyFile ? PyQualifiedReference.collectImports((PyFile)containingFile) : Collections.emptyList();
        for (PyFunction function : functions) {
            if (!(function instanceof PyFunction)) {
                FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, new Throwable("found non-function object " + function + " in function list"));
                break;
            }
            PyFunction pyFunction = function;
            if (pyFunction.getContainingClass() == null) continue;
            ret.add(new ImplicitResolveResult(pyFunction, this.getImplicitResultRate(pyFunction, imports)));
        }
        PyClassAttributesIndex.findClassAndInstanceAttributes(referencedName, project, scope).forEach(attribute -> ret.add(new ImplicitResolveResult((PsiElement)attribute, this.getImplicitResultRate((PyElement)attribute, (List<QualifiedName>)imports))));
    }

    private static List<QualifiedName> collectImports(PyFile containingFile) {
        ArrayList<QualifiedName> imports = new ArrayList<QualifiedName>();
        for (PyFromImportStatement anImport : containingFile.getFromImports()) {
            QualifiedName source = anImport.getImportSourceQName();
            if (source == null) continue;
            imports.add(source);
        }
        for (PyImportElement importElement : containingFile.getImportTargets()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            imports.add(qName.removeLastComponent());
        }
        return imports;
    }

    private int getImplicitResultRate(PyElement target2, List<QualifiedName> imports) {
        int rate = -1000;
        if (target2.getContainingFile() == this.myElement.getContainingFile()) {
            rate += 200;
        } else {
            VirtualFile vFile = target2.getContainingFile().getVirtualFile();
            if (vFile != null) {
                QualifiedName qName;
                if (ProjectScope.getProjectScope((Project)this.myElement.getProject()).contains(vFile)) {
                    rate += 80;
                }
                if ((qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)this.myElement, vFile)) != null && imports.contains(qName)) {
                    rate += 70;
                }
            }
        }
        if (this.myElement.getParent() instanceof PyCallExpression) {
            if (target2 instanceof PyFunction) {
                rate += 50;
            }
        } else if (!(target2 instanceof PyFunction)) {
            rate += 50;
        }
        return rate;
    }

    private static boolean canQualifyAnImplicitName(@NotNull PyExpression qualifier) {
        PsiElement target2;
        PyExpression callee;
        if (qualifier == null) {
            PyQualifiedReference.$$$reportNull$$$0(8);
        }
        return !(qualifier instanceof PyCallExpression) || !((callee = ((PyCallExpression)qualifier).getCallee()) instanceof PyReferenceExpression) || !"super".equals(callee.getName()) || (target2 = ((PyReferenceExpression)callee).getReference().resolve()) == null || !PyBuiltinCache.getInstance((PsiElement)qualifier).isBuiltin(target2);
    }

    private static boolean addAssignedAttributes(ResolveResultList ret, String referencedName, @NotNull PyQualifiedExpression qualifier) {
        QualifiedName qName;
        if (qualifier == null) {
            PyQualifiedReference.$$$reportNull$$$0(9);
        }
        if ((qName = qualifier.asQualifiedName()) == null) {
            return false;
        }
        for (PyExpression pyExpression : PyQualifiedReference.collectAssignedAttributes(qName, (PsiElement)qualifier)) {
            if (!referencedName.equals(pyExpression.getName())) continue;
            ret.poke((PsiElement)pyExpression, 0);
            return true;
        }
        return false;
    }

    private void addDocReference(ResolveResultList ret, PyExpression qualifier, PyType qualifierType) {
        PsiElement qual_object;
        PyStringLiteralExpression docstring = null;
        if (qualifierType instanceof PyClassType) {
            PyClass qualClass = ((PyClassType)qualifierType).getPyClass();
            docstring = qualClass.getDocStringExpression();
        } else if (qualifierType instanceof PyModuleType) {
            PyFile qualModule = ((PyModuleType)qualifierType).getModule();
            docstring = qualModule.getDocStringExpression();
        } else if (qualifier instanceof PyReferenceExpression && (qual_object = ((PyReferenceExpression)qualifier).getReference(this.myContext).resolve()) instanceof PyDocStringOwner) {
            docstring = ((PyDocStringOwner)qual_object).getDocStringExpression();
        }
        ret.poke(docstring, 1000);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        PyExpression qualifier = this.myElement.getQualifier();
        if (qualifier != null) {
            qualifier = CompletionUtil.getOriginalOrSelf(qualifier);
        }
        if (qualifier == null) {
            if (EMPTY_ARRAY == null) {
                PyQualifiedReference.$$$reportNull$$$0(10);
            }
            return EMPTY_ARRAY;
        }
        PyQualifiedExpression element = CompletionUtil.getOriginalOrSelf(this.myElement);
        PyType qualifierType = TypeEvalContext.codeCompletion(element.getProject(), element.getContainingFile()).getType(qualifier);
        ProcessingContext ctx = new ProcessingContext();
        HashSet<String> namesAlready = new HashSet<String>();
        ctx.put(PyType.CTX_NAMES, namesAlready);
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
        if (qualifierType != null) {
            PyClassType guessedType;
            Collections.addAll(variants, this.getVariantFromHasAttr(qualifier));
            if (qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages() && (guessedType = this.guessClassTypeByName()) != null) {
                Collections.addAll(variants, PyQualifiedReference.getTypeCompletionVariants(this.myElement, guessedType));
            }
            if (qualifier instanceof PyQualifiedExpression) {
                PyQualifiedExpression qualifierExpression = (PyQualifiedExpression)qualifier;
                QualifiedName qualifiedName = qualifierExpression.asQualifiedName();
                if (qualifiedName != null) {
                    Collection<PyTargetExpression> attrs = PyQualifiedReference.collectAssignedAttributes(qualifiedName, (PsiElement)qualifier);
                    for (PyTargetExpression expression : attrs) {
                        String name = expression.getName();
                        if (name != null && name.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || !(qualifierType instanceof PyClassType) || name == null) continue;
                        variants.add(LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)expression).withTypeText(qualifierType.getName()).withIcon(PlatformIcons.FIELD_ICON));
                        namesAlready.add(name);
                    }
                }
                Collections.addAll(variants, qualifierType.getCompletionVariants(element.getName(), (PsiElement)element, ctx));
                Object[] objectArray = variants.toArray();
                if (objectArray == null) {
                    PyQualifiedReference.$$$reportNull$$$0(11);
                }
                return objectArray;
            }
            Object[] objectArray = qualifierType.getCompletionVariants(element.getName(), (PsiElement)element, ctx);
            if (objectArray == null) {
                PyQualifiedReference.$$$reportNull$$$0(12);
            }
            return objectArray;
        }
        PyClassType guessedType = this.guessClassTypeByName();
        if (guessedType != null) {
            Collections.addAll(variants, PyQualifiedReference.getTypeCompletionVariants(this.myElement, guessedType));
        }
        if (qualifier instanceof PyReferenceExpression) {
            Collections.addAll(variants, this.collectSeenMembers(qualifier.getText()));
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            PyQualifiedReference.$$$reportNull$$$0(13);
        }
        return objectArray;
    }

    private Object[] getVariantFromHasAttr(PyExpression qualifier) {
        ArrayList<String> variants = new ArrayList<String>();
        PyIfStatement ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyIfStatement.class);
        while (ifStatement != null) {
            PyStringLiteralExpression string;
            PyCallExpression call;
            PyExpression condition = ifStatement.getIfPart().getCondition();
            if (condition instanceof PyCallExpression && ((PyCallExpression)condition).isCalleeText("hasattr") && (call = (PyCallExpression)condition).getArguments().length > 1 && call.getArguments()[0].getText().equals(qualifier.getText()) && (string = call.getArgument(1, PyStringLiteralExpression.class)) != null && StringUtil.isJavaIdentifier((String)string.getStringValue())) {
                variants.add(string.getStringValue());
            }
            ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PyIfStatement.class);
        }
        return variants.toArray();
    }

    @Nullable
    private PyClassType guessClassTypeByName() {
        PyReferenceExpression qualifier;
        String className;
        PyExpression qualifierElement = this.myElement.getQualifier();
        if (qualifierElement instanceof PyReferenceExpression && (className = (qualifier = (PyReferenceExpression)qualifierElement).getReferencedName()) != null) {
            Collection<PyClass> classes = PyClassNameIndexInsensitive.find(className, this.getElement().getProject());
            if ((classes = PyQualifiedReference.filterByImports(classes, this.myElement.getContainingFile())).size() == 1) {
                return new PyClassTypeImpl(classes.iterator().next(), false);
            }
        }
        return null;
    }

    private static Collection<PyClass> filterByImports(Collection<PyClass> classes, PsiFile containingFile) {
        if (classes.size() <= 1) {
            return classes;
        }
        ArrayList<PyClass> result2 = new ArrayList<PyClass>();
        for (PyClass pyClass : classes) {
            if (pyClass.getContainingFile() == containingFile) {
                result2.add(pyClass);
                continue;
            }
            PsiElement exportedClass = ((PyFile)containingFile).getElementNamed(pyClass.getName());
            if (exportedClass != pyClass) continue;
            result2.add(pyClass);
        }
        return result2;
    }

    private Object[] collectSeenMembers(final String text2) {
        final HashSet members = new HashSet();
        this.myElement.getContainingFile().accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                this.visitPyQualifiedExpression(node);
            }

            @Override
            public void visitPyTargetExpression(PyTargetExpression node) {
                super.visitPyTargetExpression(node);
                this.visitPyQualifiedExpression(node);
            }

            private void visitPyQualifiedExpression(PyQualifiedExpression node) {
                String refName;
                PyExpression qualifier;
                if (node != PyQualifiedReference.this.myElement && (qualifier = node.getQualifier()) != null && qualifier.getText().equals(text2) && (refName = node.getReferencedName()) != null) {
                    members.add(refName);
                }
            }
        });
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(members.size());
        for (String member : members) {
            results.add(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)LookupElementBuilder.create((String)member)));
        }
        return ArrayUtil.toObjectArray(results);
    }

    @NotNull
    public static Collection<PyTargetExpression> collectAssignedAttributes(@NotNull QualifiedName qualifierQName, @NotNull PsiElement anchor2) {
        if (qualifierQName == null) {
            PyQualifiedReference.$$$reportNull$$$0(14);
        }
        if (anchor2 == null) {
            PyQualifiedReference.$$$reportNull$$$0(15);
        }
        HashSet<String> names = new HashSet<String>();
        ArrayList<PyTargetExpression> results = new ArrayList<PyTargetExpression>();
        ScopeOwner owner = ScopeUtil.getScopeOwner(anchor2);
        while (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            for (PyTargetExpression target2 : scope.getTargetExpressions()) {
                String name;
                QualifiedName targetQName = target2.asQualifiedName();
                if (targetQName == null || targetQName.getComponentCount() != qualifierQName.getComponentCount() + 1 || !targetQName.matchesPrefix(qualifierQName) || names.contains(name = target2.getName())) continue;
                names.add(name);
                results.add(target2);
            }
            owner = ScopeUtil.getScopeOwner((PsiElement)owner);
        }
        ArrayList<PyTargetExpression> arrayList = results;
        if (arrayList == null) {
            PyQualifiedReference.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        PyType qualifierType;
        PyExpression qualifier;
        if (PyQualifiedReference.isLocalScope(element)) {
            return false;
        }
        String referencedName = this.myElement.getReferencedName();
        PyResolveContext resolveContext = this.myContext.withoutImplicits();
        if (resolveContext.getTypeEvalContext().getOrigin() == null) {
            PsiFile containingFile = this.myElement.getContainingFile();
            if (containingFile instanceof StubBasedPsiElement) assert (((StubBasedPsiElement)containingFile).getStub() == null) : "Stub origin for type eval context in isReferenceTo()";
            TypeEvalContext context = TypeEvalContext.codeAnalysis(containingFile.getProject(), containingFile);
            resolveContext = resolveContext.withTypeEvalContext(context);
        }
        if (element instanceof PyFunction && Comparing.equal((String)referencedName, (String)((PyFunction)element).getName()) && ((PyFunction)element).getContainingClass() != null && !"__init__".equals(referencedName) && (qualifier = this.myElement.getQualifier()) != null && ((qualifierType = resolveContext.getTypeEvalContext().getType(qualifier)) == null || qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages())) {
            return true;
        }
        for (ResolveResult result2 : this.copyWithResolveContext(resolveContext).multiResolve(false)) {
            LOG.assertTrue(!(result2 instanceof ImplicitResolveResult));
            PsiElement resolveResult = result2.getElement();
            if (!this.isResolvedToResult(element, resolveResult)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected PyQualifiedReference copyWithResolveContext(PyResolveContext context) {
        PyQualifiedReference pyQualifiedReference = new PyQualifiedReference(this.myElement, context);
        if (pyQualifiedReference == null) {
            PyQualifiedReference.$$$reportNull$$$0(17);
        }
        return pyQualifiedReference;
    }

    private boolean isResolvedToResult(PsiElement element, PsiElement resolveResult) {
        if (resolveResult instanceof PyImportedModule) {
            resolveResult = resolveResult.getNavigationElement();
        }
        if (element instanceof PsiDirectory && resolveResult instanceof PyFile && "__init__.py".equals(((PyFile)resolveResult).getName()) && ((PyFile)resolveResult).getContainingDirectory() == element) {
            return true;
        }
        if (resolveResult == element) {
            return true;
        }
        if (resolveResult instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)resolveResult) && element instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)element) && Comparing.equal((String)((PyTargetExpression)resolveResult).getReferencedName(), (String)((PyTargetExpression)element).getReferencedName())) {
            PyClass aClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)resolveResult, PyClass.class);
            PyClass bClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
            if (aClass != null && bClass != null && bClass.isSubclass(aClass, this.myContext.getTypeEvalContext())) {
                return true;
            }
        }
        return this.resolvesToWrapper(element, resolveResult);
    }

    private static boolean isLocalScope(PsiElement element) {
        if (element instanceof PyParameter) {
            return true;
        }
        if (element instanceof PyTargetExpression) {
            PyTargetExpression target2 = (PyTargetExpression)element;
            return !target2.isQualified() && ScopeUtil.getScopeOwner(target2) instanceof PyFunction;
        }
        return false;
    }

    public String toString() {
        return "PyQualifiedReference(" + this.myElement + "," + this.myContext + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyQualifiedReference";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierQName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyQualifiedReference";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignedAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithResolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOtherClassQualifying";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canQualifyAnImplicitName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAssignedAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignedAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

