/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyResolveProcessor
implements PsiScopeProcessor {
    @NotNull
    private final String myName;
    private final boolean myLocalResolve;
    @NotNull
    private final Map<PsiElement, PyImportedNameDefiner> myResults;
    @NotNull
    private final Map<PsiElement, PyImportedNameDefiner> myImplicitlyImportedResults;
    @Nullable
    private ScopeOwner myOwner;

    public PyResolveProcessor(@NotNull String name) {
        if (name == null) {
            PyResolveProcessor.$$$reportNull$$$0(0);
        }
        this(name, false);
    }

    public PyResolveProcessor(@NotNull String name, boolean localResolve) {
        if (name == null) {
            PyResolveProcessor.$$$reportNull$$$0(1);
        }
        this.myResults = Maps.newLinkedHashMap();
        this.myImplicitlyImportedResults = Maps.newLinkedHashMap();
        this.myName = name;
        this.myLocalResolve = localResolve;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        PsiNamedElement namedElement;
        if (element == null) {
            PyResolveProcessor.$$$reportNull$$$0(2);
        }
        if (state2 == null) {
            PyResolveProcessor.$$$reportNull$$$0(3);
        }
        if ((namedElement = PyUtil.as(element, PsiNamedElement.class)) != null && this.myName.equals(namedElement.getName())) {
            return this.tryAddResult(element, null);
        }
        PyImportedNameDefiner importedNameDefiner = PyUtil.as(element, PyImportedNameDefiner.class);
        if (importedNameDefiner != null) {
            String importName;
            List<RatedResolveResult> results = this.resolveInImportedNameDefiner(importedNameDefiner);
            if (!results.isEmpty()) {
                boolean cont = true;
                for (RatedResolveResult result2 : results) {
                    PsiElement resolved = result2.getElement();
                    if (resolved == null) continue;
                    cont = this.tryAddResult(resolved, importedNameDefiner) && cont;
                }
                return cont;
            }
            PyImportElement importElement = PyUtil.as(element, PyImportElement.class);
            if (importElement != null && this.myName.equals(importName = importElement.getVisibleName())) {
                return this.tryAddResult(null, importElement);
            }
        }
        return this.myOwner == null || this.myOwner == ScopeUtil.getScopeOwner(element);
    }

    @NotNull
    public Map<PsiElement, PyImportedNameDefiner> getResults() {
        Map<PsiElement, PyImportedNameDefiner> map2 = this.myResults.isEmpty() ? this.myImplicitlyImportedResults : this.myResults;
        if (map2 == null) {
            PyResolveProcessor.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    public Collection<PsiElement> getElements() {
        Set<PsiElement> set2 = this.getResults().keySet();
        if (set2 == null) {
            PyResolveProcessor.$$$reportNull$$$0(5);
        }
        return set2;
    }

    @Nullable
    public ScopeOwner getOwner() {
        return this.myOwner;
    }

    @NotNull
    private List<RatedResolveResult> resolveInImportedNameDefiner(@NotNull PyImportedNameDefiner definer) {
        if (definer == null) {
            PyResolveProcessor.$$$reportNull$$$0(6);
        }
        if (this.myLocalResolve) {
            PyImportElement importElement = PyUtil.as(definer, PyImportElement.class);
            if (importElement != null) {
                List<RatedResolveResult> list2 = ResolveResultList.to(importElement.getElementNamed(this.myName, false));
                if (list2 == null) {
                    PyResolveProcessor.$$$reportNull$$$0(7);
                }
                return list2;
            }
            List<RatedResolveResult> list3 = Collections.emptyList();
            if (list3 == null) {
                PyResolveProcessor.$$$reportNull$$$0(8);
            }
            return list3;
        }
        List<RatedResolveResult> list4 = definer.multiResolveName(this.myName);
        if (list4 == null) {
            PyResolveProcessor.$$$reportNull$$$0(9);
        }
        return list4;
    }

    private boolean tryAddResult(@Nullable PsiElement element, @Nullable PyImportedNameDefiner definer) {
        boolean sameScope;
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)(definer != null ? definer : element));
        if (this.myOwner == null) {
            this.myOwner = owner;
        }
        boolean bl = sameScope = owner == this.myOwner;
        if (sameScope) {
            if (definer instanceof PyFromImportStatement) {
                this.myImplicitlyImportedResults.put(element, definer);
            } else {
                this.myResults.put(element, definer);
            }
        }
        return sameScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PyResolveProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PyResolveProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInImportedNameDefiner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveInImportedNameDefiner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

