/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkType;

public class PythonModulePathCache
extends PythonPathCache
implements Disposable {
    public static PythonPathCache getInstance(Module module2) {
        return (PythonPathCache)ModuleServiceManager.getService((Module)module2, PythonPathCache.class);
    }

    public PythonModulePathCache(final Module module2) {
        MessageBusConnection connection = module2.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                PythonModulePathCache.updateCacheForSdk(module2);
                PythonModulePathCache.this.clearCache();
            }
        });
        connection.subscribe(PyPackageManager.PACKAGE_MANAGER_TOPIC, sdk -> {
            Sdk moduleSdk = PythonSdkType.findPythonSdk(module2);
            if (sdk == moduleSdk) {
                PythonModulePathCache.updateCacheForSdk(module2);
                this.clearCache();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PythonPathCache.MyVirtualFileListener(this), (Disposable)this);
        PythonModulePathCache.updateCacheForSdk(module2);
    }

    private static void updateCacheForSdk(Module module2) {
        Sdk sdk = PythonSdkType.findPythonSdk(module2);
        if (sdk != null) {
            PythonSdkPathCache.getInstance(module2.getProject(), sdk);
        }
    }

    public void dispose() {
    }
}

