/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonTestRunConfiguration<T extends AbstractPythonTestRunConfiguration<T>>
extends AbstractPythonRunConfiguration<T> {
    protected static final String TEST_NAME_PARTS_SPLITTER = "::";

    protected AbstractPythonTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Nullable
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        if (location == null) {
            AbstractPythonTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (failedTest == null) {
            AbstractPythonTestRunConfiguration.$$$reportNull$$$0(1);
        }
        PsiElement element = location.getPsiElement();
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (location instanceof PyPsiLocationWithFixedClass) {
            pyClass = ((PyPsiLocationWithFixedClass)location).getFixedClass();
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        VirtualFile virtualFile = location.getVirtualFile();
        if (virtualFile != null) {
            String path = virtualFile.getCanonicalPath();
            if (pyClass != null) {
                path = path + TEST_NAME_PARTS_SPLITTER + pyClass.getName();
            }
            if (pyFunction != null) {
                path = path + TEST_NAME_PARTS_SPLITTER + pyFunction.getName();
            }
            return path;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "failedTest";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration";
        objectArray[2] = "getTestSpec";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

