/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytestLegacy;

import com.google.common.collect.Lists;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.PyTestFrameworkService;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestLegacyConfigurationProducer;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import com.jetbrains.python.testing.pytestLegacy.PyTestRunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTestConfigurationProducer
extends PythonTestLegacyConfigurationProducer<PyTestRunConfiguration> {
    public PyTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().LEGACY_PYTEST_FACTORY);
    }

    @Override
    protected boolean setupConfigurationFromContext(AbstractPythonLegacyTestRunConfiguration<PyTestRunConfiguration> configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiDirectory file2;
        PsiElement element = (PsiElement)sourceElement.get();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (!(configuration instanceof PyTestRunConfiguration)) {
            return false;
        }
        if (module2 == null) {
            return false;
        }
        if (!TestRunnerService.getInstance(module2).getProjectConfiguration().equals(PyTestFrameworkService.getSdkReadableNameByFramework("pytest"))) {
            return false;
        }
        Object object = file2 = element instanceof PsiDirectory ? (PsiDirectory)element : element.getContainingFile();
        if (file2 == null) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file2 instanceof PyFile || file2 instanceof PsiDirectory) {
            List<PyStatement> testCases = PyTestConfigurationProducer.getPyTestCasesFromFile((PsiFileSystemItem)file2, TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()));
            if (testCases.isEmpty()) {
                return false;
            }
        } else {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(context.getModule());
        if (sdk == null) {
            return false;
        }
        configuration.setUseModuleSdk(true);
        configuration.setModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        ((PyTestRunConfiguration)configuration).setTestToRun(virtualFile.getPath());
        String keywords = PyTestConfigurationProducer.getKeywords(element, sdk);
        if (keywords != null) {
            ((PyTestRunConfiguration)configuration).useKeyword(true);
            ((PyTestRunConfiguration)configuration).setKeywords(keywords);
            configuration.setName("pytest in " + keywords);
        } else {
            configuration.setName("pytest in " + file2.getName());
        }
        return true;
    }

    @Nullable
    private static String getKeywords(@NotNull PsiElement element, @NotNull Sdk sdk) {
        if (element == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(1);
        }
        PyFunction pyFunction = PyTestConfigurationProducer.findTestFunction(element);
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        String keywords = null;
        if (pyFunction != null) {
            keywords = pyFunction.getName();
            if (pyClass != null) {
                PyPackage pytestPackage;
                List<PyPackage> packages = PyPackageManager.getInstance(sdk).getPackages();
                PyPackage pyPackage = pytestPackage = packages != null ? PyPackageUtil.findPackage(packages, "pytest") : null;
                keywords = pytestPackage != null && PyPackageVersionComparator.getSTR_COMPARATOR().compare(pytestPackage.getVersion(), "2.3.3") >= 0 ? pyClass.getName() + " and " + keywords : pyClass.getName() + "." + keywords;
            }
        } else if (pyClass != null) {
            keywords = pyClass.getName();
        }
        return keywords;
    }

    @Nullable
    private static PyFunction findTestFunction(PsiElement element) {
        String name;
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null && (name = function.getName()) != null && name.startsWith("test")) {
            return function;
        }
        return null;
    }

    @Override
    public boolean isConfigurationFromContext(AbstractPythonLegacyTestRunConfiguration configuration, ConfigurationContext context) {
        PsiDirectory file2;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        if (!(configuration instanceof PyTestRunConfiguration)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        Object object = file2 = element instanceof PsiDirectory ? (PsiDirectory)element : element.getContainingFile();
        if (file2 == null) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file2 instanceof PyFile || file2 instanceof PsiDirectory) {
            List<PyStatement> testCases = PyTestConfigurationProducer.getPyTestCasesFromFile((PsiFileSystemItem)file2, TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()));
            if (testCases.isEmpty()) {
                return false;
            }
        } else {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(context.getModule());
        if (sdk == null) {
            return false;
        }
        String keywords = PyTestConfigurationProducer.getKeywords(element, sdk);
        String scriptName = ((PyTestRunConfiguration)configuration).getTestToRun();
        String workingDirectory = configuration.getWorkingDirectory();
        String path = virtualFile.getPath();
        boolean isTestFileEquals = scriptName.equals(path) || path.equals(new File(workingDirectory, scriptName).getAbsolutePath());
        String configurationKeywords = ((PyTestRunConfiguration)configuration).getKeywords();
        return isTestFileEquals && (configurationKeywords.equals(keywords) || StringUtil.isEmptyOrSpaces((String)((PyTestRunConfiguration)configuration).getKeywords()) && keywords == null);
    }

    public static List<PyStatement> getPyTestCasesFromFile(PsiFileSystemItem file2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(2);
        }
        List<Object> result2 = Lists.newArrayList();
        if (file2 instanceof PyFile) {
            result2 = PyTestConfigurationProducer.getResult((PyFile)file2, context);
        } else if (file2 instanceof PsiDirectory) {
            for (PsiFile f : ((PsiDirectory)file2).getFiles()) {
                if (!(f instanceof PyFile)) continue;
                result2.addAll(PyTestConfigurationProducer.getResult((PyFile)f, context));
            }
        }
        return result2;
    }

    private static List<PyStatement> getResult(PyFile file2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(3);
        }
        ArrayList result2 = Lists.newArrayList();
        for (PyClass pyClass : file2.getTopLevelClasses()) {
            if (!PyTestUtil.isPyTestClass(pyClass, context)) continue;
            result2.add(pyClass);
        }
        for (PyFunction pyFunction : file2.getTopLevelFunctions()) {
            if (!PyTestUtil.isPyTestFunction(pyFunction)) continue;
            result2.add(pyFunction);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/testing/pytestLegacy/PyTestConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeywords";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPyTestCasesFromFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

