/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.validation.PyAnnotator;

public class TryExceptAnnotator
extends PyAnnotator {
    @Override
    public void visitPyTryExceptStatement(PyTryExceptStatement node) {
        PyExceptPart[] exceptParts = node.getExceptParts();
        boolean haveDefaultExcept = false;
        for (PyExceptPart part : exceptParts) {
            if (haveDefaultExcept) {
                this.getHolder().createErrorAnnotation((PsiElement)part, PyBundle.message("ANN.default.except.must.be.last", new Object[0]));
            }
            if (part.getExceptClass() != null) continue;
            haveDefaultExcept = true;
        }
    }

    @Override
    public void visitPyRaiseStatement(PyRaiseStatement node) {
        if (node.getExpressions().length == 0 && PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{PyExceptPart.class, PyFinallyPart.class}) == null) {
            this.markError((PsiElement)node, "No exception to reraise");
        }
    }
}

