/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import com.pty4j.unix.PtyHelpers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jtermios.JTermios;

public class UnixPtyProcess
extends PtyProcess {
    public int NOOP = 0;
    public int SIGHUP = 1;
    public int SIGINT = 2;
    public int SIGKILL = 9;
    public int SIGTERM = 15;
    public int ENOTTY = 25;
    public int INT = 2;
    public int CTRLC = 1000;
    private static final int SIGWINCH = 28;
    private int pid = 0;
    private int myStatus;
    private boolean isDone;
    private OutputStream out;
    private InputStream in;
    private InputStream err;
    private Pty myPty;
    private Pty myErrPty;

    public UnixPtyProcess(String[] cmdarray, String[] envp, String dir, Pty pty, Pty errPty) throws IOException {
        if (dir == null) {
            dir = ".";
        }
        if (pty == null) {
            throw new IOException("pty cannot be null");
        }
        this.myPty = pty;
        this.myErrPty = errPty;
        this.execInPty(cmdarray, envp, dir, pty, errPty);
    }

    public Pty getPty() {
        return this.myPty;
    }

    protected void finalize() throws Throwable {
        this.closeUnusedStreams();
        super.finalize();
    }

    public synchronized InputStream getInputStream() {
        if (null == this.in) {
            this.in = this.myPty.getInputStream();
        }
        return this.in;
    }

    public synchronized OutputStream getOutputStream() {
        if (null == this.out) {
            this.out = this.myPty.getOutputStream();
        }
        return this.out;
    }

    public synchronized InputStream getErrorStream() {
        if (null == this.err) {
            this.err = !this.myPty.isConsole() ? new InputStream(){

                public int read() {
                    return -1;
                }
            } : this.myErrPty.getInputStream();
        }
        return this.err;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        return this.myStatus;
    }

    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.myStatus;
    }

    public synchronized void destroy() {
        this.terminate();
        this.closeUnusedStreams();
        if (!this.isDone) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isDone) {
            this.kill();
        }
    }

    public int interrupt() {
        return Pty.raise(this.pid, this.INT);
    }

    public int interruptCTRLC() {
        return this.interrupt();
    }

    public int hangup() {
        return Pty.raise(this.pid, this.SIGHUP);
    }

    public int kill() {
        return Pty.raise(this.pid, this.SIGKILL);
    }

    public int terminate() {
        return Pty.raise(this.pid, this.SIGTERM);
    }

    public boolean isRunning() {
        return Pty.raise(this.pid, this.NOOP) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execInPty(String[] command, String[] environment, String workingDirectory, Pty pty, Pty errPty) throws IOException {
        String cmd = command[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(cmd);
        }
        if (environment == null) {
            environment = new String[]{};
        }
        String slaveName = pty.getSlaveName();
        int masterFD = pty.getMasterFD();
        String errSlaveName = errPty == null ? null : errPty.getSlaveName();
        int errMasterFD = errPty == null ? -1 : errPty.getMasterFD();
        boolean console = pty.isConsole();
        Reaper reaper = new Reaper(command, environment, workingDirectory, slaveName, masterFD, errSlaveName, errMasterFD, console);
        reaper.setDaemon(true);
        reaper.start();
        UnixPtyProcess unixPtyProcess = this;
        synchronized (unixPtyProcess) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean init = Boolean.getBoolean("unix.pty.init");
            if (init) {
                int cols = Integer.getInteger("unix.pty.cols", 80);
                int rows = Integer.getInteger("unix.pty.rows", 25);
                WinSize size = new WinSize(cols, rows);
                boolean retry = true;
                for (int attempt = 0; attempt < 1000 && retry; ++attempt) {
                    retry = false;
                    try {
                        this.myPty.setTerminalSize(size);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        if (JTermios.errno() != this.ENOTTY) continue;
                        retry = true;
                    }
                }
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec_tty error:" + reaper.getErrorMessage());
        }
    }

    private synchronized void closeUnusedStreams() {
        try {
            if (null == this.err) {
                this.getErrorStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (null == this.in) {
                this.getInputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (null == this.out) {
                this.getOutputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int exec(String[] cmd, String[] envp, String dirname, String slaveName, int masterFD, String errSlaveName, int errMasterFD, boolean console) throws IOException {
        int pid = -1;
        if (cmd == null) {
            return pid;
        }
        if (envp == null) {
            return pid;
        }
        return PtyHelpers.execPty(cmd[0], cmd, envp, dirname, slaveName, masterFD, errSlaveName, errMasterFD, console);
    }

    int waitFor(int processID) {
        return Pty.wait0(processID);
    }

    public void setWinSize(WinSize winSize) {
        this.myPty.setTerminalSize(winSize);
        if (this.myErrPty != null) {
            this.myErrPty.setTerminalSize(winSize);
        }
        Pty.raise(this.pid, 28);
    }

    public WinSize getWinSize() throws IOException {
        return this.myPty.getWinSize();
    }

    public int getPid() {
        return this.pid;
    }

    class Reaper
    extends Thread {
        private String[] myCommand;
        private String[] myEnv;
        private String myDir;
        private String mySlaveName;
        private int myMasterFD;
        private String myErrSlaveName;
        private int myErrMasterFD;
        private boolean myConsole;
        volatile Throwable myException;

        public Reaper(String[] command, String[] environment, String workingDirectory, String slaveName, int masterFD, String errSlaveName, int errMasterFD, boolean console) {
            super("PtyProcess Reaper for " + Arrays.toString(command));
            this.myCommand = command;
            this.myEnv = environment;
            this.myDir = workingDirectory;
            this.mySlaveName = slaveName;
            this.myMasterFD = masterFD;
            this.myErrSlaveName = errSlaveName;
            this.myErrMasterFD = errMasterFD;
            this.myConsole = console;
            this.myException = null;
        }

        int execute(String[] cmd, String[] env, String dir) throws IOException {
            return UnixPtyProcess.this.exec(cmd, env, dir, this.mySlaveName, this.myMasterFD, this.myErrSlaveName, this.myErrMasterFD, this.myConsole);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                UnixPtyProcess.this.pid = this.execute(this.myCommand, this.myEnv, this.myDir);
            }
            catch (Exception e) {
                UnixPtyProcess.this.pid = -1;
                this.myException = e;
            }
            UnixPtyProcess unixPtyProcess = UnixPtyProcess.this;
            synchronized (unixPtyProcess) {
                UnixPtyProcess.this.notifyAll();
            }
            if (UnixPtyProcess.this.pid != -1) {
                UnixPtyProcess.this.myStatus = UnixPtyProcess.this.waitFor(UnixPtyProcess.this.pid);
                unixPtyProcess = UnixPtyProcess.this;
                synchronized (unixPtyProcess) {
                    UnixPtyProcess.this.isDone = true;
                    UnixPtyProcess.this.notifyAll();
                }
                UnixPtyProcess.this.myPty.breakRead();
                if (UnixPtyProcess.this.myErrPty != null) {
                    UnixPtyProcess.this.myErrPty.breakRead();
                }
            }
        }

        public String getErrorMessage() {
            return this.myException != null ? this.myException.getMessage() : "Unknown reason";
        }
    }
}

