/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.PtyException;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.windows.WinPTYInputStream;
import com.pty4j.windows.WinPTYOutputStream;
import com.pty4j.windows.WinPty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WinPtyProcess
extends PtyProcess {
    private final WinPty myWinPty;
    private final WinPTYInputStream myInputStream;
    private final InputStream myErrorStream;
    private final WinPTYOutputStream myOutputStream;
    private boolean myUsedInputStream = false;
    private boolean myUsedOutputStream = false;
    private boolean myUsedErrorStream = false;

    @Deprecated
    public WinPtyProcess(String[] command, String[] environment, String workingDirectory, boolean consoleMode) throws IOException {
        this(command, WinPtyProcess.convertEnvironment(environment), workingDirectory, consoleMode);
    }

    private static String convertEnvironment(String[] environment) {
        StringBuilder envString = new StringBuilder();
        for (String s : environment) {
            envString.append(s).append('\u0000');
        }
        envString.append('\u0000');
        return envString.toString();
    }

    public WinPtyProcess(String[] command, String environment, String workingDirectory, boolean consoleMode) throws IOException {
        try {
            this.myWinPty = new WinPty(WinPtyProcess.joinCmdArgs(command), workingDirectory, environment, consoleMode);
        }
        catch (PtyException e) {
            throw new IOException("Couldn't create PTY", e);
        }
        this.myInputStream = new WinPTYInputStream(this.myWinPty, this.myWinPty.getInputPipe());
        this.myOutputStream = new WinPTYOutputStream(this.myWinPty, this.myWinPty.getOutputPipe(), consoleMode, true);
        this.myErrorStream = !consoleMode ? new InputStream(){

            public int read() {
                return -1;
            }
        } : new WinPTYInputStream(this.myWinPty, this.myWinPty.getErrorPipe());
    }

    static String joinCmdArgs(String[] commands) {
        StringBuilder cmd = new StringBuilder();
        boolean flag = false;
        for (String s : commands) {
            if (flag) {
                cmd.append(' ');
            } else {
                flag = true;
            }
            if (s.indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                if (s.charAt(0) != '\"') {
                    cmd.append('\"').append(s);
                    if (s.endsWith("\\")) {
                        cmd.append("\\");
                    }
                    cmd.append('\"');
                    continue;
                }
                cmd.append(s);
                continue;
            }
            cmd.append(s);
        }
        return cmd.toString();
    }

    public boolean isRunning() {
        return this.myWinPty.isRunning();
    }

    public void setWinSize(WinSize winSize) {
        this.myWinPty.setWinSize(winSize);
    }

    public WinSize getWinSize() throws IOException {
        return null;
    }

    public int getPid() {
        return this.myWinPty.getChildProcessId();
    }

    public synchronized OutputStream getOutputStream() {
        this.myUsedOutputStream = true;
        return this.myOutputStream;
    }

    public synchronized InputStream getInputStream() {
        this.myUsedInputStream = true;
        return this.myInputStream;
    }

    public synchronized InputStream getErrorStream() {
        this.myUsedErrorStream = true;
        return this.myErrorStream;
    }

    public int waitFor() throws InterruptedException {
        return this.myWinPty.waitFor();
    }

    public int getChildProcessId() {
        return this.myWinPty.getChildProcessId();
    }

    public int exitValue() {
        return this.myWinPty.exitValue();
    }

    public synchronized void destroy() {
        this.myWinPty.close();
        if (!this.myUsedInputStream) {
            try {
                this.myInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.myUsedOutputStream) {
            try {
                this.myOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.myUsedErrorStream) {
            try {
                this.myErrorStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

