/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Url;

public class CMapData {
    private final StringBuilder stringBuilder = new StringBuilder();

    public String asString(String nameId) {
        return "<map id=\"" + nameId + "_map\" name=\"" + nameId + "_map\">\n" + this.stringBuilder.toString() + "</map>\n";
    }

    public boolean containsData() {
        return this.stringBuilder.length() > 0;
    }

    public void appendString(String s) {
        this.stringBuilder.append(s);
    }

    public void appendLong(long s) {
        this.stringBuilder.append(s);
    }

    public void appendUrl(int seq, Url url, double scale) {
        this.appendString("<area shape=\"rect\" id=\"id");
        this.appendLong(seq);
        this.appendString("\" href=\"");
        this.appendString(url.getUrl());
        this.appendString("\" title=\"");
        String tooltip = url.getTooltip().replaceAll("\\\\n", "\n").replaceAll("&", "&#38;").replaceAll("\"", "&#34;").replaceAll("'", "&#39;");
        this.appendString(tooltip);
        this.appendString("\" alt=\"\" coords=\"");
        this.appendString(url.getCoords(scale));
        this.appendString("\"/>");
        this.appendString("\n");
    }

    public static CMapData cmapString(Set<Url> allUrlEncountered, double scale) {
        CMapData cmapdata = new CMapData();
        ArrayList<Url> all = new ArrayList<Url>(allUrlEncountered);
        Collections.sort(all, Url.SURFACE_COMPARATOR);
        int seq = 1;
        for (Url u : all) {
            cmapdata.appendUrl(seq, u, scale);
            ++seq;
        }
        return cmapdata;
    }
}

