/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileAssemblySimple
extends AbstractTextBlock
implements Ftile {
    private final Ftile tile1;
    private final Ftile tile2;
    private FtileGeometry calculateDimension;

    public String toString() {
        return "FtileAssemblySimple " + this.tile1 + " && " + this.tile2;
    }

    public FtileAssemblySimple(Ftile tile1, Ftile tile2) {
        this.tile1 = tile1;
        this.tile2 = tile2;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile2.getSwimlaneOut();
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile1) {
            return this.getTranslated1(stringBounder);
        }
        if (child == this.tile2) {
            return this.getTranslated2(stringBounder);
        }
        UTranslate tmp = this.tile1.getTranslateFor(child, stringBounder);
        if (tmp != null) {
            return tmp.compose(this.getTranslated1(stringBounder));
        }
        tmp = this.tile2.getTranslateFor(child, stringBounder);
        if (tmp != null) {
            return tmp.compose(this.getTranslated2(stringBounder));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslated1(stringBounder)).draw(this.tile1);
        ug.apply(this.getTranslated2(stringBounder)).draw(this.tile2);
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile1.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return LinkRendering.none();
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimension == null) {
            this.calculateDimension = this.tile1.calculateDimension(stringBounder).appendBottom(this.tile2.calculateDimension(stringBounder));
        }
        return this.calculateDimension;
    }

    private UTranslate getTranslated1(StringBounder stringBounder) {
        double left = this.calculateDimension(stringBounder).getLeft();
        return new UTranslate(left - this.tile1.calculateDimension(stringBounder).getLeft(), 0.0);
    }

    private UTranslate getTranslated2(StringBounder stringBounder) {
        FtileGeometry dim1 = this.tile1.calculateDimension(stringBounder);
        double left = this.calculateDimension(stringBounder).getLeft();
        return new UTranslate(left - this.tile2.calculateDimension(stringBounder).getLeft(), ((Dimension2D)dim1).getHeight());
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        result.addAll(this.tile1.getSwimlanes());
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public ISkinParam skinParam() {
        return this.tile1.skinParam();
    }

    @Override
    public UStroke getThickness() {
        return this.tile1.getThickness();
    }

    @Override
    public List<WeldingPoint> getWeldingPoints() {
        ArrayList<WeldingPoint> result = new ArrayList<WeldingPoint>(this.tile1.getWeldingPoints());
        result.addAll(this.tile2.getWeldingPoints());
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.tile1, this.tile2);
    }

    @Override
    public HorizontalAlignment arrowHorizontalAlignment() {
        return this.tile1.arrowHorizontalAlignment();
    }
}

