/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class CommandPackageEmpty
extends SingleLineCommand<AbstractEntityDiagram> {
    public CommandPackageEmpty() {
        super("(?i)^package[%s]+([%g][^%g]+[%g]|[^#%s{}]*)(?:[%s]+as[%s]+([\\p{L}0-9_.]+))?[%s]*(#[0-9a-fA-F]{6}|#?\\w+)?[%s]*\\{[%s]*\\}$");
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, List<String> arg) {
        String display;
        Code code;
        if (arg.get(1) == null) {
            if (StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get(0)).length() == 0) {
                code = Code.of("##" + UniqueSequence.getValue());
                display = null;
            } else {
                code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get(0)));
                display = code.getFullName();
            }
        } else {
            display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get(0));
            code = Code.of(arg.get(1));
        }
        IGroup currentPackage = diagram.getCurrentGroup();
        IGroup p = diagram.getOrCreateGroup(code, Display.getWithNewlines(display), GroupType.PACKAGE, currentPackage);
        String color = arg.get(2);
        if (color != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(color));
        }
        diagram.endGroup();
        return CommandExecutionResult.ok();
    }
}

