/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UMotif;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class GraphicsPath {
    private final String path;
    private final ColorMapper colorMapper;

    public GraphicsPath(ColorMapper colorMapper, String path2) {
        this.path = path2;
        this.colorMapper = colorMapper;
    }

    public ImageData writeImage(OutputStream os) throws IOException {
        BufferedImage im = this.createImage();
        PngIO.write((RenderedImage)im, os, 96);
        return new ImageDataSimple(im.getWidth(), im.getHeight());
    }

    private BufferedImage createImage() {
        EmptyImageBuilder builder = new EmptyImageBuilder(50, 50, Color.WHITE);
        BufferedImage im = builder.getBufferedImage();
        Graphics2D g2d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(this.colorMapper, g2d, 1.0);
        ug.setBufferedImage(im);
        UMotif motif = new UMotif(this.path);
        motif.drawHorizontal(ug.apply(new UChangeColor(HtmlColorUtils.BLACK)), 20.0, 20.0, 1);
        g2d.dispose();
        return im;
    }
}

