/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public class Dijkstra {
    private final List<Vertex> vertices = new ArrayList<Vertex>();

    public Vertex addVertex(Object data) {
        Vertex v = new Vertex(data);
        this.vertices.add(v);
        return v;
    }

    private void computePaths(Vertex source) {
        source.minDistance = 0.0;
        PriorityQueue<Vertex> vertexQueue = new PriorityQueue<Vertex>();
        vertexQueue.add(source);
        while (!vertexQueue.isEmpty()) {
            Vertex u = (Vertex)vertexQueue.poll();
            for (Edge e : u.adjacencies) {
                Vertex v = e.target;
                double weight = e.weight;
                double distanceThroughU = u.minDistance + weight;
                if (!(distanceThroughU < v.minDistance)) continue;
                vertexQueue.remove(v);
                v.minDistance = distanceThroughU;
                v.previous = u;
                vertexQueue.add(v);
            }
        }
    }

    public List<Vertex> getShortestPathTo(Vertex source, Vertex target) {
        this.computePaths(source);
        ArrayList<Vertex> path2 = new ArrayList<Vertex>();
        Vertex vertex2 = target;
        while (vertex2 != null) {
            path2.add(0, vertex2);
            vertex2 = vertex2.previous;
        }
        return path2;
    }

    static class Edge {
        private final Vertex target;
        private final double weight;

        Edge(Vertex argTarget, double argWeight) {
            this.target = argTarget;
            this.weight = argWeight;
        }
    }

    static class Vertex
    implements Comparable<Vertex> {
        private final Object data;
        private final List<Edge> adjacencies = new ArrayList<Edge>();
        private double minDistance = Double.POSITIVE_INFINITY;
        private Vertex previous;

        Vertex(Object data) {
            this.data = data;
        }

        public void addAdjacencies(Vertex target, double dist) {
            if (target == null) {
                throw new IllegalArgumentException();
            }
            this.adjacencies.add(new Edge(target, dist));
        }

        public String toString() {
            return "[ " + this.data.toString() + " (" + this.minDistance + ") ] ";
        }

        @Override
        public int compareTo(Vertex other) {
            return Double.compare(this.minDistance, other.minDistance);
        }

        public final Object getData() {
            return this.data;
        }
    }
}

